/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userpointsmanager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userpointsmanager.dao.UpmPointsMapper;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsReDomain;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPoints;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmPointsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UpmPointsServiceImpl
extends BaseServiceImpl
implements UpmPointsService {
    private static final String SYS_CODE = "upm.UpmPointsServiceImpl";
    private UpmPointsMapper upmPointsMapper;
    private String cachekey = "UpmPoints-type";

    public void setUpmPointsMapper(UpmPointsMapper upmPointsMapper) {
        this.upmPointsMapper = upmPointsMapper;
    }

    private Date getSysDate() {
        try {
            return this.upmPointsMapper.selectSysDate();
        }
        catch (Exception var2) {
            this.logger.error("upm.UpmPointsServiceImpl.getSysDate", (Throwable)var2);
            return null;
        }
    }

    private String checkPoints(UpmPointsDomain upmPointsDomain) {
        if (null == upmPointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upmPointsDomain.getUpointsType())) {
            msg = msg + "UpointsType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)upmPointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsDefault(UpmPoints upmPoints) {
        if (null != upmPoints) {
            if (null == upmPoints.getDataState()) {
                upmPoints.setDataState(0);
            }
            if (null == upmPoints.getGmtCreate()) {
                upmPoints.setGmtCreate(this.getSysDate());
            }
            upmPoints.setGmtModified(this.getSysDate());
            if (StringUtils.isBlank((String)upmPoints.getPointsCode())) {
                upmPoints.setPointsCode(this.createUUIDString());
            }
        }
    }

    private int getPointsMaxCode() {
        int code = 0;
        try {
            return this.upmPointsMapper.getMaxCode();
        }
        catch (Exception var3) {
            this.logger.error("upm.UpmPointsServiceImpl.getPointsMaxCode", (Throwable)var3);
            return code;
        }
    }

    private void setPointsUpdataDefault(UpmPoints upmPoints) {
        if (null != upmPoints) {
            upmPoints.setGmtModified(this.getSysDate());
        }
    }

    private void savePointsModel(UpmPoints upmPoints) throws ApiException {
        if (null != upmPoints) {
            try {
                this.upmPointsMapper.insert(upmPoints);
            }
            catch (Exception var3) {
                throw new ApiException("upm.UpmPointsServiceImpl.savePointsModel.ex", (Throwable)var3);
            }
        }
    }

    private void savePointsBatchModel(List upmPointsList) throws ApiException {
        if (null != upmPointsList && !upmPointsList.isEmpty()) {
            try {
                this.upmPointsMapper.insertBatch(upmPointsList);
            }
            catch (Exception var3) {
                throw new ApiException("upm.UpmPointsServiceImpl.savePointsBatchModel.ex", (Throwable)var3);
            }
        }
    }

    private UpmPoints getPointsModelById(Integer pointsId) {
        if (null == pointsId) {
            return null;
        }
        try {
            return this.upmPointsMapper.selectByPrimaryKey(pointsId);
        }
        catch (Exception var3) {
            this.logger.error("upm.UpmPointsServiceImpl.getPointsModelById", (Throwable)var3);
            return null;
        }
    }

    private UpmPoints getPointsModelByCode(Map map) {
        if (null != map && !map.isEmpty()) {
            try {
                return this.upmPointsMapper.getByCode(map);
            }
            catch (Exception var3) {
                this.logger.error("upm.UpmPointsServiceImpl.getPointsModelByCode", (Throwable)var3);
                return null;
            }
        }
        return null;
    }

    private void delPointsModelByCode(Map map) {
        if (null != map && !map.isEmpty()) {
            int i1;
            boolean i = false;
            try {
                i1 = this.upmPointsMapper.delByCode(map);
            }
            catch (Exception var4) {
                throw new ApiException("upm.UpmPointsServiceImpl.delPointsModelByCode.ex", (Throwable)var4);
            }
            if (1 != i1) {
                throw new ApiException("upm.UpmPointsServiceImpl.delPointsModelByCode.num");
            }
        }
    }

    private void deletePointsModel(Integer pointsId) throws ApiException {
        if (null != pointsId) {
            int i1;
            boolean i = false;
            try {
                i1 = this.upmPointsMapper.deleteByPrimaryKey(pointsId);
            }
            catch (Exception var4) {
                throw new ApiException("upm.UpmPointsServiceImpl.deletePointsModel.ex", (Throwable)var4);
            }
            if (1 != i1) {
                throw new ApiException("upm.UpmPointsServiceImpl.deletePointsModel.num");
            }
        }
    }

    private void updatePointsModel(UpmPoints upmPoints) throws ApiException {
        if (null != upmPoints) {
            int i1;
            boolean i = false;
            try {
                i1 = this.upmPointsMapper.updateByPrimaryKeySelective(upmPoints);
            }
            catch (Exception var4) {
                throw new ApiException("upm.UpmPointsServiceImpl.updatePointsModel.ex", (Throwable)var4);
            }
            if (1 != i1) {
                throw new ApiException("upm.UpmPointsServiceImpl.updatePointsModel.num");
            }
        }
    }

    private void updateStatePointsModel(Integer pointsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null != pointsId && null != dataState) {
            int i1;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("pointsId", pointsId);
            map.put("dataState", dataState);
            map.put("oldDataState", oldDataState);
            boolean i = false;
            try {
                i1 = this.upmPointsMapper.updateStateByPrimaryKey(map);
            }
            catch (Exception var7) {
                throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModel.ex", (Throwable)var7);
            }
            if (i1 <= 0) {
                throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModel.null");
            }
        }
    }

    private void updateStatePointsModelByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (!StringUtils.isBlank((String)pointsCode) && null != dataState) {
            int i1;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("pointsCode", pointsCode);
            map.put("dataState", dataState);
            map.put("oldDataState", oldDataState);
            boolean i = false;
            try {
                i1 = this.upmPointsMapper.updateStateByCode(map);
            }
            catch (Exception var8) {
                throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModelByCode.ex", (Throwable)var8);
            }
            if (i1 <= 0) {
                throw new ApiException("upm.UpmPointsServiceImpl.updateStatePointsModelByCode.null");
            }
        }
    }

    private UpmPoints makePoints(UpmPointsDomain upmPointsDomain, UpmPoints upmPoints) {
        if (null == upmPointsDomain) {
            return null;
        }
        if (null == upmPoints) {
            upmPoints = new UpmPoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upmPoints, (Object)upmPointsDomain);
            return upmPoints;
        }
        catch (Exception var4) {
            this.logger.error("upm.UpmPointsServiceImpl.makePoints", (Throwable)var4);
            return null;
        }
    }

    private UpmPointsReDomain makeUpmPointsReDomain(UpmPoints upmPoints) {
        if (null == upmPoints) {
            return null;
        }
        UpmPointsReDomain upmPointsReDomain = new UpmPointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsReDomain, (Object)upmPoints);
            return upmPointsReDomain;
        }
        catch (Exception var4) {
            this.logger.error("upm.UpmPointsServiceImpl.makeUpmPointsReDomain", (Throwable)var4);
            return null;
        }
    }

    private List queryPointsModelPage(Map parammap) {
        try {
            return this.upmPointsMapper.query(parammap);
        }
        catch (Exception var3) {
            this.logger.error("upm.UpmPointsServiceImpl.queryPointsModel", (Throwable)var3);
            return null;
        }
    }

    private int countPoints(Map map) {
        int i = 0;
        try {
            i = this.upmPointsMapper.count(map);
        }
        catch (Exception var4) {
            this.logger.error("upm.UpmPointsServiceImpl.countPoints", (Throwable)var4);
        }
        return i;
    }

    private UpmPoints createUpmPoints(UpmPointsDomain upmPointsDomain) {
        String msg = this.checkPoints(upmPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsServiceImpl.savePoints.checkPoints", msg);
        }
        UpmPoints upmPoints = this.makePoints(upmPointsDomain, null);
        this.setPointsDefault(upmPoints);
        return upmPoints;
    }

    @Override
    public String savePoints(UpmPointsDomain upmPointsDomain) throws ApiException {
        UpmPoints upmPoints = this.createUpmPoints(upmPointsDomain);
        this.savePointsModel(upmPoints);
        return upmPoints.getPointsCode();
    }

    @Override
    public String savePointsBatch(List upmPointsDomainList) throws ApiException {
        if (null != upmPointsDomainList && !upmPointsDomainList.isEmpty()) {
            ArrayList<UpmPoints> upmPointsList = new ArrayList<UpmPoints>();
            String code = "";
            for (UpmPointsDomain upmPointsDomain : upmPointsDomainList) {
                UpmPoints upmPoints = this.createUpmPoints(upmPointsDomain);
                code = upmPoints.getPointsCode();
                upmPointsList.add(upmPoints);
            }
            this.savePointsBatchModel(upmPointsList);
            return code;
        }
        return null;
    }

    @Override
    public void updatePointsState(Integer pointsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePointsModel(pointsId, dataState, oldDataState);
        this.updatePointsDisById(dataState, pointsId);
    }

    @Override
    public void updatePointsStateByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePointsModelByCode(tenantCode, pointsCode, dataState, oldDataState);
        this.updatePointsDisByCode(dataState, tenantCode, pointsCode);
    }

    @Override
    public void updatePoints(UpmPointsDomain upmPointsDomain) throws ApiException {
        String msg = this.checkPoints(upmPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsServiceImpl.updatePoints.checkPoints", msg);
        }
        UpmPoints oldUpmPoints = this.getPointsModelById(upmPointsDomain.getPointsId());
        if (null == oldUpmPoints) {
            throw new ApiException("upm.UpmPointsServiceImpl.updatePoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpmPoints upmPoints = this.makePoints(upmPointsDomain, oldUpmPoints);
        this.setPointsUpdataDefault(upmPoints);
        this.updatePointsModel(upmPoints);
        this.updatePointsDisById(upmPoints.getDataState(), upmPoints.getPointsId());
    }

    private void updatePointsDisById(Integer dataState, Integer pointsId) {
        UpmPoints upmPoints = this.getPoints(pointsId);
        if (null != upmPoints) {
            String key = upmPoints.getUpointsType() + "-" + upmPoints.getMemberMcode() + "-" + upmPoints.getLevelUserqua() + "-" + upmPoints.getTenantCode();
            if (1 == dataState) {
                DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)upmPoints));
            } else if (0 == dataState) {
                DisUtil.delMap((String)this.cachekey, (String[])new String[]{key});
            }
        }
    }

    private void updatePointsDisByCode(Integer dataState, String tenantCode, String pointsCode) {
        UpmPoints upmPoints = this.getPointsByCode(tenantCode, pointsCode);
        if (null != upmPoints) {
            String key = upmPoints.getUpointsType() + "-" + upmPoints.getMemberMcode() + "-" + upmPoints.getLevelUserqua() + "-" + upmPoints.getTenantCode();
            if (1 == dataState) {
                DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)upmPoints));
            } else if (0 == dataState) {
                DisUtil.delMap((String)this.cachekey, (String[])new String[]{key});
            }
        }
    }

    @Override
    public UpmPoints getPoints(Integer pointsId) {
        return this.getPointsModelById(pointsId);
    }

    @Override
    public void deletePoints(Integer pointsId) throws ApiException {
        this.updatePointsDisById(0, pointsId);
        this.deletePointsModel(pointsId);
    }

    @Override
    public QueryResult queryPointsPage(Map map) {
        List upmPointsList = this.queryPointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upmPointsList);
        return queryResult;
    }

    @Override
    public UpmPoints getPointsByCode(String tenantCode, String pointsCode) throws ApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        return this.getPointsModelByCode(map);
    }

    @Override
    public void deletePointsByCode(String tenantCode, String pointsCode) throws ApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        this.updatePointsDisByCode(0, tenantCode, pointsCode);
        this.delPointsModelByCode(map);
    }

    @Override
    public void queryPointsCache() {
        this.logger.info("UpmPointsServiceImpl.queryPointsCache", (Object)"===========start==========");
        HashMap<String, Integer> parammap = new HashMap<String, Integer>();
        parammap.put("dataState", 1);
        List list = this.queryPointsModelPage(parammap);
        if (null != list && !list.isEmpty()) {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            for (UpmPoints upmPoints : list) {
                if (StringUtils.isBlank((String)upmPoints.getMemberMcode())) {
                    upmPoints.setMemberMcode("all");
                }
                if (!StringUtils.isNotBlank((String)upmPoints.getUpointsType())) continue;
                String key = upmPoints.getUpointsType() + "-" + upmPoints.getMemberMcode() + "-" + upmPoints.getLevelUserqua() + "-" + upmPoints.getTenantCode();
                map.put(key, JsonUtil.buildNormalBinder().toJson((Object)upmPoints));
            }
            DisUtil.setMapVer((String)this.cachekey, map);
            this.logger.info("UpmPointsServiceImpl.queryPointsCache", (Object)"===========add-end==========");
        } else {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("UpmPointsServiceImpl.queryPointsCache", (Object)"===========del-end==========");
        }
    }
}

