/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.virtualdepositor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountOuterCtrlMapper;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDefReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDefSubsetReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountOuterCtrlDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountSubsetDomain;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountOuterCtrl;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountDefService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountInnerService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountOuterCtrlService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountOuterService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VdFaccountOuterCtrlServiceImpl
extends BaseServiceImpl
implements VdFaccountOuterCtrlService {
    public static final String SYS_CODE = "vd.VdFaccountOuterCtrlServiceImpl";
    private VdFaccountOuterCtrlMapper vdFaccountOuterCtrlMapper;
    private VdFaccountDefService vdFaccountDefService;
    private VdFaccountOuterService vdFaccountOuterService;
    private VdFaccountInnerService vdFaccountInnerService;

    public void setVdFaccountOuterService(VdFaccountOuterService vdFaccountOuterService) {
        this.vdFaccountOuterService = vdFaccountOuterService;
    }

    public void setVdFaccountInnerService(VdFaccountInnerService vdFaccountInnerService) {
        this.vdFaccountInnerService = vdFaccountInnerService;
    }

    public VdFaccountDefService getVdFaccountDefService() {
        return this.vdFaccountDefService;
    }

    public void setVdFaccountDefService(VdFaccountDefService vdFaccountDefService) {
        this.vdFaccountDefService = vdFaccountDefService;
    }

    public VdFaccountOuterCtrlMapper getVdFaccountOuterCtrlMapper() {
        return this.vdFaccountOuterCtrlMapper;
    }

    public void setVdFaccountOuterCtrlMapper(VdFaccountOuterCtrlMapper vdFaccountOuterCtrlMapper) {
        this.vdFaccountOuterCtrlMapper = vdFaccountOuterCtrlMapper;
    }

    private Date getSysDate() {
        try {
            return this.vdFaccountOuterCtrlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterCtrlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFaccountOuterCtrl(VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain) {
        if (null == vdFaccountOuterCtrlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)vdFaccountOuterCtrlDomain.getFaccountDefBatchcode()) && StringUtils.isBlank((String)vdFaccountOuterCtrlDomain.getFchannelCode())) {
            msg = msg + "\u6e20\u9053\u7f16\u7801\u6216\u6279\u53f7;";
        }
        return msg;
    }

    private void setFaccountOuterCtrlDefault(VdFaccountOuterCtrl vdFaccountOuterCtrl) {
        if (null == vdFaccountOuterCtrl) {
            return;
        }
        if (null == vdFaccountOuterCtrl.getDataState()) {
            vdFaccountOuterCtrl.setDataState(0);
        }
        if (null == vdFaccountOuterCtrl.getGmtCreate()) {
            vdFaccountOuterCtrl.setGmtCreate(this.getSysDate());
        }
        if (null == vdFaccountOuterCtrl.getFaccountOuterCtrlState()) {
            vdFaccountOuterCtrl.setFaccountOuterCtrlState(0);
        }
        vdFaccountOuterCtrl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)vdFaccountOuterCtrl.getFaccountOuterCtrlNo())) {
            vdFaccountOuterCtrl.setFaccountOuterCtrlNo(this.createUUIDString());
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.vdFaccountOuterCtrlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterCtrlServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFaccountOuterCtrlUpdataDefault(VdFaccountOuterCtrl vdFaccountOuterCtrl) {
        if (null == vdFaccountOuterCtrl) {
            return;
        }
        vdFaccountOuterCtrl.setGmtModified(this.getSysDate());
    }

    private void saveFaccountOuterCtrlModel(VdFaccountOuterCtrl vdFaccountOuterCtrl) throws ApiException {
        if (null == vdFaccountOuterCtrl) {
            return;
        }
        try {
            this.vdFaccountOuterCtrlMapper.insert(vdFaccountOuterCtrl);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.saveFaccountOuterCtrlModel.ex", (Throwable)e);
        }
    }

    private VdFaccountOuterCtrl getFaccountOuterCtrlModelById(Integer faccountOuterCtrlId) {
        if (null == faccountOuterCtrlId) {
            return null;
        }
        try {
            return this.vdFaccountOuterCtrlMapper.selectByPrimaryKey(faccountOuterCtrlId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterCtrlServiceImpl.getFaccountOuterCtrlModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountOuterCtrl getFaccountOuterCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountOuterCtrlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterCtrlServiceImpl.getFaccountOuterCtrlModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountOuterCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterCtrlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.delFaccountOuterCtrlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.delFaccountOuterCtrlModelByCode.num");
        }
    }

    private void deleteFaccountOuterCtrlModel(Integer faccountOuterCtrlId) throws ApiException {
        if (null == faccountOuterCtrlId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterCtrlMapper.deleteByPrimaryKey(faccountOuterCtrlId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.deleteFaccountOuterCtrlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.deleteFaccountOuterCtrlModel.num");
        }
    }

    private void updateFaccountOuterCtrlModel(VdFaccountOuterCtrl vdFaccountOuterCtrl) throws ApiException {
        if (null == vdFaccountOuterCtrl) {
            return;
        }
        try {
            this.vdFaccountOuterCtrlMapper.updateByPrimaryKeySelective(vdFaccountOuterCtrl);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateFaccountOuterCtrlModel.ex", (Throwable)e);
        }
    }

    private void updateStateFaccountOuterCtrlModel(Integer faccountOuterCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == faccountOuterCtrlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterCtrlId", faccountOuterCtrlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountOuterCtrlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateStateFaccountOuterCtrlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateStateFaccountOuterCtrlModel.null");
        }
    }

    private void updateStateFaccountOuterCtrlCallModel(String faccountOuterCtrlCalltxt, String faccountOuterCtrlNo, String tenantCode, Integer dataState, Integer faccountOuterCtrlState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)faccountOuterCtrlNo) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterCtrlCalltxt", faccountOuterCtrlCalltxt);
        map.put("faccountOuterCtrlNo", faccountOuterCtrlNo);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("faccountOuterCtrlState", faccountOuterCtrlState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountOuterCtrlMapper.updateCallByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateStateFaccountOuterCtrlCallModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateStateFaccountOuterCtrlCallModel.null", ((Object)map).toString());
        }
    }

    private void updateStateFaccountOuterCtrlCallStateModel(String faccountOuterCtrlNo, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)faccountOuterCtrlNo) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterCtrlNo", faccountOuterCtrlNo);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountOuterCtrlMapper.updateCallStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateStateFaccountOuterCtrlCallStateModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateStateFaccountOuterCtrlCallStateModel.null", ((Object)map).toString());
        }
    }

    private VdFaccountOuterCtrl makeFaccountOuterCtrl(VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain, VdFaccountOuterCtrl vdFaccountOuterCtrl) {
        if (null == vdFaccountOuterCtrlDomain) {
            return null;
        }
        if (null == vdFaccountOuterCtrl) {
            vdFaccountOuterCtrl = new VdFaccountOuterCtrl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterCtrl, (Object)vdFaccountOuterCtrlDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterCtrlServiceImpl.makeFaccountOuterCtrl", (Throwable)e);
        }
        return vdFaccountOuterCtrl;
    }

    private List<VdFaccountOuterCtrl> queryFaccountOuterCtrlModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterCtrlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterCtrlServiceImpl.queryFaccountOuterCtrlModel", (Throwable)e);
            return null;
        }
    }

    private int countFaccountOuterCtrl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountOuterCtrlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterCtrlServiceImpl.countFaccountOuterCtrl", (Throwable)e);
        }
        return i;
    }

    @Override
    public VdFaccountOuterCtrl saveFaccountOuterCtrl(VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain) throws ApiException {
        String msg = this.checkFaccountOuterCtrl(vdFaccountOuterCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.saveFaccountOuterCtrl.checkFaccountOuterCtrl", msg);
        }
        VdFaccountOuterCtrl vdFaccountOuterCtrl = this.makeFaccountOuterCtrl(vdFaccountOuterCtrlDomain, null);
        this.setFaccountOuterCtrlDefault(vdFaccountOuterCtrl);
        this.saveFaccountOuterCtrlModel(vdFaccountOuterCtrl);
        return vdFaccountOuterCtrl;
    }

    @Override
    public VdFaccountOuterCtrl saveSendOpenFaccount(VdFaccountOuterCtrl vdFaccountOuterCtrl) {
        String vdFaccountAbstractServiceId;
        if (null == vdFaccountOuterCtrl) {
            return null;
        }
        List defList = null;
        String faccountDefBatchcode = vdFaccountOuterCtrl.getFaccountDefBatchcode();
        String merchantCode = vdFaccountOuterCtrl.getMerchantCode();
        String merchantName = vdFaccountOuterCtrl.getMerchantName();
        String fchannelCode = vdFaccountOuterCtrl.getFchannelCode();
        String fchannelClassifyCode = vdFaccountOuterCtrl.getFchannelClassifyCode();
        String tenantCode = vdFaccountOuterCtrl.getTenantCode();
        String faccountTitileCode = vdFaccountOuterCtrl.getFaccountTitileCode();
        if (StringUtils.isBlank((String)faccountDefBatchcode)) {
            defList = this.vdFaccountDefService.queryFaccountDefByFchannelCode(fchannelCode, fchannelClassifyCode, tenantCode);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("faccountDefBatchcode", faccountDefBatchcode);
            map.put("tenantCode", tenantCode);
            QueryResult<VdFaccountDefReDomain> qlist = this.vdFaccountDefService.queryFaccountDefPage(map);
            if (null == qlist || qlist.getList() == null || qlist.getList().isEmpty()) {
                map.put("tenantCode", "00000000");
                qlist = this.vdFaccountDefService.queryFaccountDefPage(map);
            }
            if (null != qlist) {
                defList = qlist.getList();
            }
        }
        if (null == defList || defList.isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.saveOpenFaccount.defList", fchannelClassifyCode + " is null");
        }
        if (StringUtils.isBlank((String)fchannelClassifyCode)) {
            fchannelClassifyCode = defList.get(0).getFchannelClassifyCode();
        }
        if (StringUtils.isBlank((String)(vdFaccountAbstractServiceId = this.getFaccountServiceId(fchannelClassifyCode, tenantCode)))) {
            vdFaccountAbstractServiceId = this.getFaccountServiceId(fchannelClassifyCode, defList.get(0).getTenantCode());
        }
        if (StringUtils.isBlank((String)vdFaccountAbstractServiceId)) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.saveOpenFaccount.serviceid", fchannelClassifyCode + " is null");
        }
        String jsonStr = this.saveMqFaccount(vdFaccountAbstractServiceId, tenantCode, this.makeFaccountList(tenantCode, merchantCode, merchantName, faccountTitileCode, defList));
        this.updateStateFaccountOuterCtrlCallModel(jsonStr, vdFaccountOuterCtrl.getFaccountOuterCtrlNo(), tenantCode, 1, 1, 0);
        vdFaccountOuterCtrl.setFaccountOuterCtrlCalltxt(jsonStr);
        vdFaccountOuterCtrl.setFaccountOuterCtrlState(1);
        return vdFaccountOuterCtrl;
    }

    @Override
    public void saveSendCall(VdFaccountOuterCtrl vdFaccountOuterCtrl) {
        if (null == vdFaccountOuterCtrl || StringUtils.isBlank((String)vdFaccountOuterCtrl.getFaccountOuterCtrlCallurl())) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("faccountCall", vdFaccountOuterCtrl.getFaccountOuterCtrlCalltxt());
        map.put("faccountExno", vdFaccountOuterCtrl.getFaccountOuterCtrlExno());
        map.put("tenantCode", vdFaccountOuterCtrl.getTenantCode());
        this.updateStateFaccountOuterCtrlCallStateModel(vdFaccountOuterCtrl.getFaccountOuterCtrlNo(), vdFaccountOuterCtrl.getTenantCode(), 2, 1);
        this.getInternalRouter().inInvoke(vdFaccountOuterCtrl.getFaccountOuterCtrlCallurl(), "1.0", "0", map);
    }

    private List<VdFaccountDomain> makeFaccountList(String tenantCode, String merchantCode, String merchantName, String faccountTitileCode, List<VdFaccountDefReDomain> defList) {
        if (null == defList || defList.isEmpty()) {
            return null;
        }
        ArrayList<VdFaccountDomain> vdFaccountDomainList = new ArrayList<VdFaccountDomain>();
        VdFaccountDomain vdFaccountDomain = null;
        if (null == faccountTitileCode) {
            faccountTitileCode = "";
        }
        for (VdFaccountDefReDomain vdFaccountDefReDomain : defList) {
            vdFaccountDomain = new VdFaccountDomain();
            vdFaccountDomain.setFaccountName(vdFaccountDefReDomain.getFaccountDefName());
            vdFaccountDomain.setTenantCode(tenantCode);
            vdFaccountDomain.setMerchantCode(merchantCode);
            vdFaccountDomain.setMerchantName(merchantName);
            vdFaccountDomain.setCurrencyCode(vdFaccountDefReDomain.getCurrencyCode());
            vdFaccountDomain.setFaccountLevel(vdFaccountDefReDomain.getFaccountLevel());
            vdFaccountDomain.setFaccountAttribute(vdFaccountDefReDomain.getFaccountAttribute());
            vdFaccountDomain.setFundType(vdFaccountDefReDomain.getFundType());
            if (StringUtils.isNotBlank((String)vdFaccountDefReDomain.getFaccountTitileCode())) {
                vdFaccountDomain.setFaccountTitileCode(vdFaccountDefReDomain.getFaccountTitileCode().replace("{titileCode}", faccountTitileCode));
            } else {
                vdFaccountDomain.setFaccountTitileCode(faccountTitileCode);
            }
            vdFaccountDomain.setFaccountType(vdFaccountDefReDomain.getFaccountType());
            vdFaccountDomain.setFaccountDirection(vdFaccountDefReDomain.getFaccountDirection());
            vdFaccountDomain.setSubsetList(this.makeFaccountSubsetList(vdFaccountDefReDomain, tenantCode));
            vdFaccountDomainList.add(vdFaccountDomain);
        }
        return vdFaccountDomainList;
    }

    private List<VdFaccountSubsetDomain> makeFaccountSubsetList(VdFaccountDefReDomain vdFaccountDefReDomain, String tenantCode) {
        if (null == vdFaccountDefReDomain || null == vdFaccountDefReDomain.getDefSubList() || vdFaccountDefReDomain.getDefSubList().isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.makeFaccountSubsetList.null", "null");
        }
        ArrayList<VdFaccountSubsetDomain> vdFaccountSubsetDomainList = new ArrayList<VdFaccountSubsetDomain>();
        VdFaccountSubsetDomain vdFaccountSubsetDomain = null;
        for (VdFaccountDefSubsetReDomain vdFaccountDefSubsetReDomain : vdFaccountDefReDomain.getDefSubList()) {
            vdFaccountSubsetDomain = new VdFaccountSubsetDomain();
            vdFaccountSubsetDomain.setTenantCode(tenantCode);
            vdFaccountSubsetDomain.setCurrencyCode(vdFaccountDefSubsetReDomain.getCurrencyCode());
            vdFaccountSubsetDomain.setFaccountTitileCode(vdFaccountDefSubsetReDomain.getFaccountTitileCode());
            vdFaccountSubsetDomain.setFaccountDirection(vdFaccountDefSubsetReDomain.getFaccountDirection());
            vdFaccountSubsetDomain.setFundType(vdFaccountDefSubsetReDomain.getFundType());
            vdFaccountSubsetDomainList.add(vdFaccountSubsetDomain);
        }
        return vdFaccountSubsetDomainList;
    }

    private String getFaccountServiceId(String fchannelClassifyCode, String tenantCode) {
        String serviecid = DisUtil.getMap((String)"FaccountType_serviceid", (String)(fchannelClassifyCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)serviecid)) {
            serviecid = DisUtil.getMap((String)"FaccountType_serviceid", (String)(fchannelClassifyCode + "-" + "00000000"));
        }
        return serviecid;
    }

    private String saveMqFaccount(String vdFaccountAbstractServiceId, String tenantCode, List<VdFaccountDomain> vdFaccountDomainList) {
        if (null == vdFaccountDomainList || vdFaccountDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.saveMqFaccount.pnull", " null");
        }
        List reVdFaccountDomainList = null;
        reVdFaccountDomainList = "vdFaccountInnerService".equals(vdFaccountAbstractServiceId) ? this.vdFaccountInnerService.saveOpenFaccount(vdFaccountDomainList) : this.vdFaccountOuterService.saveOpenFaccount(vdFaccountDomainList);
        return JsonUtil.buildNormalBinder().toJson((Object)reVdFaccountDomainList);
    }

    @Override
    public void updateFaccountOuterCtrlState(Integer faccountOuterCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountOuterCtrlModel(faccountOuterCtrlId, dataState, oldDataState);
    }

    @Override
    public void updateFaccountOuterCtrl(VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain) throws ApiException {
        String msg = this.checkFaccountOuterCtrl(vdFaccountOuterCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateFaccountOuterCtrl.checkFaccountOuterCtrl", msg);
        }
        VdFaccountOuterCtrl oldVdFaccountOuterCtrl = this.getFaccountOuterCtrlModelById(vdFaccountOuterCtrlDomain.getFaccountOuterCtrlId());
        if (null == oldVdFaccountOuterCtrl) {
            throw new ApiException("vd.VdFaccountOuterCtrlServiceImpl.updateFaccountOuterCtrl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountOuterCtrl vdFaccountOuterCtrl = this.makeFaccountOuterCtrl(vdFaccountOuterCtrlDomain, oldVdFaccountOuterCtrl);
        this.setFaccountOuterCtrlUpdataDefault(vdFaccountOuterCtrl);
        this.updateFaccountOuterCtrlModel(vdFaccountOuterCtrl);
    }

    @Override
    public VdFaccountOuterCtrl getFaccountOuterCtrl(Integer faccountOuterCtrlId) {
        return this.getFaccountOuterCtrlModelById(faccountOuterCtrlId);
    }

    @Override
    public void deleteFaccountOuterCtrl(Integer faccountOuterCtrlId) throws ApiException {
        this.deleteFaccountOuterCtrlModel(faccountOuterCtrlId);
    }

    @Override
    public QueryResult<VdFaccountOuterCtrl> queryFaccountOuterCtrlPage(Map<String, Object> map) {
        List<VdFaccountOuterCtrl> vdFaccountOuterCtrlList = this.queryFaccountOuterCtrlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountOuterCtrl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountOuterCtrlList);
        return queryResult;
    }
}

