/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wa.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.wa.dao.WaWaiterMapper;
import com.yqbsoft.laser.service.wa.domain.OcContractDomain;
import com.yqbsoft.laser.service.wa.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.wa.domain.WaWaiterDomain;
import com.yqbsoft.laser.service.wa.domain.WaWaiterGoodsDomain;
import com.yqbsoft.laser.service.wa.domain.WaWaiterReDomain;
import com.yqbsoft.laser.service.wa.model.WaWaiter;
import com.yqbsoft.laser.service.wa.service.WaWaiterGoodsService;
import com.yqbsoft.laser.service.wa.service.WaWaiterService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WaWaiterServiceImpl
extends BaseServiceImpl
implements WaWaiterService {
    private static final String SYS_CODE = "wa.WaWaiterServiceImpl";
    private WaWaiterMapper waWaiterMapper;
    WaWaiterGoodsService waWaiterGoodsService;

    public void setWaWaiterMapper(WaWaiterMapper waWaiterMapper) {
        this.waWaiterMapper = waWaiterMapper;
    }

    public void setWaWaiterGoodsService(WaWaiterGoodsService waWaiterGoodsService) {
        this.waWaiterGoodsService = waWaiterGoodsService;
    }

    private Date getSysDate() {
        try {
            return this.waWaiterMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWaiter(WaWaiterDomain waWaiterDomain) {
        if (null == waWaiterDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)waWaiterDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setWaiterDefault(WaWaiter waWaiter) {
        if (null == waWaiter) {
            return;
        }
        if (null == waWaiter.getDataState()) {
            waWaiter.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == waWaiter.getGmtCreate()) {
            waWaiter.setGmtCreate(date);
        }
        waWaiter.setGmtModified(date);
        if (StringUtils.isBlank((String)waWaiter.getWaiterCode())) {
            waWaiter.setWaiterCode(this.getNo(null, "WaWaiter", "waWaiter", waWaiter.getTenantCode()));
        }
    }

    private int getWaiterMaxCode() {
        int code = 0;
        try {
            return this.waWaiterMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getWaiterMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWaiterUpdataDefault(WaWaiter waWaiter) {
        if (null == waWaiter) {
            return;
        }
        waWaiter.setGmtModified(this.getSysDate());
    }

    private void saveWaiterModel(WaWaiter waWaiter) throws ApiException {
        if (null == waWaiter) {
            return;
        }
        try {
            this.waWaiterMapper.insert(waWaiter);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.saveWaiterModel.ex", (Throwable)e);
        }
    }

    private void saveWaiterBatchModel(List<WaWaiter> waWaiterList) throws ApiException {
        if (null == waWaiterList || waWaiterList.isEmpty()) {
            return;
        }
        try {
            this.waWaiterMapper.insertBatch(waWaiterList);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.saveWaiterBatchModel.ex", (Throwable)e);
        }
    }

    private WaWaiter getWaiterModelById(Integer waiterId) {
        if (null == waiterId) {
            return null;
        }
        try {
            return this.waWaiterMapper.selectByPrimaryKey(waiterId);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getWaiterModelById", (Throwable)e);
            return null;
        }
    }

    private WaWaiter getWaiterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.waWaiterMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getWaiterModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delWaiterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.delWaiterModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wa.WaWaiterServiceImpl.delWaiterModelByCode.num");
        }
    }

    private void deleteWaiterModel(Integer waiterId) throws ApiException {
        if (null == waiterId) {
            return;
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.deleteByPrimaryKey(waiterId);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.deleteWaiterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wa.WaWaiterServiceImpl.deleteWaiterModel.num");
        }
    }

    private void updateWaiterModel(WaWaiter waWaiter) throws ApiException {
        if (null == waWaiter) {
            return;
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.updateByPrimaryKey(waWaiter);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiterModel.num");
        }
    }

    private void updateStateWaiterModel(Integer waiterId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == waiterId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("waiterId", waiterId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModel.null");
        }
    }

    private void updateStateWaiterModelByCode(String tenantCode, String waiterCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("waiterCode", waiterCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModelByCode.null");
        }
    }

    private WaWaiter makeWaiter(WaWaiterDomain waWaiterDomain, WaWaiter waWaiter) {
        if (null == waWaiterDomain) {
            return null;
        }
        if (null == waWaiter) {
            waWaiter = new WaWaiter();
        }
        try {
            BeanUtils.copyAllPropertys((Object)waWaiter, (Object)waWaiterDomain);
            return waWaiter;
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.makeWaiter", (Throwable)e);
            return null;
        }
    }

    private WaWaiterReDomain makeWaWaiterReDomain(WaWaiter waWaiter) {
        if (null == waWaiter) {
            return null;
        }
        WaWaiterReDomain waWaiterReDomain = new WaWaiterReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)waWaiterReDomain, (Object)waWaiter);
            return waWaiterReDomain;
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.makeWaWaiterReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WaWaiter> queryWaiterModelPage(Map<String, Object> parammap) {
        try {
            return this.waWaiterMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.queryWaiterModel", (Throwable)e);
            return null;
        }
    }

    private int countWaiter(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.waWaiterMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.countWaiter", (Throwable)e);
        }
        return i;
    }

    private WaWaiter createWaWaiter(WaWaiterDomain waWaiterDomain) {
        String msg = this.checkWaiter(waWaiterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wa.WaWaiterServiceImpl.saveWaiter.checkWaiter", msg);
        }
        WaWaiter waWaiter = this.makeWaiter(waWaiterDomain, null);
        this.setWaiterDefault(waWaiter);
        return waWaiter;
    }

    @Override
    public String saveWaiter(WaWaiterDomain waWaiterDomain) throws ApiException {
        WaWaiter waWaiter = this.createWaWaiter(waWaiterDomain);
        this.saveWaiterModel(waWaiter);
        return waWaiter.getWaiterCode();
    }

    @Override
    public String saveWaiterBatch(List<WaWaiterDomain> waWaiterDomainList) throws ApiException {
        if (null == waWaiterDomainList || waWaiterDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WaWaiter> waWaiterList = new ArrayList<WaWaiter>();
        String code = "";
        for (WaWaiterDomain waWaiterDomain : waWaiterDomainList) {
            WaWaiter waWaiter = this.createWaWaiter(waWaiterDomain);
            code = waWaiter.getWaiterCode();
            waWaiterList.add(waWaiter);
        }
        this.saveWaiterBatchModel(waWaiterList);
        return code;
    }

    @Override
    public void updateWaiterState(Integer waiterId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == waiterId) {
            return;
        }
        this.updateStateWaiterModel(waiterId, dataState, oldDataState, map);
    }

    @Override
    public void updateWaiterStateByCode(String tenantCode, String waiterCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateWaiterModelByCode(tenantCode, waiterCode, dataState, oldDataState, map);
    }

    @Override
    public void updateWaiter(WaWaiterDomain waWaiterDomain) throws ApiException {
        String msg = this.checkWaiter(waWaiterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiter.checkWaiter", msg);
        }
        WaWaiter oldWaWaiter = this.getWaiterModelById(waWaiterDomain.getWaiterId());
        if (null == oldWaWaiter) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiter.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WaWaiter waWaiter = this.makeWaiter(waWaiterDomain, oldWaWaiter);
        this.setWaiterUpdataDefault(waWaiter);
        this.updateWaiterModel(waWaiter);
    }

    @Override
    public WaWaiter getWaiter(Integer waiterId) {
        if (null == waiterId) {
            return null;
        }
        return this.getWaiterModelById(waiterId);
    }

    @Override
    public void deleteWaiter(Integer waiterId) throws ApiException {
        if (null == waiterId) {
            return;
        }
        this.deleteWaiterModel(waiterId);
    }

    @Override
    public QueryResult<WaWaiter> queryWaiterPage(Map<String, Object> map) {
        List<WaWaiter> waWaiterList = this.queryWaiterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWaiter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(waWaiterList);
        return queryResult;
    }

    @Override
    public WaWaiter getWaiterByCode(String tenantCode, String waiterCode) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("waiterCode", waiterCode);
        return this.getWaiterModelByCode(map);
    }

    @Override
    public void deleteWaiterByCode(String tenantCode, String waiterCode) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("waiterCode", waiterCode);
        this.delWaiterModelByCode(map);
    }

    @Override
    public String sendOrderServiceTicket(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return null;
        }
        WaWaiterDomain waWaiterDomain = new WaWaiterDomain();
        try {
            BeanUtils.copyAllPropertys((Object)waWaiterDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.sendOrderServiceTicket", (Throwable)e);
        }
        waWaiterDomain.setWaiterVaildate(ocContractDomain.getContractValidate());
        waWaiterDomain.setWaiterGddate(ocContractDomain.getContractEffectivedate());
        String s = this.saveWaiter(waWaiterDomain);
        ArrayList<WaWaiterGoodsDomain> waWaiterGoodsDomainList = new ArrayList<WaWaiterGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            WaWaiterGoodsDomain waWaiterGoodsDomain = new WaWaiterGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)waWaiterGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("wa.WaWaiterServiceImpl.sendOrderServiceTicket", (Throwable)e);
            }
            waWaiterGoodsDomainList.add(waWaiterGoodsDomain);
            this.waWaiterGoodsService.saveWaiterGoodsBatch(waWaiterGoodsDomainList);
        }
        return "success";
    }
}

