/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhStoreGoodsMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhStoreSkuMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuDomain;
import com.yqbsoft.laser.service.warehouse.model.WhStoreGoods;
import com.yqbsoft.laser.service.warehouse.model.WhStoreSku;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhStoreGoodsServiceImpl
extends BaseServiceImpl
implements WhStoreGoodsService {
    private static final String SYS_CODE = "wh.WhStoreGoodsService";
    private WhStoreGoodsMapper whStoreGoodsMapper;
    private WhStoreSkuMapper whStoreSkuMapper;

    public void setWhStoreGoodsMapper(WhStoreGoodsMapper whStoreGoodsMapper) {
        this.whStoreGoodsMapper = whStoreGoodsMapper;
    }

    public void setWhStoreSkuMapper(WhStoreSkuMapper whStoreSkuMapper) {
        this.whStoreSkuMapper = whStoreSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.whStoreGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreGoodsDefault(WhStoreGoods whStoreGoods) {
        if (null == whStoreGoods) {
            return;
        }
        if (null == whStoreGoods.getDataState()) {
            whStoreGoods.setDataState(0);
        }
        if (null == whStoreGoods.getGmtCreate()) {
            whStoreGoods.setGmtCreate(this.getSysDate());
        }
        whStoreGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)whStoreGoods.getStoreGoodsCode())) {
            whStoreGoods.setStoreGoodsCode(this.createUUIDString());
        }
    }

    private int getStoreGoodsMaxCode() {
        int code = 0;
        try {
            return this.whStoreGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreGoodsUpdataDefault(WhStoreGoods whStoreGoods) {
        if (null == whStoreGoods) {
            return;
        }
        whStoreGoods.setGmtModified(this.getSysDate());
    }

    private void saveStoreGoodsModel(WhStoreGoods whStoreGoods) throws ApiException {
        if (null == whStoreGoods) {
            return;
        }
        try {
            this.whStoreGoodsMapper.insert(whStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private WhStoreGoods getStoreGoodsModelById(Integer storeGoodsId) {
        if (null == storeGoodsId) {
            return null;
        }
        try {
            return this.whStoreGoodsMapper.selectByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public WhStoreGoods getStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whStoreGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreGoodsModelByCode.num");
        }
    }

    private void deleteStoreGoodsModel(Integer storeGoodsId) throws ApiException {
        if (null == storeGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.deleteByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreGoodsModel.num");
        }
    }

    private void updateStoreGoodsModel(WhStoreGoods whStoreGoods) throws ApiException {
        if (null == whStoreGoods) {
            return;
        }
        try {
            this.whStoreGoodsMapper.updateByPrimaryKeySelective(whStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateStoreGoodsModel(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeGoodsId", storeGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.null");
        }
    }

    private WhStoreGoods makeStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain, WhStoreGoods whStoreGoods) {
        if (null == whStoreGoodsDomain) {
            return null;
        }
        if (null == whStoreGoods) {
            whStoreGoods = new WhStoreGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoods, (Object)whStoreGoodsDomain);
            return whStoreGoods;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.makeStoreGoods", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreGoods> queryStoreGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.countStoreGoods", (Throwable)e);
        }
        return i;
    }

    private String checkStoreSku(WhStoreSkuDomain whStoreSkuDomain) {
        if (null == whStoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreSkuDefault(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        if (null == whStoreSku.getDataState()) {
            whStoreSku.setDataState(0);
        }
        if (null == whStoreSku.getGmtCreate()) {
            whStoreSku.setGmtCreate(this.getSysDate());
        }
        whStoreSku.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)whStoreSku.getStoreSkuCode())) {
            whStoreSku.setStoreSkuCode(this.createUUIDString());
        }
    }

    private int getStoreSkuMaxCode() {
        int code = 0;
        try {
            return this.whStoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreSkuUpdataDefault(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        whStoreSku.setGmtModified(this.getSysDate());
    }

    private void saveStoreSkuModel(WhStoreSku whStoreSku) throws ApiException {
        if (null == whStoreSku) {
            return;
        }
        try {
            this.whStoreSkuMapper.insert(whStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSkuModel.ex", (Throwable)e);
        }
    }

    private WhStoreSku getStoreSkuModelById(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        try {
            return this.whStoreSkuMapper.selectByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    public WhStoreSku getStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whStoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreSkuModelByCode.num");
        }
    }

    private void deleteStoreSkuModel(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.deleteByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreSkuModel.num");
        }
    }

    private void updateStoreSkuModel(WhStoreSku whStoreSku) throws ApiException {
        if (null == whStoreSku) {
            return;
        }
        try {
            this.whStoreSkuMapper.updateByPrimaryKeySelective(whStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void updateStateStoreSkuModel(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuId", storeSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreSkuModel.null");
        }
    }

    private WhStoreSku makeStoreSku(WhStoreSkuDomain whStoreSkuDomain, WhStoreSku whStoreSku) {
        if (null == whStoreSkuDomain) {
            return null;
        }
        if (null == whStoreSku) {
            whStoreSku = new WhStoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSku, (Object)whStoreSkuDomain);
            return whStoreSku;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.makeStoreSku", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreSku> queryStoreSkuModelPage(Map<String, Object> parammap) {
        try {
            return this.whStoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.countStoreSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        String msg = this.checkStoreGoods(whStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoods.checkStoreGoods", msg);
        }
        WhStoreGoods whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, null);
        this.setStoreGoodsDefault(whStoreGoods);
        this.saveStoreGoodsModel(whStoreGoods);
        if (whStoreGoodsDomain.getStockSkulist() != null && whStoreGoodsDomain.getStockSkulist().size() != 0) {
            for (WhStoreSkuDomain whStoreSkuDomain : whStoreGoodsDomain.getStockSkulist()) {
                whStoreSkuDomain.setStoreGoodsCode(whStoreGoods.getStoreGoodsCode());
                this.saveStoreSku(whStoreSkuDomain);
            }
        }
        return whStoreGoods.getStoreGoodsCode();
    }

    @Override
    public void updateStoreGoodsState(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreGoodsModel(storeGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        String msg = this.checkStoreGoods(whStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoods.checkStoreGoods", msg);
        }
        WhStoreGoods oldWhStoreGoods = this.getStoreGoodsModelById(whStoreGoodsDomain.getStoreGoodsId());
        if (null == oldWhStoreGoods) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhStoreGoods whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, oldWhStoreGoods);
        this.setStoreGoodsUpdataDefault(whStoreGoods);
        this.updateStoreGoodsModel(whStoreGoods);
    }

    @Override
    public WhStoreGoods getStoreGoods(Integer storeGoodsId) {
        return this.getStoreGoodsModelById(storeGoodsId);
    }

    @Override
    public void deleteStoreGoods(Integer storeGoodsId) throws ApiException {
        this.deleteStoreGoodsModel(storeGoodsId);
    }

    @Override
    public QueryResult<WhStoreGoods> queryStoreGoodsPage(Map<String, Object> map) {
        List<WhStoreGoods> whStoreGoodsList = this.queryStoreGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreGoodsList);
        return queryResult;
    }

    @Override
    public WhStoreGoods getStoreGoodsByCode(Map<String, Object> map) {
        return this.getStoreGoodsModelByCode(map);
    }

    @Override
    public void delStoreGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delStoreGoodsModelByCode(map);
    }

    @Override
    public String saveStoreSku(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(whStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSku.checkStoreSku", msg);
        }
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, null);
        this.setStoreSkuDefault(whStoreSku);
        this.saveStoreSkuModel(whStoreSku);
        return whStoreSku.getStoreSkuCode();
    }

    @Override
    public void updateStoreSkuState(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreSkuModel(storeSkuId, dataState, oldDataState);
    }

    @Override
    public void updateStoreSku(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(whStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSku.checkStoreSku", msg);
        }
        WhStoreSku oldWhStoreSku = this.getStoreSkuModelById(whStoreSkuDomain.getStoreSkuId());
        if (null == oldWhStoreSku && null == (oldWhStoreSku = this.getStoreSkuModelByCode(this.getQueryMapParam("storeSkuCode,tenantCode", new Object[]{whStoreSkuDomain.getStoreSkuCode(), whStoreSkuDomain.getTenantCode()})))) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, oldWhStoreSku);
        this.setStoreSkuUpdataDefault(whStoreSku);
        this.updateStoreSkuModel(whStoreSku);
    }

    @Override
    public WhStoreSku getStoreSku(Integer storeSkuId) {
        return this.getStoreSkuModelById(storeSkuId);
    }

    @Override
    public void deleteStoreSku(Integer storeSkuId) throws ApiException {
        this.deleteStoreSkuModel(storeSkuId);
    }

    @Override
    public QueryResult<WhStoreSku> queryStoreSkuPage(Map<String, Object> map) {
        List<WhStoreSku> whStoreSkuList = this.queryStoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreSkuList);
        return queryResult;
    }

    @Override
    public WhStoreSku getStoreSkuByCode(Map<String, Object> map) {
        return this.getStoreSkuModelByCode(map);
    }

    @Override
    public void delStoreSkuByCode(Map<String, Object> map) throws ApiException {
        this.delStoreSkuModelByCode(map);
    }

    @Override
    public void updateStoreSkuStateByCode(Map<String, Object> map) {
        this.updateStateByCode(map);
    }

    private void updateStateByCode(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.null");
        }
    }
}

