/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhDgnumListMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhDgnumMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhDgnumDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhDgnumListDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhDgnumListReDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhDgnumReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhDgnum;
import com.yqbsoft.laser.service.warehouse.model.WhDgnumList;
import com.yqbsoft.laser.service.warehouse.service.WhDgnumService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WhDgnumServiceImpl
extends BaseServiceImpl
implements WhDgnumService {
    private static final String SYS_CODE = "wh.WhDgnumServiceImpl";
    private WhDgnumMapper whDgnumMapper;
    private WhDgnumListMapper whDgnumListMapper;
    private String cachekey = "WhDgnumList-memberCode";

    public void setWhDgnumMapper(WhDgnumMapper whDgnumMapper) {
        this.whDgnumMapper = whDgnumMapper;
    }

    public void setWhDgnumListMapper(WhDgnumListMapper whDgnumListMapper) {
        this.whDgnumListMapper = whDgnumListMapper;
    }

    private Date getSysDate() {
        try {
            return this.whDgnumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDgnum(WhDgnumDomain whDgnumDomain) {
        if (null == whDgnumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whDgnumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgnumDefault(WhDgnum whDgnum) {
        if (null == whDgnum) {
            return;
        }
        if (null == whDgnum.getDataState()) {
            whDgnum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whDgnum.getGmtCreate()) {
            whDgnum.setGmtCreate(date);
        }
        whDgnum.setGmtModified(date);
        if (StringUtils.isBlank((String)whDgnum.getDgnumCode())) {
            whDgnum.setDgnumCode(this.getNo(null, "WhDgnum", "whDgnum", whDgnum.getTenantCode()));
        }
        if (StringUtils.isBlank((String)whDgnum.getMemberCode())) {
            whDgnum.setMemberCode("all");
        }
    }

    private int getDgnumMaxCode() {
        int code = 0;
        try {
            return this.whDgnumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.getDgnumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgnumUpdataDefault(WhDgnum whDgnum) {
        if (null == whDgnum) {
            return;
        }
        whDgnum.setGmtModified(this.getSysDate());
    }

    private void saveDgnumModel(WhDgnum whDgnum) throws ApiException {
        if (null == whDgnum) {
            return;
        }
        try {
            this.whDgnumMapper.insert(whDgnum);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.saveDgnumModel.ex", (Throwable)e);
        }
    }

    public void saveDgnumBatchModel(List<WhDgnum> whDgnumList) throws ApiException {
        if (null == whDgnumList || whDgnumList.isEmpty()) {
            return;
        }
        try {
            this.whDgnumMapper.insertBatch(whDgnumList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.saveDgnumBatchModel.ex", (Throwable)e);
        }
    }

    private WhDgnum getDgnumModelById(Integer dgnumId) {
        if (null == dgnumId) {
            return null;
        }
        try {
            return this.whDgnumMapper.selectByPrimaryKey(dgnumId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.getDgnumModelById", (Throwable)e);
            return null;
        }
    }

    private WhDgnum getDgnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whDgnumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.getDgnumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whDgnumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.delDgnumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhDgnumServiceImpl.delDgnumModelByCode.num");
        }
    }

    private void deleteDgnumModel(Integer dgnumId) throws ApiException {
        if (null == dgnumId) {
            return;
        }
        int i = 0;
        try {
            i = this.whDgnumMapper.deleteByPrimaryKey(dgnumId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.deleteDgnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhDgnumServiceImpl.deleteDgnumModel.num");
        }
    }

    private void updateDgnumModel(WhDgnum whDgnum) throws ApiException {
        if (null == whDgnum) {
            return;
        }
        int i = 0;
        try {
            i = this.whDgnumMapper.updateByPrimaryKey(whDgnum);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnumModel.num");
        }
    }

    private void updateStateDgnumModel(Integer dgnumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgnumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumId", dgnumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whDgnumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumModel.null");
        }
    }

    private void updateStateDgnumModelByCode(String tenantCode, String dgnumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumCode", dgnumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whDgnumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumModelByCode.null");
        }
    }

    private WhDgnum makeDgnum(WhDgnumDomain whDgnumDomain, WhDgnum whDgnum) {
        if (null == whDgnumDomain) {
            return null;
        }
        if (null == whDgnum) {
            whDgnum = new WhDgnum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whDgnum, (Object)whDgnumDomain);
            return whDgnum;
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.makeDgnum", (Throwable)e);
            return null;
        }
    }

    private WhDgnumReDomain makeWhDgnumReDomain(WhDgnum whDgnum) {
        if (null == whDgnum) {
            return null;
        }
        WhDgnumReDomain whDgnumReDomain = new WhDgnumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whDgnumReDomain, (Object)whDgnum);
            return whDgnumReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.makeWhDgnumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhDgnum> queryDgnumModelPage(Map<String, Object> parammap) {
        try {
            return this.whDgnumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.queryDgnumModel", (Throwable)e);
            return null;
        }
    }

    private int countDgnum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whDgnumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.countDgnum", (Throwable)e);
        }
        return i;
    }

    private WhDgnum createWhDgnum(WhDgnumDomain whDgnumDomain) {
        String msg = this.checkDgnum(whDgnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhDgnumServiceImpl.saveDgnum.checkDgnum", msg);
        }
        WhDgnum whDgnum = this.makeDgnum(whDgnumDomain, null);
        this.setDgnumDefault(whDgnum);
        return whDgnum;
    }

    private String checkDgnumList(WhDgnumListDomain whDgnumListDomain) {
        if (null == whDgnumListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whDgnumListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgnumListDefault(WhDgnumList whDgnumList) {
        if (null == whDgnumList) {
            return;
        }
        if (null == whDgnumList.getDataState()) {
            whDgnumList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whDgnumList.getGmtCreate()) {
            whDgnumList.setGmtCreate(date);
        }
        whDgnumList.setGmtModified(date);
        if (StringUtils.isBlank((String)whDgnumList.getDgnumListCode())) {
            whDgnumList.setDgnumListCode(this.getNo(null, "WhDgnumList", "whDgnumList", whDgnumList.getTenantCode()));
        }
    }

    private int getDgnumListMaxCode() {
        int code = 0;
        try {
            return this.whDgnumListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.getDgnumListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgnumListUpdataDefault(WhDgnumList whDgnumList) {
        if (null == whDgnumList) {
            return;
        }
        whDgnumList.setGmtModified(this.getSysDate());
    }

    private void saveDgnumListModel(WhDgnumList whDgnumList) throws ApiException {
        if (null == whDgnumList) {
            return;
        }
        try {
            this.whDgnumListMapper.insert(whDgnumList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.saveDgnumListModel.ex", (Throwable)e);
        }
    }

    private void saveDgnumListBatchModel(List<WhDgnumList> whDgnumListList) throws ApiException {
        if (null == whDgnumListList || whDgnumListList.isEmpty()) {
            return;
        }
        try {
            this.whDgnumListMapper.insertBatch(whDgnumListList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.saveDgnumListBatchModel.ex", (Throwable)e);
        }
    }

    private WhDgnumList getDgnumListModelById(Integer dgnumListId) {
        if (null == dgnumListId) {
            return null;
        }
        try {
            return this.whDgnumListMapper.selectByPrimaryKey(dgnumListId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.getDgnumListModelById", (Throwable)e);
            return null;
        }
    }

    private WhDgnumList getDgnumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whDgnumListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.getDgnumListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgnumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whDgnumListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.delDgnumListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhDgnumServiceImpl.delDgnumListModelByCode.num");
        }
    }

    private void delModelByDgnumCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.whDgnumListMapper.delByDgnumCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.delModelByDgnumCode.ex", (Throwable)e);
        }
    }

    private void deleteDgnumListModel(Integer dgnumListId) throws ApiException {
        if (null == dgnumListId) {
            return;
        }
        int i = 0;
        try {
            i = this.whDgnumListMapper.deleteByPrimaryKey(dgnumListId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.deleteDgnumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhDgnumServiceImpl.deleteDgnumListModel.num");
        }
    }

    private void updateDgnumListModel(WhDgnumList whDgnumList) throws ApiException {
        if (null == whDgnumList) {
            return;
        }
        int i = 0;
        try {
            i = this.whDgnumListMapper.updateByPrimaryKey(whDgnumList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnumListModel.num");
        }
    }

    private void updateStateDgnumListModel(Integer dgnumListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgnumListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumListId", dgnumListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whDgnumListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumListModel.null");
        }
    }

    private void updateStateDgnumListModelByCode(String tenantCode, String dgnumListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumListCode", dgnumListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whDgnumListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateStateDgnumListModelByCode.null");
        }
    }

    private WhDgnumList makeDgnumList(WhDgnumListDomain whDgnumListDomain, WhDgnumList whDgnumList) {
        if (null == whDgnumListDomain) {
            return null;
        }
        if (null == whDgnumList) {
            whDgnumList = new WhDgnumList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whDgnumList, (Object)whDgnumListDomain);
            return whDgnumList;
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.makeDgnumList", (Throwable)e);
            return null;
        }
    }

    private WhDgnumListReDomain makeWhDgnumListReDomain(WhDgnumList whDgnumList) {
        if (null == whDgnumList) {
            return null;
        }
        WhDgnumListReDomain whDgnumListReDomain = new WhDgnumListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whDgnumListReDomain, (Object)whDgnumList);
            return whDgnumListReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.makeWhDgnumListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhDgnumList> queryDgnumListModelPage(Map<String, Object> parammap) {
        try {
            return this.whDgnumListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.queryDgnumListModel", (Throwable)e);
            return null;
        }
    }

    private int countDgnumList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whDgnumListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhDgnumServiceImpl.countDgnumList", (Throwable)e);
        }
        return i;
    }

    private WhDgnumList createWhDgnumList(WhDgnumListDomain whDgnumListDomain) {
        String msg = this.checkDgnumList(whDgnumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhDgnumServiceImpl.saveDgnumList.checkDgnumList", msg);
        }
        WhDgnumList whDgnumList = this.makeDgnumList(whDgnumListDomain, null);
        this.setDgnumListDefault(whDgnumList);
        return whDgnumList;
    }

    @Override
    public String saveDgnum(WhDgnumDomain whDgnumDomain) throws ApiException {
        WhDgnum whDgnum = this.createWhDgnum(whDgnumDomain);
        this.saveDgnumModel(whDgnum);
        this.updateDgnumCache(whDgnum);
        this.saveDgnumListDomain(whDgnumDomain.getWhDgnumListDomainList(), whDgnum);
        return whDgnum.getDgnumCode();
    }

    private void saveDgnumListDomain(List<WhDgnumListDomain> whDgnumListDomainList, WhDgnum whDgnum) {
        if (ListUtil.isEmpty(whDgnumListDomainList) || null == whDgnum) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumCode", whDgnum.getDgnumCode());
        map.put("tenantCode", whDgnum.getTenantCode());
        this.delModelByDgnumCode(map);
        for (WhDgnumListDomain whDgnumListDomain : whDgnumListDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)whDgnumListDomain, (Object)whDgnum);
            }
            catch (Exception e) {}
        }
        this.saveDgnumListBatch(whDgnumListDomainList);
    }

    private void updateDgnumListDomain(List<WhDgnumListDomain> whDgnumListDomainList, WhDgnum whDgnum) {
        if (ListUtil.isEmpty(whDgnumListDomainList) || null == whDgnum) {
            return;
        }
        this.delModelByDgnumCode(this.getQueryMapParam("dgnumCode,tenantCode", new Object[]{whDgnum.getDgnumCode(), whDgnum.getTenantCode()}));
        this.saveDgnumListDomain(whDgnumListDomainList, whDgnum);
    }

    @Override
    public String saveDgnumBatch(List<WhDgnumDomain> whDgnumDomainList) throws ApiException {
        if (null == whDgnumDomainList || whDgnumDomainList.isEmpty()) {
            return null;
        }
        for (WhDgnumDomain whDgnumDomain : whDgnumDomainList) {
            this.saveDgnum(whDgnumDomain);
        }
        return "";
    }

    @Override
    public void updateDgnumState(Integer dgnumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgnumId) {
            return;
        }
        this.updateStateDgnumModel(dgnumId, dataState, oldDataState, map);
        if (dataState == 0 && oldDataState != 0) {
            WhDgnum whDgnum = this.getDgnumModelById(dgnumId);
            this.updateDgnumCache(whDgnum);
        } else if (oldDataState == 0 && dataState != 0) {
            WhDgnum whDgnum = this.getDgnumModelById(dgnumId);
            this.deleteDgnumCache(whDgnum);
        }
    }

    @Override
    public void updateDgnumStateByCode(String tenantCode, String dgnumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgnumModelByCode(tenantCode, dgnumCode, dataState, oldDataState, map);
        if (dataState == 0 && oldDataState != 0) {
            WhDgnum whDgnum = this.getDgnumModelByCode(this.getQueryMapParam("dgnumCode,tenantCode", new Object[]{dgnumCode, tenantCode}));
            this.updateDgnumCache(whDgnum);
        } else if (oldDataState == 0 && dataState != 0) {
            WhDgnum whDgnum = this.getDgnumModelByCode(this.getQueryMapParam("dgnumCode,tenantCode", new Object[]{dgnumCode, tenantCode}));
            this.deleteDgnumCache(whDgnum);
        }
    }

    @Override
    public void updateDgnum(WhDgnumDomain whDgnumDomain) throws ApiException {
        String msg = this.checkDgnum(whDgnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnum.checkDgnum", msg);
        }
        WhDgnum oldWhDgnum = this.getDgnumModelById(whDgnumDomain.getDgnumId());
        if (null == oldWhDgnum) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhDgnum whDgnum = this.makeDgnum(whDgnumDomain, oldWhDgnum);
        this.setDgnumUpdataDefault(whDgnum);
        this.updateDgnumModel(whDgnum);
        oldWhDgnum = this.getDgnumModelById(whDgnumDomain.getDgnumId());
        if (null == oldWhDgnum) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateDgnumListDomain(whDgnumDomain.getWhDgnumListDomainList(), oldWhDgnum);
        this.updateDgnumCache(oldWhDgnum);
    }

    @Override
    public WhDgnum getDgnum(Integer dgnumId) {
        if (null == dgnumId) {
            return null;
        }
        WhDgnum dgnumModel = this.getDgnumModelById(dgnumId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumCode", dgnumModel.getDgnumCode());
        map.put("tenantCode", dgnumModel.getTenantCode());
        QueryResult<WhDgnumList> whDgnumListQueryResult = this.queryDgnumListPage(map);
        dgnumModel.setWhDgnumListList(whDgnumListQueryResult.getList());
        return dgnumModel;
    }

    @Override
    public void deleteDgnum(Integer dgnumId) throws ApiException {
        if (null == dgnumId) {
            return;
        }
        WhDgnum whDgnum = this.getDgnumModelById(dgnumId);
        this.deleteDgnumModel(dgnumId);
        this.deleteDgnumCache(whDgnum);
    }

    @Override
    public QueryResult<WhDgnum> queryDgnumPage(Map<String, Object> map) {
        List<WhDgnum> whDgnumList = this.queryDgnumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgnum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whDgnumList);
        return queryResult;
    }

    @Override
    public WhDgnum getDgnumByCode(String tenantCode, String dgnumCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumCode", dgnumCode);
        return this.getDgnumModelByCode(map);
    }

    @Override
    public void deleteDgnumByCode(String tenantCode, String dgnumCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumCode", dgnumCode);
        WhDgnum whDgnum = this.getDgnumModelByCode(map);
        this.delDgnumModelByCode(map);
        this.deleteDgnumCache(whDgnum);
    }

    @Override
    public String saveDgnumList(WhDgnumListDomain whDgnumListDomain) throws ApiException {
        WhDgnumList whDgnumList = this.createWhDgnumList(whDgnumListDomain);
        this.saveDgnumListModel(whDgnumList);
        this.updateDgnumListCache(whDgnumList);
        return whDgnumList.getDgnumListCode();
    }

    @Override
    public String saveDgnumListBatch(List<WhDgnumListDomain> whDgnumListDomainList) throws ApiException {
        if (null == whDgnumListDomainList || whDgnumListDomainList.isEmpty()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumCode", whDgnumListDomainList.get(0).getDgnumCode());
        map.put("tenantCode", whDgnumListDomainList.get(0).getTenantCode());
        this.delModelByDgnumCode(map);
        ArrayList<WhDgnumList> whDgnumListList = new ArrayList<WhDgnumList>();
        String code = "";
        for (WhDgnumListDomain whDgnumListDomain : whDgnumListDomainList) {
            WhDgnumList whDgnumList = this.createWhDgnumList(whDgnumListDomain);
            code = whDgnumList.getDgnumListCode();
            whDgnumListList.add(whDgnumList);
        }
        this.saveDgnumListBatchModel(whDgnumListList);
        for (WhDgnumList whDgnumList2 : whDgnumListList) {
            this.updateDgnumListCache(whDgnumList2);
        }
        return code;
    }

    @Override
    public void updateDgnumListState(Integer dgnumListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgnumListId) {
            return;
        }
        this.updateStateDgnumListModel(dgnumListId, dataState, oldDataState, map);
    }

    @Override
    public void updateDgnumListStateByCode(String tenantCode, String dgnumListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgnumListModelByCode(tenantCode, dgnumListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDgnumList(WhDgnumListDomain whDgnumListDomain) throws ApiException {
        String msg = this.checkDgnumList(whDgnumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnumList.checkDgnumList", msg);
        }
        WhDgnumList oldWhDgnumList = this.getDgnumListModelById(whDgnumListDomain.getDgnumListId());
        if (null == oldWhDgnumList) {
            throw new ApiException("wh.WhDgnumServiceImpl.updateDgnumList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhDgnumList whDgnumList = this.makeDgnumList(whDgnumListDomain, oldWhDgnumList);
        this.setDgnumListUpdataDefault(whDgnumList);
        this.updateDgnumListModel(whDgnumList);
        this.updateDgnumListCache(whDgnumList);
    }

    @Override
    public WhDgnumList getDgnumList(Integer dgnumListId) {
        if (null == dgnumListId) {
            return null;
        }
        return this.getDgnumListModelById(dgnumListId);
    }

    @Override
    public void deleteDgnumList(Integer dgnumListId) throws ApiException {
        if (null == dgnumListId) {
            return;
        }
        WhDgnumList whDgnumList = this.getDgnumListModelById(dgnumListId);
        this.deleteDgnumListModel(dgnumListId);
        this.deleteDgnumListCache(whDgnumList);
    }

    @Override
    public QueryResult<WhDgnumList> queryDgnumListPage(Map<String, Object> map) {
        List<WhDgnumList> whDgnumListList = this.queryDgnumListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgnumList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whDgnumListList);
        return queryResult;
    }

    @Override
    public WhDgnumList getDgnumListByCode(String tenantCode, String dgnumListCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumListCode", dgnumListCode);
        return this.getDgnumListModelByCode(map);
    }

    @Override
    public void deleteDgnumListByCode(String tenantCode, String dgnumListCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumListCode", dgnumListCode);
        WhDgnumList whDgnumList = this.getDgnumListModelByCode(map);
        this.delDgnumListModelByCode(map);
        this.deleteDgnumListCache(whDgnumList);
    }

    private void deleteDgnumCache(WhDgnum whDgnum) {
        String json;
        if (null == whDgnum) {
            return;
        }
        if (StringUtils.isBlank((String)whDgnum.getMemberCode())) {
            whDgnum.setMemberCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, WhDgnumDomain.class);
        ArrayList<WhDgnumDomain> dlist2 = new ArrayList<WhDgnumDomain>();
        for (WhDgnumDomain whDgnumDomain2 : dlist) {
            if (whDgnumDomain2.getDgnumCode().equals(whDgnum.getDgnumCode())) continue;
            dlist2.add(whDgnumDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.whDomainsort(dlist2)));
    }

    private void deleteDgnumListCache(WhDgnumList whDgnumList) {
        if (null == whDgnumList) {
            return;
        }
        WhDgnum whDgnum = this.getDgnumByCode(whDgnumList.getTenantCode(), whDgnumList.getDgnumCode());
        String json = DisUtil.getMap((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, WhDgnumDomain.class);
        ArrayList<WhDgnumDomain> dlist1 = new ArrayList<WhDgnumDomain>();
        for (WhDgnumDomain whDgnumDomain2 : dlist) {
            if (whDgnumDomain2.getDgnumCode().equals(whDgnum.getDgnumCode())) {
                ArrayList<WhDgnumList> configcacheList = new ArrayList<WhDgnumList>();
                whDgnumDomain2.setWhDgnumListList(configcacheList);
                for (WhDgnumList whDgnumList2 : whDgnumDomain2.getWhDgnumListList()) {
                    if (whDgnumList2.getDgnumListCode().equals(whDgnumList.getDgnumListCode())) continue;
                    configcacheList.add(whDgnumList2);
                }
            }
            dlist1.add(whDgnumDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnumList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.whDomainsort(dlist1)));
    }

    private void updateDgnumCache(WhDgnum whDgnum) {
        if (null == whDgnum) {
            return;
        }
        if (StringUtils.isBlank((String)whDgnum.getMemberCode())) {
            whDgnum.setMemberCode("all");
        }
        WhDgnumDomain whDgnumDomain = this.makeWhDgnumDomain(whDgnum);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dgnumCode", whDgnum.getDgnumCode());
        confparammap.put("tenantCode", whDgnum.getTenantCode());
        List<WhDgnumList> upcachelist = this.queryDgnumListModelPage(confparammap);
        whDgnumDomain.setWhDgnumListList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<WhDgnumDomain> dlist = new ArrayList<WhDgnumDomain>();
            dlist.add(whDgnumDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.whDomainsort(dlist)));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, WhDgnumDomain.class);
            for (WhDgnumDomain whDgnumDomain2 : dlist) {
                if (!whDgnumDomain2.getDgnumCode().equals(whDgnum.getDgnumCode())) continue;
                try {
                    BeanUtils.copyAllPropertys((Object)whDgnumDomain2, (Object)whDgnum);
                }
                catch (Exception e) {}
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.whDomainsort(dlist)));
        }
    }

    private void updateDgnumListCache(WhDgnumList whDgnumList) {
        if (null == whDgnumList) {
            return;
        }
        WhDgnum whDgnum = this.getDgnumByCode(whDgnumList.getTenantCode(), whDgnumList.getDgnumCode());
        if (StringUtils.isBlank((String)whDgnum.getMemberCode())) {
            whDgnum.setMemberCode("all");
        }
        WhDgnumDomain whDgnumDomain = this.makeWhDgnumDomain(whDgnum);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dgnumCode", whDgnum.getDgnumCode());
        confparammap.put("tenantCode", whDgnum.getTenantCode());
        List<WhDgnumList> upcachelist = this.queryDgnumListModelPage(confparammap);
        whDgnumDomain.setWhDgnumListList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<WhDgnumDomain> dlist = new ArrayList<WhDgnumDomain>();
            dlist.add(whDgnumDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnumList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.whDomainsort(dlist)));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, WhDgnumDomain.class);
            for (WhDgnumDomain whDgnumDomain2 : dlist) {
                if (!whDgnumDomain2.getDgnumCode().equals(whDgnum.getDgnumCode())) continue;
                for (WhDgnumList whDgnumList2 : whDgnumDomain2.getWhDgnumListList()) {
                    if (!whDgnumList2.getDgnumListCode().equals(whDgnumList.getDgnumListCode())) continue;
                    try {
                        BeanUtils.copyAllPropertys((Object)whDgnumList2, (Object)whDgnumList);
                    }
                    catch (Exception e) {}
                }
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(whDgnum.getMemberCode() + "-" + whDgnumList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.whDomainsort(dlist)));
        }
    }

    @Override
    public void queryDgnumLoadCache() {
        this.logger.info("WhDgnumService.queryDgnumLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<WhDgnum> whDgnumList = this.queryDgnumModelPage(parammap);
        if (null == whDgnumList || whDgnumList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("WhDgnumService.queryDgnumLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<WhDgnumDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<WhDgnumDomain>>();
        for (WhDgnum whDgnum : whDgnumList) {
            if (StringUtils.isBlank((String)whDgnum.getMemberCode())) {
                whDgnum.setMemberCode("all");
            }
            WhDgnumDomain whDgnumDomain = this.makeWhDgnumDomain(whDgnum);
            confparammap.put("dgnumCode", whDgnum.getDgnumCode());
            confparammap.put("tenantCode", whDgnum.getTenantCode());
            List<WhDgnumList> whDgnumListList = this.queryDgnumListModelPage(confparammap);
            whDgnumDomain.setWhDgnumListList(whDgnumListList);
            ArrayList<WhDgnumDomain> dlist = (ArrayList<WhDgnumDomain>)ddListMap.get(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<WhDgnumDomain>();
                ddListMap.put(whDgnum.getMemberCode() + "-" + whDgnum.getTenantCode(), dlist);
            }
            dlist.add(whDgnumDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.whDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("WhDgnumService.queryDgnumLoadCache", (Object)"===========add-end==========");
    }

    private List<WhDgnumDomain> whDomainsort(List<WhDgnumDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<WhDgnumDomain>(){

            @Override
            public int compare(WhDgnumDomain arg0, WhDgnumDomain arg1) {
                if (arg0.getDgnumWeight() > arg1.getDgnumWeight()) {
                    return 1;
                }
                if (arg0.getDgnumWeight() < arg1.getDgnumWeight()) {
                    return -1;
                }
                return arg0.getDgnumWeight().compareTo(arg0.getDgnumWeight());
            }
        });
        return dlist;
    }

    private WhDgnumDomain makeWhDgnumDomain(WhDgnum whDgnum) {
        if (null == whDgnum) {
            return null;
        }
        WhDgnumDomain whDgnumDomain = new WhDgnumDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whDgnumDomain, (Object)whDgnum);
            return whDgnumDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

