/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhWarehouseMapper;
import com.yqbsoft.laser.service.warehouse.domain.UmUser;
import com.yqbsoft.laser.service.warehouse.domain.UmUserinfo;
import com.yqbsoft.laser.service.warehouse.domain.WhWarehouseDomain;
import com.yqbsoft.laser.service.warehouse.model.WhWarehouse;
import com.yqbsoft.laser.service.warehouse.service.WhWarehouseService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhWarehouseServiceImpl
extends BaseServiceImpl
implements WhWarehouseService {
    public static final String SYS_CODE = "wh.WhWarehouseService";
    private WhWarehouseMapper whWarehouseMapper;

    public void setWhWarehouseMapper(WhWarehouseMapper whWarehouseMapper) {
        this.whWarehouseMapper = whWarehouseMapper;
    }

    private Date getSysDate() {
        try {
            return this.whWarehouseMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhWarehouseService.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWarehouse(WhWarehouseDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setWarehouseDefault(WhWarehouse whWarehouse) {
        if (null == whWarehouse) {
            return;
        }
        if (null == whWarehouse.getDataState()) {
            whWarehouse.setDataState(0);
        }
        if (null == whWarehouse.getGmtCreate()) {
            whWarehouse.setGmtCreate(this.getSysDate());
        }
        whWarehouse.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)whWarehouse.getWarehouseCode())) {
            whWarehouse.setWarehouseCode(this.createUUIDString());
        }
    }

    private int getWarehouseMaxCode() {
        int code = 0;
        try {
            return this.whWarehouseMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhWarehouseService.getWarehouseMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWarehouseUpdataDefault(WhWarehouse whWarehouse) {
        if (null == whWarehouse) {
            return;
        }
        whWarehouse.setGmtModified(this.getSysDate());
    }

    private void saveWarehouseModel(WhWarehouse whWarehouse) throws ApiException {
        if (null == whWarehouse) {
            return;
        }
        try {
            this.whWarehouseMapper.insert(whWarehouse);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhWarehouseService.saveWarehouseModel.ex", (Throwable)e);
        }
    }

    private WhWarehouse getWarehouseModelById(Integer warehouseId) {
        if (null == warehouseId) {
            return null;
        }
        try {
            return this.whWarehouseMapper.selectByPrimaryKey(warehouseId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhWarehouseService.getWarehouseModelById", (Throwable)e);
            return null;
        }
    }

    public WhWarehouse getWarehouseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whWarehouseMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhWarehouseService.getWarehouseModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delWarehouseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whWarehouseMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhWarehouseService.delWarehouseModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhWarehouseService.delWarehouseModelByCode.num");
        }
    }

    private void deleteWarehouseModel(Integer warehouseId) throws ApiException {
        if (null == warehouseId) {
            return;
        }
        int i = 0;
        try {
            i = this.whWarehouseMapper.deleteByPrimaryKey(warehouseId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhWarehouseService.deleteWarehouseModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhWarehouseService.deleteWarehouseModel.num");
        }
    }

    private void updateWarehouseModel(WhWarehouse whWarehouse) throws ApiException {
        if (null == whWarehouse) {
            return;
        }
        try {
            this.whWarehouseMapper.updateByPrimaryKeySelective(whWarehouse);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhWarehouseService.updateWarehouseModel.ex", (Throwable)e);
        }
    }

    private void updateStateWarehouseModel(Integer warehouseId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == warehouseId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("warehouseId", warehouseId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.whWarehouseMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhWarehouseService.updateStateWarehouseModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhWarehouseService.updateStateWarehouseModel.null");
        }
    }

    private WhWarehouse makeWarehouse(WhWarehouseDomain whWarehouseDomain, WhWarehouse whWarehouse) {
        if (null == whWarehouseDomain) {
            return null;
        }
        if (null == whWarehouse) {
            whWarehouse = new WhWarehouse();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whWarehouse, (Object)whWarehouseDomain);
            return whWarehouse;
        }
        catch (Exception e) {
            this.logger.error("wh.WhWarehouseService.makeWarehouse", (Throwable)e);
            return null;
        }
    }

    private List<WhWarehouse> queryWarehouseModelPage(Map<String, Object> parammap) {
        try {
            return this.whWarehouseMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhWarehouseService.queryWarehouseModel", (Throwable)e);
            return null;
        }
    }

    private int countWarehouse(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whWarehouseMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhWarehouseService.countWarehouse", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveWarehouse(WhWarehouseDomain whWarehouseDomain) throws ApiException {
        String msg = this.checkWarehouse(whWarehouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhWarehouseService.saveWarehouse.checkWarehouse", msg);
        }
        WhWarehouse whWarehouse = this.makeWarehouse(whWarehouseDomain, null);
        this.setWarehouseDefault(whWarehouse);
        this.saveWarehouseModel(whWarehouse);
    }

    @Override
    public void updateWarehouseState(Integer warehouseId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateWarehouseModel(warehouseId, dataState, oldDataState);
    }

    @Override
    public void updateWarehouse(WhWarehouseDomain whWarehouseDomain) throws ApiException {
        String msg = this.checkWarehouse(whWarehouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhWarehouseService.updateWarehouse.checkWarehouse", msg);
        }
        WhWarehouse oldWhWarehouse = this.getWarehouseModelById(whWarehouseDomain.getWarehouseId());
        if (null == oldWhWarehouse) {
            throw new ApiException("wh.WhWarehouseService.updateWarehouse.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhWarehouse whWarehouse = this.makeWarehouse(whWarehouseDomain, oldWhWarehouse);
        this.setWarehouseUpdataDefault(whWarehouse);
        this.updateWarehouseModel(whWarehouse);
    }

    @Override
    public WhWarehouse getWarehouse(Integer warehouseId) {
        return this.getWarehouseModelById(warehouseId);
    }

    @Override
    public void deleteWarehouse(Integer warehouseId) throws ApiException {
        this.deleteWarehouseModel(warehouseId);
    }

    @Override
    public QueryResult<WhWarehouse> queryWarehousePage(Map<String, Object> map) {
        List<WhWarehouse> whWarehouseList = this.queryWarehouseModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWarehouse(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whWarehouseList);
        return queryResult;
    }

    @Override
    public WhWarehouse getWarehouseByCode(Map<String, Object> map) {
        return this.getWarehouseModelByCode(map);
    }

    @Override
    public void delWarehouseByCode(Map<String, Object> map) throws ApiException {
        this.delWarehouseModelByCode(map);
    }

    @Override
    public String saveUserinfoWarehouse(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (null == umUserinfo) {
            return "error";
        }
        WhWarehouseDomain whWarehouseDomain = new WhWarehouseDomain();
        whWarehouseDomain.setTenantCode(umUserinfo.getTenantCode());
        whWarehouseDomain.setAreaCode(umUserinfo.getAreaCode());
        whWarehouseDomain.setAreaName(umUserinfo.getAreaName());
        whWarehouseDomain.setMemberCode(umUserinfo.getUserinfoCode());
        whWarehouseDomain.setMemberName(umUserinfo.getUserinfoCompname());
        whWarehouseDomain.setWarehouseAddr(umUserinfo.getCompanyAddress());
        whWarehouseDomain.setWarehouseMobile(umUserinfo.getUserinfoPhone());
        whWarehouseDomain.setWarehouseName(umUserinfo.getUserinfoCompname());
        whWarehouseDomain.setWarehousePhone(umUserinfo.getUserinfoPhone());
        whWarehouseDomain.setWarehouseBtype("1");
        this.saveWarehouse(whWarehouseDomain);
        return "success";
    }
}

