/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhStoreGoodsMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhStoreSkuMapper;
import com.yqbsoft.laser.service.warehouse.domain.RsSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.StockDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhChannelsendDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhDgnumDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuNumBean;
import com.yqbsoft.laser.service.warehouse.es.SendPollThread;
import com.yqbsoft.laser.service.warehouse.es.SendPutThread;
import com.yqbsoft.laser.service.warehouse.es.SendService;
import com.yqbsoft.laser.service.warehouse.model.WhChannelsend;
import com.yqbsoft.laser.service.warehouse.model.WhDgnumList;
import com.yqbsoft.laser.service.warehouse.model.WhStoreGoods;
import com.yqbsoft.laser.service.warehouse.model.WhStoreSku;
import com.yqbsoft.laser.service.warehouse.model.WhUserwh;
import com.yqbsoft.laser.service.warehouse.service.WhChannelsendService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsBaseService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhStoreGoodsServiceImpl
extends BaseServiceImpl
implements WhStoreGoodsService {
    private static final String SYS_CODE = "wh.WhStoreGoodsService";
    private WhStoreGoodsMapper whStoreGoodsMapper;
    private WhStoreSkuMapper whStoreSkuMapper;
    private WhChannelsendService whChannelsendService;
    private static SendService sendService;
    private static Object lock;

    public void setWhChannelsendService(WhChannelsendService whChannelsendService) {
        this.whChannelsendService = whChannelsendService;
    }

    public void setWhStoreGoodsMapper(WhStoreGoodsMapper whStoreGoodsMapper) {
        this.whStoreGoodsMapper = whStoreGoodsMapper;
    }

    public void setWhStoreSkuMapper(WhStoreSkuMapper whStoreSkuMapper) {
        this.whStoreSkuMapper = whStoreSkuMapper;
    }

    private void updateGoodsStockModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.updateResourceStock(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateGoodsStockModel.map.ex", map.toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateGoodsStockModel.map.null", map.toString());
        }
    }

    private void updateSkuStockModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateSkuStock(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateSkuStockModel.map.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateSkuStockModel.map.null", map.toString());
        }
    }

    private Date getSysDate() {
        try {
            return this.whStoreGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreGoodsDefault(WhStoreGoods whStoreGoods) {
        if (null == whStoreGoods) {
            return;
        }
        if (null == whStoreGoods.getDataState()) {
            whStoreGoods.setDataState(0);
        }
        if (null == whStoreGoods.getGmtCreate()) {
            whStoreGoods.setGmtCreate(this.getSysDate());
        }
        whStoreGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)whStoreGoods.getStoreGoodsCode())) {
            whStoreGoods.setStoreGoodsCode(this.createUUIDString());
        }
    }

    private int getStoreGoodsMaxCode() {
        int code = 0;
        try {
            return this.whStoreGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreGoodsUpdataDefault(WhStoreGoods whStoreGoods) {
        if (null == whStoreGoods) {
            return;
        }
        whStoreGoods.setGmtModified(this.getSysDate());
    }

    private void saveStoreGoodsModel(WhStoreGoods whStoreGoods) throws ApiException {
        if (null == whStoreGoods) {
            return;
        }
        try {
            this.whStoreGoodsMapper.insert(whStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private WhStoreGoods getStoreGoodsModelById(Integer storeGoodsId) {
        if (null == storeGoodsId) {
            return null;
        }
        try {
            return this.whStoreGoodsMapper.selectByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public WhStoreGoods getStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whStoreGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreGoodsModelByCode.num");
        }
    }

    private void deleteStoreGoodsModel(Integer storeGoodsId) throws ApiException {
        if (null == storeGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.deleteByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreGoodsModel.num");
        }
    }

    private void updateStoreGoodsModel(WhStoreGoods whStoreGoods) throws ApiException {
        if (null == whStoreGoods) {
            return;
        }
        try {
            this.whStoreGoodsMapper.updateByPrimaryKeySelective(whStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStoreGoodsNumModel(WhStoreSkuNumBean whStoreSkuNumBean) throws ApiException {
        if (null == whStoreSkuNumBean) {
            return;
        }
        try {
            this.whStoreGoodsMapper.updateStoreSkuNum(whStoreSkuNumBean);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsNumModel.ex", (Throwable)e);
        }
    }

    private void updateStoreSkuNumModel(WhStoreSkuNumBean whStoreSkuNumBean) throws ApiException {
        if (null == whStoreSkuNumBean) {
            return;
        }
        try {
            this.whStoreSkuMapper.updateStoreSkuNum(whStoreSkuNumBean);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSkuNumModel.ex", (Throwable)e);
        }
    }

    private void updateStateStoreGoodsModel(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeGoodsId", storeGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.null");
        }
    }

    private WhStoreGoods makeStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain, WhStoreGoods whStoreGoods) {
        if (null == whStoreGoodsDomain) {
            return null;
        }
        if (null == whStoreGoods) {
            whStoreGoods = new WhStoreGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoods, (Object)whStoreGoodsDomain);
            return whStoreGoods;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.makeStoreGoods", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreGoods> queryStoreGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.countStoreGoods", (Throwable)e);
        }
        return i;
    }

    private Map<String, Object> querySumStoreSkuMode(Map<String, Object> map) {
        try {
            return this.whStoreSkuMapper.querySumStoreSkuMode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.querySumStoreSkuMode", (Throwable)e);
            return null;
        }
    }

    private String checkStoreSku(WhStoreSkuDomain whStoreSkuDomain) {
        if (null == whStoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreSkuDefault(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        if (null == whStoreSku.getDataState()) {
            whStoreSku.setDataState(0);
        }
        if (null == whStoreSku.getGmtCreate()) {
            whStoreSku.setGmtCreate(this.getSysDate());
        }
        whStoreSku.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)whStoreSku.getStoreSkuCode())) {
            whStoreSku.setStoreSkuCode(this.createUUIDString());
        }
    }

    private int getStoreSkuMaxCode() {
        int code = 0;
        try {
            return this.whStoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreSkuUpdataDefault(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        whStoreSku.setGmtModified(this.getSysDate());
    }

    private void saveStoreSkuModel(WhStoreSku whStoreSku) throws ApiException {
        if (null == whStoreSku) {
            return;
        }
        try {
            this.whStoreSkuMapper.insert(whStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void saveStoreSkuBatchModel(List<WhStoreSku> whStoreSkuList) throws ApiException {
        if (ListUtil.isEmpty(whStoreSkuList)) {
            return;
        }
        try {
            this.whStoreSkuMapper.insertBatch(whStoreSkuList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSkuBatchModel.ex", (Throwable)e);
        }
    }

    private WhStoreSku getStoreSkuModelById(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        try {
            return this.whStoreSkuMapper.selectByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    public WhStoreSku getStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whStoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreSkuModelByCode.num");
        }
    }

    private void deleteStoreSkuModel(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.deleteByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreSkuModel.num");
        }
    }

    private void updateStoreSkuModel(WhStoreSku whStoreSku) throws ApiException {
        if (null == whStoreSku) {
            return;
        }
        try {
            this.whStoreSkuMapper.updateByPrimaryKeySelective(whStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void updateStateStoreSkuModel(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuId", storeSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreSkuModel.null");
        }
    }

    private WhStoreSku makeStoreSku(WhStoreSkuDomain whStoreSkuDomain, WhStoreSku whStoreSku) {
        if (null == whStoreSkuDomain) {
            return null;
        }
        if (null == whStoreSku) {
            whStoreSku = new WhStoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSku, (Object)whStoreSkuDomain);
            return whStoreSku;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.makeStoreSku", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreSku> queryStoreSkuModelPage(Map<String, Object> parammap) {
        try {
            return this.whStoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.countStoreSku", (Throwable)e);
        }
        return i;
    }

    private boolean lockGoodsData(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.lockDataByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.lockGoodsData", (Object)map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    public String internalInvokeCallBack(String apiCode, Map<String, Object> paramMap, String routerdire) {
        return super.internalInvokeCallBack(apiCode, paramMap, routerdire);
    }

    @Override
    public List<WhChannelsend> saveStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        if (null == whStoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoods.param", (Object)"whStoreGoodsDomain is null");
            return null;
        }
        List<WhStoreSkuDomain> whStoreSkuDomainList = whStoreGoodsDomain.getWhStoreSkuDomainList();
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoods.param", (Object)"whStoreSkuDomainList is null");
            return null;
        }
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreSkuDomain whStoreSkuDomain : whStoreSkuDomainList) {
            List<WhChannelsend> chwhChannelsendList;
            WhStoreSku whStoreSku = this.saveStoreSkuModel(whStoreSkuDomain);
            HashMap<String, Object> storeSkuMap = new HashMap<String, Object>();
            storeSkuMap.put("tenantCode", whStoreSku.getTenantCode());
            storeSkuMap.put("memberCode", whStoreSku.getMemberCode());
            storeSkuMap.put("channelCode", whStoreSku.getChannelCode());
            storeSkuMap.put("skuEocode", whStoreSku.getSkuEocode());
            storeSkuMap.put("skuNo", whStoreSku.getSkuNo());
            storeSkuMap.put("memberCcode", whStoreSku.getMemberCcode());
            storeSkuMap.put("goodsEocode", whStoreSku.getGoodsEocode());
            storeSkuMap.put("skuBarcode", whStoreSku.getSkuBarcode());
            storeSkuMap.put("warehouseCode", whStoreSku.getWarehouseCode());
            WhStoreSku oldStoreSku = this.queryStoreSkuMode(storeSkuMap);
            if (null == oldStoreSku) {
                this.logger.error("wh.WhStoreGoodsService.saveStoreGoods1", (Object)((Object)storeSkuMap).toString());
                chwhChannelsendList = this.saveStoreNum(whStoreSku, whStoreGoodsDomain);
                if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
                whChannelsendList.addAll(chwhChannelsendList);
                continue;
            }
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoods2", (Object)((Object)storeSkuMap).toString());
            chwhChannelsendList = this.updateStoreNum(whStoreSku);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> saveStoreNum(WhStoreSku whStoreSku, WhStoreGoodsDomain whStoreGoodsDomain) {
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)whStoreGoodsDomain.getGoodsCode())) {
            map.put("goodsCode", whStoreGoodsDomain.getGoodsCode());
        }
        if (StringUtils.isNotBlank((String)whStoreGoodsDomain.getGoodsNo())) {
            map.put("goodsNo", whStoreGoodsDomain.getGoodsNo());
        }
        if (StringUtils.isNotBlank((String)whStoreGoodsDomain.getGoodsEocode())) {
            map.put("goodsEocode", whStoreGoodsDomain.getGoodsEocode());
        }
        map.put("memberCode", whStoreGoodsDomain.getMemberCode());
        map.put("tenantCode", whStoreGoodsDomain.getTenantCode());
        if ("2020050600004084".equals(whStoreGoodsDomain.getWarehouseCode())) {
            map.put("warehouseCode", whStoreGoodsDomain.getWarehouseCode());
        }
        WhStoreGoods whStoreGoods = this.queryStoreGoodsModel(map);
        this.logger.error("wh.WhStoreGoodsService.saveStoreNum", (Object)((Object)map).toString());
        if (null == whStoreGoods) {
            whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, null);
            this.setStoreGoodsDefault(whStoreGoods);
            this.saveStoreGoodsModel(whStoreGoods);
            this.saveStoreSkuModel(whStoreSku);
            List<WhChannelsend> chwhChannelsendList = this.saveSend(whStoreSku, "add", 0, null);
            if (ListUtil.isNotEmpty(chwhChannelsendList)) {
                whChannelsendList.addAll(chwhChannelsendList);
            }
        } else {
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("goodsNum", whStoreSku.getGoodsNum());
            if (StringUtils.isNotBlank((String)whStoreGoodsDomain.getGoodsCode())) {
                updateMap.put("goodsCode", whStoreGoodsDomain.getGoodsCode());
            }
            if (StringUtils.isNotBlank((String)whStoreGoodsDomain.getGoodsNo())) {
                updateMap.put("goodsNo", whStoreGoodsDomain.getGoodsNo());
            }
            if (StringUtils.isNotBlank((String)whStoreGoodsDomain.getGoodsEocode())) {
                updateMap.put("goodsEocode", whStoreGoodsDomain.getGoodsEocode());
            }
            updateMap.put("memberCode", whStoreGoodsDomain.getMemberCode());
            updateMap.put("tenantCode", whStoreGoodsDomain.getTenantCode());
            this.updateWhStroreGoodsNum(updateMap);
            this.saveStoreSkuModel(whStoreSku);
            List<WhChannelsend> chwhChannelsendList = this.saveSend(whStoreSku, "add", 0, null);
            if (ListUtil.isNotEmpty(chwhChannelsendList)) {
                whChannelsendList.addAll(chwhChannelsendList);
            }
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> updateStoreNum(WhStoreSku whStoreSku) {
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        whStoreSkuNumBean.setTenantCode(whStoreSku.getTenantCode());
        whStoreSkuNumBean.setGoodsEocode(whStoreSku.getGoodsEocode());
        whStoreSkuNumBean.setSkuEocode(whStoreSku.getSkuEocode());
        whStoreSkuNumBean.setGoodsNum(whStoreSku.getGoodsNum());
        whStoreSkuNumBean.setMemberCode(whStoreSku.getMemberCode());
        whStoreSkuNumBean.setMemberCcode(whStoreSku.getMemberCcode());
        if ("2020050600004084".equals(whStoreSku.getTenantCode())) {
            whStoreSkuNumBean.setGoodsCode(whStoreSku.getGoodsCode());
            whStoreSkuNumBean.setSkuCode(whStoreSku.getSkuCode());
            whStoreSkuNumBean.setWarehouseCode(whStoreSku.getWarehouseCode());
        }
        return this.updateNum(whStoreSkuNumBean);
    }

    private WhStoreSku queryStoreSkuMode(Map<String, Object> parammap) {
        try {
            return this.whStoreSkuMapper.queryStoreSkuMode(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreSkuMode", (Throwable)e);
            return null;
        }
    }

    private WhStoreGoods queryStoreGoodsModel(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.queryStoreGoodsModel(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreGoods> queryStoreGoodsListModel(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsListModel", (Throwable)e);
            return null;
        }
    }

    public void updateWhStroreGoodsNum(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoods.updateWhStroreGoodsNum.null");
        }
        try {
            this.whStoreGoodsMapper.updateStroreGoodsNum(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoods.updateStroreGoodsNum.e" + map.toString(), (Throwable)e);
        }
    }

    public void updateStoreGoodsNum(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoods.updateWhStroreGoodsNum.null");
        }
        try {
            this.whStoreGoodsMapper.updateStoreGoodNum(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoods.updateStroreGoodsNum.e" + map.toString(), (Throwable)e);
        }
    }

    @Override
    public List<WhChannelsend> saveStoreGoodsBatch(List<WhStoreGoodsDomain> whStoreGoodsDomainList) throws ApiException {
        if (ListUtil.isEmpty(whStoreGoodsDomainList)) {
            return null;
        }
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreGoodsDomain whStoreGoodsDomain : whStoreGoodsDomainList) {
            List<WhChannelsend> chwhChannelsendList = this.saveStoreGoods(whStoreGoodsDomain);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> saveSend(WhStoreSku whStoreSku, String dir, Integer dataSate, StockDomain stockDomain) {
        if (null == whStoreSku) {
            return null;
        }
        ArrayList<WhChannelsendDomain> atChannelsendDomainList = new ArrayList<WhChannelsendDomain>();
        WhChannelsendDomain atChannelsendDomain = new WhChannelsendDomain();
        atChannelsendDomainList.add(atChannelsendDomain);
        atChannelsendDomain.setChannelsendDir(dir);
        atChannelsendDomain.setChannelsendOpcode(whStoreSku.getStoreSkuCode());
        if (null != stockDomain) {
            atChannelsendDomain.setChannelsendType("stockDomain");
            atChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)stockDomain));
        } else {
            atChannelsendDomain.setChannelsendType("whStoreSku");
            atChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)whStoreSku));
        }
        atChannelsendDomain.setTenantCode(whStoreSku.getTenantCode());
        return this.whChannelsendService.saveChannelsendBatch(atChannelsendDomainList);
    }

    private List<WhChannelsend> saveSkuDomain(List<WhStoreSkuDomain> whStoreSkuDomainList, String opstoreCode) {
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            return null;
        }
        ArrayList<WhStoreSku> whStoreSkuList = new ArrayList<WhStoreSku>();
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreSkuDomain whStoreSkuDomain : whStoreSkuDomainList) {
            WhStoreSku whStoreSku = this.saveStoreSkuModel(whStoreSkuDomain);
            if (null == whStoreSku) continue;
            whStoreSkuList.add(whStoreSku);
        }
        this.saveStoreSkuBatchModel(whStoreSkuList);
        for (WhStoreSku whStoreSku2 : whStoreSkuList) {
            List<WhChannelsend> chwhChannelsendList = this.saveSend(whStoreSku2, "add", 0, null);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    @Override
    public void updateStoreGoodsState(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreGoodsModel(storeGoodsId, dataState, oldDataState);
    }

    @Override
    public int updateStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        String msg = this.checkStoreGoods(whStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoods.checkStoreGoods", msg);
        }
        WhStoreGoods oldWhStoreGoods = this.getStoreGoodsModelById(whStoreGoodsDomain.getStoreGoodsId());
        if (null == oldWhStoreGoods) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhStoreGoods whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, oldWhStoreGoods);
        this.setStoreGoodsUpdataDefault(whStoreGoods);
        this.updateStoreGoodsModel(whStoreGoods);
        return 0;
    }

    @Override
    public WhStoreGoods getStoreGoods(Integer storeGoodsId) {
        return this.getStoreGoodsModelById(storeGoodsId);
    }

    @Override
    public void deleteStoreGoods(Integer storeGoodsId) throws ApiException {
        this.deleteStoreGoodsModel(storeGoodsId);
    }

    @Override
    public QueryResult<WhStoreGoods> queryStoreGoodsPage(Map<String, Object> map) {
        List<WhStoreGoods> whStoreGoodsList = this.queryStoreGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreGoodsList);
        return queryResult;
    }

    @Override
    public WhStoreGoods getStoreGoodsByCode(Map<String, Object> map) {
        return this.getStoreGoodsModelByCode(map);
    }

    @Override
    public void delStoreGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delStoreGoodsModelByCode(map);
    }

    @Override
    public String saveStoreSku(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        WhStoreSku whStoreSku = this.saveStoreSkuModel(whStoreSkuDomain);
        this.saveStoreSkuModel(whStoreSku);
        return whStoreSku.getStoreSkuCode();
    }

    private WhStoreSku saveStoreSkuModel(WhStoreSkuDomain whStoreSkuDomain) {
        String msg = this.checkStoreSku(whStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSku.checkStoreSku", msg);
        }
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, null);
        this.setStoreSkuDefault(whStoreSku);
        return whStoreSku;
    }

    @Override
    public void updateStoreSkuState(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreSkuModel(storeSkuId, dataState, oldDataState);
    }

    @Override
    public void updateStoreSku(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(whStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSku.checkStoreSku", msg);
        }
        WhStoreSku oldWhStoreSku = this.getStoreSkuModelById(whStoreSkuDomain.getStoreSkuId());
        if (null == oldWhStoreSku && null == (oldWhStoreSku = this.getStoreSkuModelByCode(this.getQueryMapParam("storeSkuCode,tenantCode", new Object[]{whStoreSkuDomain.getStoreSkuCode(), whStoreSkuDomain.getTenantCode()})))) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, oldWhStoreSku);
        this.setStoreSkuUpdataDefault(whStoreSku);
        this.updateStoreSkuModel(whStoreSku);
    }

    @Override
    public WhStoreSku getStoreSku(Integer storeSkuId) {
        return this.getStoreSkuModelById(storeSkuId);
    }

    @Override
    public void deleteStoreSku(Integer storeSkuId) throws ApiException {
        this.deleteStoreSkuModel(storeSkuId);
    }

    @Override
    public QueryResult<WhStoreSku> queryStoreSkuPage(Map<String, Object> map) {
        List<WhStoreSku> whStoreSkuList = this.queryStoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreSkuList);
        return queryResult;
    }

    @Override
    public WhStoreSku getStoreSkuByCode(Map<String, Object> map) {
        return this.getStoreSkuModelByCode(map);
    }

    @Override
    public void delStoreSkuByCode(Map<String, Object> map) throws ApiException {
        this.delStoreSkuModelByCode(map);
    }

    @Override
    public void updateStoreSkuStateByCode(Map<String, Object> map) {
        this.updateStateByCode(map);
    }

    private void updateStateByCode(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.null");
        }
    }

    @Override
    public void autoSend() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("dataState", 1);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<WhStoreSku> result = null;
            do {
                startRow = WhStoreGoodsServiceImpl.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", WhStoreGoodsServiceImpl.getSendService().getPage());
                result = this.queryStoreSkuPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    WhStoreGoodsServiceImpl.getSendService().addPutPool(new SendPutThread(WhStoreGoodsServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != WhStoreGoodsServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            WhStoreGoodsServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((WhStoreGoodsBaseService)SpringApplicationContextUtil.getBean((String)"whStoreGoodsBaseService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public void saveSendChannelsend(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuCode", whStoreSku.getStoreSkuCode());
        map.put("tenantCode", whStoreSku.getTenantCode());
        map.put("dataState", 0);
        map.put("oldDataState", 1);
        this.updateStoreSkuStateByCode(map);
        Map<String, Object> numMap = this.makeNum(whStoreSku);
        if (null == numMap) {
            return;
        }
        numMap.put("skuNo", whStoreSku.getSkuNo());
        numMap.put("tenantCode", whStoreSku.getTenantCode());
        numMap.put("memberCode", whStoreSku.getMemberCcode());
        try {
            this.internalInvoke("rs.resource.sendUpdateSkuNum", numMap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.saveSendChannelsend", numMap);
        }
    }

    private Map<String, List<String>> makeDgnumlist(List<WhDgnumList> whDgnumListList) {
        if (ListUtil.isEmpty(whDgnumListList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (WhDgnumList dhDgnumList : whDgnumListList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)dhDgnumList.getDgnumListType())) {
                dhDgnumList.setDgnumListTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(dhDgnumList.getDgnumListType() + "|" + dhDgnumList.getDgnumListTerm()))) {
                list = new ArrayList<String>();
                map.put(dhDgnumList.getDgnumListType() + "|" + dhDgnumList.getDgnumListTerm(), list);
            }
            list.add(dhDgnumList.getDgnumListValue());
        }
        return map;
    }

    private Map<String, Object> makeNum(List<WhDgnumDomain> whDgnumDomainList, WhStoreSku whStoreSku) {
        if (ListUtil.isEmpty(whDgnumDomainList)) {
            return null;
        }
        for (WhDgnumDomain whDgnumDomain : whDgnumDomainList) {
            Map<String, List<String>> map = this.makeDgnumlist(whDgnumDomain.getWhDgnumListList());
            if (!this.checkConf(map, whStoreSku)) continue;
            return this.buileNum(whDgnumDomain, whStoreSku);
        }
        return null;
    }

    private Map<String, Object> makeNum(WhStoreSku whStoreSku) {
        Map<String, Object> paramMap;
        if (null == whStoreSku) {
            return null;
        }
        List whDgnumDomainList = DisUtil.getMapListJson((String)"WhDgnumList-memberCode", (String)(whStoreSku.getMemberCcode() + "-" + whStoreSku.getTenantCode()), WhDgnumDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)whDgnumDomainList)) {
            flag = true;
            whDgnumDomainList = DisUtil.getMapListJson((String)"WhDgnumList-memberCode", (String)("all-" + whStoreSku.getTenantCode()), WhDgnumDomain.class);
        }
        if (MapUtil.isNotEmpty(paramMap = this.makeNum(whDgnumDomainList, whStoreSku))) {
            return paramMap;
        }
        if (!flag && MapUtil.isNotEmpty(paramMap = this.makeNum(whDgnumDomainList = DisUtil.getMapListJson((String)"WhDgnumList-memberCode", (String)("all-" + whStoreSku.getTenantCode()), WhDgnumDomain.class), whStoreSku))) {
            return paramMap;
        }
        HashMap<String, Object> numMap = new HashMap<String, Object>();
        numMap.put("goodsNum", whStoreSku.getGoodsNum());
        numMap.put("goodsWeight", whStoreSku.getGoodsWeight());
        return numMap;
    }

    private Map<String, Object> buileNum(WhDgnumDomain whDgnumDomain, WhStoreSku whStoreSku) {
        if (null == whDgnumDomain || null == whStoreSku) {
            return null;
        }
        String pro = whDgnumDomain.getDgnumPro();
        BigDecimal rnum = BigDecimal.ZERO;
        BigDecimal rweight = BigDecimal.ZERO;
        if (null == whStoreSku.getGoodsNum()) {
            whStoreSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whStoreSku.getGoodsWeight()) {
            whStoreSku.setGoodsWeight(BigDecimal.ZERO);
        }
        BigDecimal goodsNum = whStoreSku.getGoodsNum();
        BigDecimal goodsWeight = whStoreSku.getGoodsWeight();
        if ("0".equals(pro)) {
            rnum = goodsNum.add(whDgnumDomain.getDgnumPrice());
            rweight = goodsWeight.add(whDgnumDomain.getDgnumPrice());
        } else if ("1".equals(pro)) {
            rnum = whDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 5).multiply(goodsNum);
            rweight = whDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 5).multiply(goodsWeight);
        } else if ("2".equals(pro)) {
            rnum = whDgnumDomain.getDgnumPrice();
            rweight = whDgnumDomain.getDgnumPrice();
        }
        HashMap<String, Object> numMap = new HashMap<String, Object>();
        numMap.put("goodsNum", rnum);
        numMap.put("goodsWeight", rweight);
        return numMap;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (this.cond(valueList, term, o)) break;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    public List<WhChannelsend> updateStoreSkuNum(List<WhStoreSkuNumBean> whStoreSkuNumBeanList) throws ApiException {
        if (ListUtil.isEmpty(whStoreSkuNumBeanList)) {
            return null;
        }
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreSkuNumBean whStoreSkuNumBean : whStoreSkuNumBeanList) {
            List<WhChannelsend> chwhChannelsendList = this.updateNum(whStoreSkuNumBean);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> updateNum(WhStoreSkuNumBean whStoreSkuNumBean) {
        QueryResult<WhStoreGoods> whStoreGoodsQueryResult;
        List whStoreGoodsList;
        if (null == whStoreSkuNumBean) {
            return null;
        }
        HashMap<String, Object> storeGoodsMap = new HashMap<String, Object>();
        storeGoodsMap.put("goodsEocode", whStoreSkuNumBean.getGoodsEocode());
        storeGoodsMap.put("memberCcode", whStoreSkuNumBean.getMemberCcode());
        storeGoodsMap.put("tenantCode", whStoreSkuNumBean.getTenantCode());
        if ("2020050600004084".equals(whStoreSkuNumBean.getTenantCode()) && StringUtils.isNotBlank((String)whStoreSkuNumBean.getGoodsCode())) {
            storeGoodsMap.put("goodsCode", whStoreSkuNumBean.getGoodsCode());
            storeGoodsMap.put("warehouseCode", whStoreSkuNumBean.getWarehouseCode());
        }
        if (ListUtil.isEmpty((Collection)(whStoreGoodsList = (whStoreGoodsQueryResult = this.queryStoreGoodsPage(storeGoodsMap)).getList()))) {
            throw new ApiException("wh.WhStoreGoodsService.updateNum.queryStoreGoodsPage.null" + storeGoodsMap);
        }
        WhStoreGoods whStoreGoods = (WhStoreGoods)whStoreGoodsList.get(0);
        HashMap<String, Object> lockMap = new HashMap<String, Object>();
        lockMap.put("memberCode", whStoreGoods.getMemberCode());
        lockMap.put("memberCcode", whStoreGoods.getMemberCcode());
        lockMap.put("goodsCode", whStoreGoods.getGoodsCode());
        lockMap.put("goodsEocode", whStoreGoods.getGoodsEocode());
        lockMap.put("goodsNum", whStoreGoods.getGoodsNum());
        lockMap.put("goodsWeight", whStoreGoods.getGoodsWeight());
        lockMap.put("tenantCode", whStoreGoods.getTenantCode());
        if (!this.lockGoodsData(lockMap)) {
            return null;
        }
        HashMap<String, Object> storeSkuMap = new HashMap<String, Object>();
        storeSkuMap.put("tenantCode", whStoreSkuNumBean.getTenantCode());
        storeSkuMap.put("skuEocode", whStoreSkuNumBean.getSkuEocode());
        storeSkuMap.put("memberCcode", whStoreSkuNumBean.getMemberCcode());
        if ("2020050600004084".equals(whStoreSkuNumBean.getTenantCode()) && StringUtils.isNotBlank((String)whStoreSkuNumBean.getGoodsCode()) && StringUtils.isNotBlank((String)whStoreSkuNumBean.getSkuCode())) {
            storeSkuMap.put("goodsCode", whStoreSkuNumBean.getGoodsCode());
            storeSkuMap.put("skuCode", whStoreSkuNumBean.getSkuCode());
        }
        this.logger.error("wh.WhStoreGoodsService.memberCcode", (Object)(whStoreSkuNumBean.getMemberCcode() + "-" + whStoreSkuNumBean.getSkuEocode()));
        QueryResult<WhStoreSku> whStoreSkuQueryResult = this.queryStoreSkuPage(storeSkuMap);
        List storeSkuList = whStoreSkuQueryResult.getList();
        if (ListUtil.isEmpty((Collection)storeSkuList)) {
            throw new ApiException("wh.WhStoreGoodsService.updateNum.queryStoreSkuPage.null");
        }
        WhStoreSku oldStoreSku = (WhStoreSku)storeSkuList.get(0);
        if (oldStoreSku.getGoodsNum().equals(whStoreSkuNumBean.getGoodsNum())) {
            return null;
        }
        BigDecimal remOldSkuNum = whStoreGoods.getGoodsNum().subtract(oldStoreSku.getGoodsNum());
        BigDecimal newStoreGoodsNum = remOldSkuNum.add(whStoreSkuNumBean.getGoodsNum());
        storeGoodsMap.put("goodsNum", newStoreGoodsNum);
        this.logger.error("storeGoodsMap---" + JsonUtil.buildNormalBinder().toJson(storeGoodsMap));
        this.updateStoreGoodsNum(storeGoodsMap);
        this.logger.error("whStoreSkuNumBean---" + JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuNumBean));
        this.updateStoreSkuNumModel(whStoreSkuNumBean);
        List<WhStoreSku> qlist = this.queryStoreSkuModelPage(this.getQueryMapParam("skuEocode,memberCcode,memberCode,tenantCode", new Object[]{whStoreSkuNumBean.getSkuEocode(), whStoreSkuNumBean.getMemberCcode(), whStoreSkuNumBean.getMemberCode(), whStoreSkuNumBean.getTenantCode()}));
        if ("2020050600004084".equals(whStoreSkuNumBean.getTenantCode()) && StringUtils.isNotBlank((String)whStoreSkuNumBean.getSkuCode())) {
            qlist = this.queryStoreSkuModelPage(this.getQueryMapParam("skuCode,goodsCode,memberCcode,memberCode,tenantCode", new Object[]{whStoreSkuNumBean.getSkuCode(), whStoreSkuNumBean.getGoodsCode(), whStoreSkuNumBean.getMemberCcode(), whStoreSkuNumBean.getMemberCode(), whStoreSkuNumBean.getTenantCode()}));
        }
        if (ListUtil.isEmpty(qlist)) {
            return null;
        }
        return this.saveSend(qlist.get(0), "edit", 1, null);
    }

    private String check(StockDomain stockDomain) {
        if (null == stockDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stockDomain.getGoodsCode()) && StringUtils.isBlank((String)stockDomain.getGoodsNo())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)stockDomain.getSkuCode()) && StringUtils.isBlank((String)stockDomain.getSkuNo()) && StringUtils.isBlank((String)stockDomain.getSkuBarcode())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)stockDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public List<WhChannelsend> updateSkuLockNum(List<StockDomain> stockDomainList) {
        if (ListUtil.isEmpty(stockDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.updateSkuLockNum", (Object)"stockDomainList null");
            return null;
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        for (StockDomain stockDomain : stockDomainList) {
            List<WhChannelsend> tlist;
            List<Object> glist;
            String msg = this.check(stockDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("wh.WhStoreGoodsService.updateSkuSNum.check", msg);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", stockDomain.getType());
            map.put("skuCode", stockDomain.getSkuCode());
            map.put("skuNo", stockDomain.getSkuNo());
            map.put("goodsNo", stockDomain.getGoodsNo());
            map.put("warehouseCode", stockDomain.getWarehouseCode());
            map.put("skuBarcode", stockDomain.getSkuBarcode());
            map.put("memberCode", stockDomain.getMemberCode());
            map.put("memberCcode", stockDomain.getMemberCcode());
            map.put("goodsNum", stockDomain.getGoodsNum());
            map.put("goodsWeight", stockDomain.getGoodsWeight());
            map.put("tenantCode", stockDomain.getTenantCode());
            HashMap<String, Object> qmap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)stockDomain.getSkuBarcode())) {
                qmap.put("skuCode", stockDomain.getSkuCode());
                qmap.put("skuNo", stockDomain.getSkuNo());
                qmap.put("goodsNo", stockDomain.getGoodsNo());
                qmap.put("warehouseCode", stockDomain.getWarehouseCode());
                qmap.put("skuBarcode", stockDomain.getSkuBarcode());
                qmap.put("memberCode", stockDomain.getMemberCode());
                qmap.put("memberCcode", stockDomain.getMemberCcode());
                qmap.put("tenantCode", stockDomain.getTenantCode());
                glist = this.queryStoreSkuModelPage(qmap);
                if (ListUtil.isEmpty(glist)) {
                    throw new ApiException("wh.WhStoreGoodsService.updateSkuSNum.glist", ((Object)qmap).toString());
                }
                map.put("goodsCode", ((WhStoreSku)glist.get(0)).getGoodsCode());
                map.put("skuCode", ((WhStoreSku)glist.get(0)).getSkuCode());
                qmap.put("goodsCode", ((WhStoreSku)glist.get(0)).getGoodsCode());
                qmap.put("skuCode", ((WhStoreSku)glist.get(0)).getSkuCode());
            } else {
                qmap.put("skuCode", stockDomain.getSkuCode());
                qmap.put("skuNo", stockDomain.getSkuNo());
                qmap.put("goodsNo", stockDomain.getGoodsNo());
                qmap.put("warehouseCode", stockDomain.getWarehouseCode());
                qmap.put("skuBarcode", stockDomain.getSkuBarcode());
                qmap.put("memberCode", stockDomain.getMemberCode());
                qmap.put("memberCcode", stockDomain.getMemberCcode());
                qmap.put("tenantCode", stockDomain.getTenantCode());
                if (StringUtils.isBlank((String)stockDomain.getGoodsCode())) {
                    glist = this.queryStoreGoodsListModel(qmap);
                    if (ListUtil.isEmpty(glist)) {
                        throw new ApiException("wh.WhStoreGoodsService.updateSkuSNum.check", ((Object)map).toString());
                    }
                    map.put("goodsCode", ((WhStoreGoods)glist.get(0)).getGoodsCode());
                    qmap.put("goodsCode", ((WhStoreGoods)glist.get(0)).getGoodsCode());
                }
            }
            this.lockGoodsData(qmap);
            this.logger.error("wh.WhStoreGoodsService.updateSkuLockNum.lock", (Object)((Object)qmap).toString());
            this.updateGoodsStockModel(map);
            this.updateSkuStockModel(map);
            WhStoreSku whStoreSku = null;
            List<WhStoreSku> whStoreSkus = this.queryStoreSkuModelPage(qmap);
            if (ListUtil.isNotEmpty(whStoreSkus)) {
                whStoreSku = whStoreSkus.get(0);
            }
            if (!ListUtil.isNotEmpty(tlist = this.saveSend(whStoreSku, "edit", 0, stockDomain))) continue;
            relist.addAll(tlist);
        }
        return relist;
    }

    @Override
    public Map<String, Object> querySumStoreSku(Map<String, Object> map) {
        return this.querySumStoreSkuMode(map);
    }

    @Override
    public QueryResult<WhStoreSku> queryNumBySup(Map<String, Object> map) {
        this.logger.error("wh.WhStoreGoodsServicequeryNumBySup", (Object)map.toString());
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<WhStoreSku> whStoreList = this.whStoreSkuMapper.queryNumBySup(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreList);
        queryResult.setTotal((long)whStoreList.size());
        return queryResult;
    }

    @Override
    public void saveOrUpdateStoreGoodsBatch(List<WhStoreGoodsDomain> whStoreGoodsDomainList) throws ApiException {
        if (ListUtil.isEmpty(whStoreGoodsDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.saveOrUpdateStoreGoodsBatch", (Object)"whStoreGoodsDomainList is null");
            return;
        }
        for (WhStoreGoodsDomain whStoreGoodsDomain : whStoreGoodsDomainList) {
            if (whStoreGoodsDomain.getStoreGoodsId() == null) {
                this.saveStoreGoods(whStoreGoodsDomain);
                continue;
            }
            this.updateStoreGoods(whStoreGoodsDomain);
        }
    }

    @Override
    public String saveGoodsToStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        if (null == whStoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsService.saveGoodsToStoreGoods.param", (Object)"whStoreGoodsDomain is null");
            return null;
        }
        List<WhStoreSkuDomain> whStoreSkuDomainList = whStoreGoodsDomain.getWhStoreSkuDomainList();
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.saveGoodsToStoreGoods.param", (Object)"whStoreSkuDomainList is null");
            return null;
        }
        WhStoreSku whStoreSku = this.saveStoreSkuModel(whStoreSkuDomainList.get(0));
        WhStoreGoods whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, null);
        this.setStoreGoodsDefault(whStoreGoods);
        this.saveStoreGoodsModel(whStoreGoods);
        this.saveStoreSkuModel(whStoreSku);
        return whStoreGoods.getStoreGoodsCode();
    }

    @Override
    public String updateStoreNumToERP(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        if (StringUtils.isBlank((String)whStoreSkuDomain.getSkuNo()) || StringUtils.isBlank((String)whStoreSkuDomain.getWarehouseCode()) || StringUtils.isBlank((String)String.valueOf(whStoreSkuDomain.getGoodsSnum()))) {
            this.logger.error("wh.WhStoreGoodsService.updateStoreNumToERP", (Object)"userwhList is null");
            return "\u4e0b\u5355bom\u6216\u4ed3\u5e93code\u4e3a\u7a7a";
        }
        whStoreSkuDomain.setTenantCode("2020050600004084");
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, null);
        if (null == whStoreSku) {
            return "\u6570\u636e\u4e3a\u7a7a";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2020050600004084");
        map.put("warehouseCode", whStoreSku.getWarehouseCode());
        map.put("skuNo", whStoreSku.getSkuNo());
        map.put("memberCode", "20000210312305");
        QueryResult<WhStoreSku> whStoreSkuQueryResult = this.queryStoreSkuPage(map);
        if (null == whStoreSkuQueryResult || ListUtil.isEmpty((Collection)whStoreSkuQueryResult.getList())) {
            this.logger.error("wh.WhStoreGoodsService.updateStoreNumToERP", (Object)"whStoreSkuQueryResult is null");
            return "\u4ed3\u5e93\u65e0\u6b64\u5546\u54c1,\u65e0\u6cd5\u66f4\u65b0\u5e93\u5b58";
        }
        WhStoreSku StoreSku = (WhStoreSku)whStoreSkuQueryResult.getList().get(0);
        map.remove("skuNo");
        map.put("skuCode", whStoreSku.getSkuCode());
        map.put("goodsCode", whStoreSku.getGoodsCode());
        QueryResult<WhStoreGoods> whStoreGoodsQueryResult = this.queryStoreGoodsPage(map);
        if (null == whStoreGoodsQueryResult || ListUtil.isEmpty((Collection)whStoreGoodsQueryResult.getList())) {
            this.logger.error("wh.WhStoreGoodsService.updateStoreNumToERP", (Object)"whStoreGoodsQueryResult is null");
            return "\u4ed3\u5e93\u65e0\u6b64\u5546\u54c1,\u65e0\u6cd5\u66f4\u65b0\u5e93\u5b58";
        }
        if (StoreSku.getGoodsNum().equals(whStoreSku.getGoodsNum())) {
            return "\u5546\u54c1\u5e93\u5b58\u548c\u66f4\u65b0\u5e93\u5b58\u4e00\u6837,\u65e0\u987b\u66f4\u65b0";
        }
        WhStoreGoods whStoreGoods = (WhStoreGoods)whStoreGoodsQueryResult.getList().get(0);
        map.put("goodsNum", whStoreSku.getGoodsNum());
        this.updateStoreGoodsNum(map);
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        whStoreSkuNumBean.setWarehouseCode(StoreSku.getWarehouseCode());
        whStoreSkuNumBean.setTenantCode(StoreSku.getTenantCode());
        whStoreSkuNumBean.setGoodsNum(whStoreSku.getGoodsNum());
        whStoreSkuNumBean.setMemberCode(StoreSku.getMemberCode());
        whStoreSkuNumBean.setGoodsCode(StoreSku.getGoodsCode());
        whStoreSkuNumBean.setSkuCode(StoreSku.getSkuCode());
        this.updateStoreSkuNumModel(whStoreSkuNumBean);
        return this.makeSkuNumToERP(StoreSku, whStoreSkuDomain);
    }

    public String makeSkuNumToERP(WhStoreSku StoreSku, WhStoreSkuDomain whStoreSkuDomain) {
        this.logger.error("makeSkuNum-----");
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("skuNo", whStoreSkuDomain.getSkuNo());
        sendMap.put("tenantCode", StoreSku.getTenantCode());
        HashMap<String, Object> invokeQueryMap = new HashMap<String, Object>();
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        String skuList = this.internalInvoke("rs.sku.querySkuPage", invokeQueryMap);
        List rsSkuList = new ArrayList();
        if (StringUtils.isNotBlank((String)skuList)) {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuList, SupQueryResult.class);
            rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsSkuDomain.class);
            if (ListUtil.isEmpty(rsSkuList)) {
                this.logger.error("wh.WhStoreGoodsService.makeSkuNum", (Object)"rsSkuList is null");
                return "\u6e20\u9053\u65e0\u6b64\u5546\u54c1";
            }
        }
        sendMap.clear();
        invokeQueryMap.clear();
        sendMap.put("warehouseCode", whStoreSkuDomain.getWarehouseCode());
        sendMap.put("tenantCode", StoreSku.getTenantCode());
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        String wareList = this.internalInvoke("wh.WhUserwh.queryUserwhPage", invokeQueryMap);
        List userwhList = new ArrayList();
        if (StringUtils.isBlank((String)wareList)) {
            this.logger.error("wh.WhStoreGoodsService.makeSkuNum", (Object)"userwhList is null");
            return "\u65e0\u6b64\u4ed3\u5e93";
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(wareList, SupQueryResult.class);
        userwhList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhUserwh.class);
        if (ListUtil.isEmpty(userwhList)) {
            this.logger.error("wh.WhStoreGoodsService.makeSkuNum", (Object)"userwhList is null");
            return "\u65e0\u6b64\u4ed3\u5e93";
        }
        ArrayList<RsSkuDomain> list = new ArrayList<RsSkuDomain>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        block0: for (WhUserwh userwh : userwhList) {
            for (RsSkuDomain skuDomain : rsSkuList) {
                if (!StringUtils.isNotBlank((String)skuDomain.getChannelCode()) || !skuDomain.getChannelCode().equals(userwh.getChannelCode())) continue;
                skuDomain.setGoodsNum(whStoreSkuDomain.getGoodsNum());
                list.add(skuDomain);
                idList.add(skuDomain.getSkuId());
                continue block0;
            }
        }
        this.logger.error("list-------", (Object)JsonUtil.buildNormalBinder().toJson(list));
        this.logger.error("idList-------", (Object)JsonUtil.buildNormalBinder().toJson(idList));
        HashMap<String, String> paramList = new HashMap<String, String>();
        paramList.put("skuList", JsonUtil.buildNonDefaultBinder().toJson(list));
        this.internalInvoke("rs.sku.updateSkuList", paramList);
        this.logger.error("rs.sku.updateSkuList-----");
        ArrayList<Integer> idShelList = new ArrayList<Integer>();
        for (RsSkuDomain skuDomain : list) {
            if (!"1".equals(String.valueOf(skuDomain.getDataOpbillstate()))) continue;
            idShelList.add(skuDomain.getSkuId());
        }
        invokeQueryMap.clear();
        invokeQueryMap.put("skuIdList", idShelList);
        this.internalInvoke("rs.resource.sendUpdateSoldOutBatchSku", invokeQueryMap);
        this.logger.error("rs.resource.sendUpdateSoldOutBatchSku------");
        invokeQueryMap.clear();
        invokeQueryMap.put("skuIdList", idList);
        this.internalInvoke("rs.resource.sendUpdateShelveBatchSku", invokeQueryMap);
        this.logger.error("over---");
        return "success";
    }

    static {
        lock = new Object();
    }
}

