/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhUserWhMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhUserwh;
import com.yqbsoft.laser.service.warehouse.service.WhUserwhService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhUserwhServiceImpl
extends BaseServiceImpl
implements WhUserwhService {
    private static final String SYS_CODE = "wh.WhUserwhServiceImpl";
    private WhUserWhMapper whUserwhMapper;

    public void setWhUserwhMapper(WhUserWhMapper whUserwhMapper) {
        this.whUserwhMapper = whUserwhMapper;
    }

    private Date getSysDate() {
        try {
            return this.whUserwhMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserwh(WhUserwhDomain whUserwhDomain) {
        if (null == whUserwhDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whUserwhDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserwhDefault(WhUserwh whUserwh) {
        if (null == whUserwh) {
            return;
        }
        if (null == whUserwh.getDataState()) {
            whUserwh.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whUserwh.getGmtCreate()) {
            whUserwh.setGmtCreate(date);
        }
        whUserwh.setGmtModified(date);
        if (StringUtils.isBlank((String)whUserwh.getUserwhCode())) {
            whUserwh.setUserwhCode(this.getNo(null, "WhUserwh", "whUserwh", whUserwh.getTenantCode()));
        }
    }

    private int getUserwhMaxCode() {
        int code = 0;
        try {
            return this.whUserwhMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getUserwhMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserwhUpdataDefault(WhUserwh whUserwh) {
        if (null == whUserwh) {
            return;
        }
        whUserwh.setGmtModified(this.getSysDate());
    }

    private void saveUserwhModel(WhUserwh whUserwh) throws ApiException {
        if (null == whUserwh) {
            return;
        }
        try {
            this.whUserwhMapper.insert(whUserwh);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.saveUserwhModel.ex", (Throwable)e);
        }
    }

    private void saveUserwhBatchModel(List<WhUserwh> whUserwhList) throws ApiException {
        if (null == whUserwhList || whUserwhList.isEmpty()) {
            return;
        }
        try {
            this.whUserwhMapper.insertBatch(whUserwhList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.saveUserwhBatchModel.ex", (Throwable)e);
        }
    }

    private WhUserwh getUserwhModelById(Integer userwhId) {
        if (null == userwhId) {
            return null;
        }
        try {
            return this.whUserwhMapper.selectByPrimaryKey(userwhId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getUserwhModelById", (Throwable)e);
            return null;
        }
    }

    private WhUserwh getUserwhModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whUserwhMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getUserwhModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserwhModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.delUserwhModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.delUserwhModelByCode.num");
        }
    }

    private void deleteUserwhModel(Integer userwhId) throws ApiException {
        if (null == userwhId) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.deleteByPrimaryKey(userwhId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.deleteUserwhModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.deleteUserwhModel.num", userwhId.toString());
        }
    }

    private void updateUserwhModel(WhUserwh whUserwh) throws ApiException {
        if (null == whUserwh) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateByPrimaryKeySelective(whUserwh);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModel.num");
        }
    }

    private void updateUserwhModelModelWithNull(WhUserwh whUserwh) throws ApiException {
        if (null == whUserwh) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateByPrimaryKey(whUserwh);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModelModelWithNull.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModelModelWithNull.num");
        }
    }

    private void updateStateUserwhModel(Integer userwhId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userwhId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userwhId", userwhId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModel.null");
        }
    }

    private void updateStateUserwhModelByCode(String tenantCode, String userwhCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModelByCode.null");
        }
    }

    private WhUserwh makeUserwh(WhUserwhDomain whUserwhDomain, WhUserwh whUserwh) {
        if (null == whUserwhDomain) {
            return null;
        }
        if (null == whUserwh) {
            whUserwh = new WhUserwh();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whUserwh, (Object)whUserwhDomain);
            return whUserwh;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.makeUserwh", (Throwable)e);
            return null;
        }
    }

    private WhUserwhReDomain makeWhUserwhReDomain(WhUserwh whUserwh) {
        if (null == whUserwh) {
            return null;
        }
        WhUserwhReDomain whUserwhReDomain = new WhUserwhReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhReDomain, (Object)whUserwh);
            return whUserwhReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.makeWhUserwhReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhUserwh> queryUserwhModelPage(Map<String, Object> parammap) {
        try {
            return this.whUserwhMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.queryUserwhModel", (Throwable)e);
            return null;
        }
    }

    private int countUserwh(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whUserwhMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.countUserwh", (Throwable)e);
        }
        return i;
    }

    private WhUserwh createWhUserwh(WhUserwhDomain whUserwhDomain) {
        String msg = this.checkUserwh(whUserwhDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhServiceImpl.saveUserwh.checkUserwh", msg);
        }
        WhUserwh whUserwh = this.makeUserwh(whUserwhDomain, null);
        this.setUserwhDefault(whUserwh);
        return whUserwh;
    }

    @Override
    public String saveUserwh(WhUserwhDomain whUserwhDomain) throws ApiException {
        WhUserwh whUserwh = this.createWhUserwh(whUserwhDomain);
        this.saveUserwhModel(whUserwh);
        return whUserwh.getUserwhCode();
    }

    @Override
    public String saveUserwhBatch(List<WhUserwhDomain> whUserwhDomainList) throws ApiException {
        if (null == whUserwhDomainList || whUserwhDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhUserwh> whUserwhList = new ArrayList<WhUserwh>();
        String code = "";
        for (WhUserwhDomain whUserwhDomain : whUserwhDomainList) {
            WhUserwh whUserwh = this.createWhUserwh(whUserwhDomain);
            code = whUserwh.getUserwhCode();
            whUserwhList.add(whUserwh);
        }
        this.saveUserwhBatchModel(whUserwhList);
        return code;
    }

    @Override
    public void updateUserwhState(Integer userwhId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == userwhId) {
            return;
        }
        this.updateStateUserwhModel(userwhId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserwhStateByCode(String tenantCode, String userwhCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserwhModelByCode(tenantCode, userwhCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUserwh(WhUserwhDomain whUserwhDomain) throws ApiException {
        String msg = this.checkUserwh(whUserwhDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwh.checkUserwh", msg);
        }
        this.logger.error("wh.WhUserwhServiceImplupdateUserwh", (Object)JsonUtil.buildNonNullBinder().toJson((Object)whUserwhDomain));
        WhUserwh oldWhUserwh = this.getUserwhModelById(whUserwhDomain.getUserwhId());
        if (null == oldWhUserwh) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwh.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhUserwh whUserwh = this.makeUserwh(whUserwhDomain, oldWhUserwh);
        this.setUserwhUpdataDefault(whUserwh);
        this.updateUserwhModel(whUserwh);
    }

    @Override
    public WhUserwh getUserwh(Integer userwhId) {
        if (null == userwhId) {
            return null;
        }
        return this.getUserwhModelById(userwhId);
    }

    @Override
    public void deleteUserwh(Integer userwhId) throws ApiException {
        if (null == userwhId) {
            return;
        }
        this.deleteUserwhModel(userwhId);
    }

    @Override
    public QueryResult<WhUserwh> queryUserwhPage(Map<String, Object> map) {
        List<WhUserwh> whUserwhList = this.queryUserwhModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserwh(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whUserwhList);
        return queryResult;
    }

    @Override
    public WhUserwh getUserwhByCode(String tenantCode, String userwhCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        return this.getUserwhModelByCode(map);
    }

    @Override
    public void deleteUserwhByCode(String tenantCode, String userwhCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        this.delUserwhModelByCode(map);
    }

    @Override
    public void saveOrUpdateUserwhBatch(List<WhUserwhDomain> whUserwhDomainList) throws ApiException {
        if (ListUtil.isEmpty(whUserwhDomainList)) {
            this.logger.error("wh.WhUserwhServiceImpl.saveOrUpdateUserwhBatch", (Object)"whUserwhDomainList is null");
            return;
        }
        for (WhUserwhDomain whUserwhDomain : whUserwhDomainList) {
            if (whUserwhDomain.getUserwhId() == null) {
                this.saveUserwh(whUserwhDomain);
                continue;
            }
            this.updateUserwh(whUserwhDomain);
        }
    }
}

