/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParsingException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.ArrayUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;
import org.jspecify.annotations.Nullable;

class JohnzonNodeFactory
extends AbstractNodeFactory {
    private final Mapper mapper = new MapperBuilder().build();

    JohnzonNodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)source;
            return JohnzonNodeFactory.newNode(jsonValue);
        }
        if (source instanceof int[]) {
            int[] array = (int[])source;
            return this.newNodeFrom(ArrayUtils.toIntList(array));
        }
        if (source instanceof double[]) {
            double[] array = (double[])source;
            return this.newNodeFrom(ArrayUtils.toDoubleList(array));
        }
        if (source instanceof boolean[]) {
            boolean[] array = (boolean[])source;
            return this.newNodeFrom(ArrayUtils.toBoolList(array));
        }
        if (source instanceof Object[]) {
            Object[] array = (Object[])source;
            return this.newNodeFrom(Arrays.asList(array));
        }
        return this.newNodeFrom(source);
    }

    private Node newNodeFrom(Object source) {
        return JohnzonNodeFactory.newNode(this.mapper.toStructure(source));
    }

    @Override
    protected Node nullNode() {
        return JohnzonNodeFactory.newNode(JsonValue.NULL);
    }

    @Override
    protected Node readValue(Reader reader, String label, boolean lenient) {
        JsonReader parser = Json.createReader((Reader)reader);
        try {
            Node node = JohnzonNodeFactory.newNode(parser.readValue());
            return node;
        }
        catch (JsonParsingException e) {
            throw this.newParseException(label, reader, (Exception)((Object)e));
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public boolean isPreferredFor(@Nullable Object source) {
        return source instanceof JsonValue;
    }

    private static Node newNode(JsonValue value) {
        return new JavaxJsonNode(value);
    }

    static final class JavaxJsonNode
    extends AbstractNode {
        private final JsonValue jsonNode;

        JavaxJsonNode(JsonValue jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            JsonValue jsonValue = this.jsonNode;
            if (jsonValue instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonValue;
                try {
                    return JohnzonNodeFactory.newNode((JsonValue)jsonArray.get(index));
                }
                catch (IndexOutOfBoundsException e) {
                    return MISSING_NODE;
                }
            }
            return MISSING_NODE;
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            JsonValue jsonValue = this.jsonNode;
            if (jsonValue instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonValue;
                final Iterator iterator = jsonObject.entrySet().iterator();
                return new Iterator<Node.KeyValue>(this){
                    final /* synthetic */ JavaxJsonNode this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Node.KeyValue next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new Node.KeyValue((String)entry.getKey(), JohnzonNodeFactory.newNode((JsonValue)entry.getValue()));
                    }
                };
            }
            throw new IllegalStateException("Can call fields() only on an JsonObject");
        }

        @Override
        public Node get(String key) {
            if (this.isObject()) {
                JsonObject jsonObject = (JsonObject)this.jsonNode;
                if (jsonObject.containsKey((Object)key)) {
                    return JohnzonNodeFactory.newNode((JsonValue)jsonObject.get((Object)key));
                }
                return Node.MISSING_NODE;
            }
            return Node.MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.equals((Object)JsonValue.NULL);
        }

        @Override
        public boolean isObject() {
            return this.jsonNode instanceof JsonObject;
        }

        @Override
        public Iterator<Node> arrayElements() {
            JsonValue jsonValue = this.jsonNode;
            if (jsonValue instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonValue;
                final Iterator iterator = jsonArray.iterator();
                return new Iterator<Node>(this){
                    final /* synthetic */ JavaxJsonNode this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Node next() {
                        return JohnzonNodeFactory.newNode((JsonValue)iterator.next());
                    }
                };
            }
            throw new IllegalStateException("Can call arrayElements() only on an JsonArray");
        }

        @Override
        public int size() {
            JsonValue jsonValue = this.jsonNode;
            if (jsonValue instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonValue;
                return jsonArray.size();
            }
            throw new IllegalStateException("Can call size() only on an JsonArray");
        }

        @Override
        public Node.NodeType getNodeType() {
            return switch (this.jsonNode.getValueType()) {
                default -> throw new IncompatibleClassChangeError();
                case JsonValue.ValueType.OBJECT -> Node.NodeType.OBJECT;
                case JsonValue.ValueType.ARRAY -> Node.NodeType.ARRAY;
                case JsonValue.ValueType.STRING -> Node.NodeType.STRING;
                case JsonValue.ValueType.NUMBER -> Node.NodeType.NUMBER;
                case JsonValue.ValueType.TRUE, JsonValue.ValueType.FALSE -> Node.NodeType.BOOLEAN;
                case JsonValue.ValueType.NULL -> Node.NodeType.NULL;
            };
        }

        @Override
        public String asText() {
            if (this.jsonNode.getValueType() == JsonValue.ValueType.STRING) {
                return ((JsonString)this.jsonNode).getString();
            }
            throw new IllegalStateException("Not a JsonString: " + String.valueOf(this.jsonNode));
        }

        @Override
        public BigDecimal decimalValue() {
            if (this.isNumber()) {
                return ((JsonNumber)this.jsonNode).bigDecimalValue();
            }
            throw new IllegalStateException("Not a JsonNumber: " + String.valueOf(this.jsonNode));
        }

        @Override
        public boolean isIntegralNumber() {
            return this.jsonNode instanceof JsonLongImpl;
        }

        private boolean isNumber() {
            return this.jsonNode.getValueType() == JsonValue.ValueType.NUMBER;
        }

        @Override
        public Boolean asBoolean() {
            if (this.jsonNode.getValueType() == JsonValue.ValueType.TRUE) {
                return true;
            }
            if (this.jsonNode.getValueType() == JsonValue.ValueType.FALSE) {
                return false;
            }
            throw new IllegalStateException("Not a JsonBoolean: " + String.valueOf(this.jsonNode));
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

