/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.controller;

import cn.hutool.core.io.IoUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import net.maku.generator.common.utils.Result;
import net.maku.generator.config.template.GeneratorData;
import net.maku.generator.service.GeneratorService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"maku-generator/gen/generator"})
public class GeneratorController {
    private final GeneratorService generatorService;

    @GetMapping(value={"download"})
    public void download(String tableIds, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        for (String tableId : tableIds.split(",")) {
            this.generatorService.downloadCode(Long.parseLong(tableId), zip);
        }
        IoUtil.close((Closeable)zip);
        byte[] data = outputStream.toByteArray();
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"maku.zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IoUtil.write((OutputStream)response.getOutputStream(), (boolean)false, (byte[])data);
    }

    @ResponseBody
    @PostMapping(value={"code"})
    public Result<String> code(@RequestBody Long[] tableIds) throws Exception {
        for (Long tableId : tableIds) {
            this.generatorService.generatorCode(tableId);
        }
        return Result.ok();
    }

    @GetMapping(value={"/preview"})
    public Result<List<GeneratorData>> preview(@RequestParam Long tableId) throws Exception {
        List<GeneratorData> results = this.generatorService.preview(tableId);
        return Result.ok(results);
    }

    @Generated
    public GeneratorController(GeneratorService generatorService) {
        this.generatorService = generatorService;
    }
}

