/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.tag;

import java.util.Map;
import net.sf.jxls.controller.SheetTransformationControllerImpl;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.parser.Expression;
import net.sf.jxls.parser.ExpressionParser;
import net.sf.jxls.tag.BaseTag;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.TagContext;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.SheetTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IfTag
extends BaseTag {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String TAG_NAME = "if";
    String test;
    Boolean testResult = null;

    public IfTag() {
        this.name = TAG_NAME;
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public void init(TagContext context) {
        super.init(context);
        ExpressionParser exprParser = new ExpressionParser(this.test, context.getBeans(), context.getSheet().getConfiguration());
        Expression testExpr = exprParser.parse();
        try {
            this.testResult = (Boolean)testExpr.evaluate();
        }
        catch (Exception e) {
            this.log.error((Object)("Can't evaluate test expression: " + this.test), (Throwable)e);
            throw new RuntimeException("Can't evaluate test expression: " + this.test, e);
        }
    }

    public ResultTransformation process(SheetTransformer sheetTransformer) {
        Block body;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("if tag processing. Parameters: test=" + this.test));
        }
        if ((body = this.tagContext.getTagBody()).getNumberOfRows() == 1) {
            return this.processOneRowTag(sheetTransformer);
        }
        int shiftNumber = 0;
        ResultTransformation shift = new ResultTransformation(0);
        shift.setLastProcessedRow(-1);
        if (this.testResult != null) {
            if (this.testResult.booleanValue()) {
                this.tagContext.getSheetTransformationController().removeBorders(body);
                shiftNumber -= 2;
                try {
                    ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), body.getStartRowNum(), body.getEndRowNum(), this.tagContext.getBeans(), null);
                    shift.add(processResult);
                }
                catch (ParsePropertyException e) {
                    this.log.error((Object)"Can't parse property ", (Throwable)e);
                }
            } else {
                this.tagContext.getSheetTransformationController().removeBodyRows(body);
                shift.add(new ResultTransformation(-1, -body.getNumberOfRows()));
            }
        }
        shift.setTagProcessResult(true);
        return shift.add(new ResultTransformation(0, shiftNumber));
    }

    private ResultTransformation processOneRowTag(SheetTransformer sheetTransformer) {
        Block body = this.tagContext.getTagBody();
        int shiftNumber = 0;
        SheetTransformationControllerImpl stc = new SheetTransformationControllerImpl(this.tagContext.getSheet());
        stc.removeLeftRightBorders(body);
        Map beans = this.tagContext.getBeans();
        ResultTransformation shift = new ResultTransformation();
        shift.setLastProcessedRow(-1);
        shift.addRightShift((short)(shiftNumber -= 2));
        if (this.testResult != null) {
            if (this.testResult.booleanValue()) {
                ResultTransformation processResult = sheetTransformer.processRow(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), this.tagContext.getSheet().getHssfSheet().getRow(body.getStartRowNum()), body.getStartCellNum(), body.getEndCellNum(), beans, null);
                shift.add(processResult);
            } else {
                stc.removeRowCells(this.tagContext.getSheet().getHssfSheet().getRow(body.getStartRowNum()), body.getStartCellNum(), body.getEndCellNum());
                shift.add(new ResultTransformation((short)(-body.getNumberOfColumns()), (short)(-body.getNumberOfColumns())));
            }
        }
        shift.setTagProcessResult(true);
        return shift;
    }
}

