/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.context;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobExecutorContext;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ProcessEngineConfigurationImpl>> processEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ExecutionContext>> executionContextStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<JobExecutorContext> jobExecutorContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Map<String, ObjectNode>> bpmnOverrideContextThreadLocal = new ThreadLocal();
    protected static ResourceBundle.Control resourceBundleControl = new ResourceBundleControl();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        Stack stack = Context.getStack(processEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessEngineConfigurationImpl)stack.peek();
    }

    public static void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Context.getStack(processEngineConfigurationStackThreadLocal).push(processEngineConfiguration);
    }

    public static void removeProcessEngineConfiguration() {
        Context.getStack(processEngineConfigurationStackThreadLocal).pop();
    }

    public static ExecutionContext getExecutionContext() {
        return (ExecutionContext)Context.getStack(executionContextStackThreadLocal).peek();
    }

    public static boolean isExecutionContextActive() {
        Stack<ExecutionContext> stack = executionContextStackThreadLocal.get();
        return stack != null && !stack.isEmpty();
    }

    public static void setExecutionContext(InterpretableExecution execution) {
        Context.getStack(executionContextStackThreadLocal).push(new ExecutionContext(execution));
    }

    public static void removeExecutionContext() {
        Context.getStack(executionContextStackThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }

    public static JobExecutorContext getJobExecutorContext() {
        return jobExecutorContextThreadLocal.get();
    }

    public static void setJobExecutorContext(JobExecutorContext jobExecutorContext) {
        jobExecutorContextThreadLocal.set(jobExecutorContext);
    }

    public static void removeJobExecutorContext() {
        jobExecutorContextThreadLocal.remove();
    }

    public static ObjectNode getBpmnOverrideElementProperties(String id, String processDefinitionId) {
        ObjectNode definitionInfoNode = Context.getProcessDefinitionInfoNode(processDefinitionId);
        ObjectNode elementProperties = null;
        if (definitionInfoNode != null) {
            elementProperties = Context.getProcessEngineConfiguration().getDynamicBpmnService().getBpmnElementProperties(id, definitionInfoNode);
        }
        return elementProperties;
    }

    public static ObjectNode getLocalizationElementProperties(String language, String id, String processDefinitionId, boolean useFallback) {
        ObjectNode definitionInfoNode = Context.getProcessDefinitionInfoNode(processDefinitionId);
        ObjectNode localizationProperties = null;
        if (definitionInfoNode != null) {
            if (!useFallback) {
                localizationProperties = Context.getProcessEngineConfiguration().getDynamicBpmnService().getLocalizationElementProperties(language, id, definitionInfoNode);
            } else {
                LinkedHashSet<Locale> candidateLocales = new LinkedHashSet<Locale>();
                candidateLocales.addAll(resourceBundleControl.getCandidateLocales(id, new Locale(language)));
                candidateLocales.addAll(resourceBundleControl.getCandidateLocales(id, Locale.getDefault()));
                for (Locale locale : candidateLocales) {
                    localizationProperties = Context.getProcessEngineConfiguration().getDynamicBpmnService().getLocalizationElementProperties(locale.getLanguage(), id, definitionInfoNode);
                    if (localizationProperties == null) continue;
                    break;
                }
            }
        }
        return localizationProperties;
    }

    public static void removeBpmnOverrideContext() {
        bpmnOverrideContextThreadLocal.remove();
    }

    protected static ObjectNode getProcessDefinitionInfoNode(String processDefinitionId) {
        Map<String, ObjectNode> bpmnOverrideMap = Context.getBpmnOverrideContext();
        if (!bpmnOverrideMap.containsKey(processDefinitionId)) {
            ProcessDefinitionInfoCacheObject cacheObject = Context.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionInfoCache().get(processDefinitionId);
            Context.addBpmnOverrideElement(processDefinitionId, cacheObject.getInfoNode());
        }
        return Context.getBpmnOverrideContext().get(processDefinitionId);
    }

    protected static Map<String, ObjectNode> getBpmnOverrideContext() {
        Map<String, ObjectNode> bpmnOverrideMap = bpmnOverrideContextThreadLocal.get();
        if (bpmnOverrideMap == null) {
            bpmnOverrideMap = new HashMap<String, ObjectNode>();
        }
        return bpmnOverrideMap;
    }

    protected static void addBpmnOverrideElement(String id, ObjectNode infoNode) {
        Map<String, ObjectNode> bpmnOverrideMap = bpmnOverrideContextThreadLocal.get();
        if (bpmnOverrideMap == null) {
            bpmnOverrideMap = new HashMap<String, ObjectNode>();
            bpmnOverrideContextThreadLocal.set(bpmnOverrideMap);
        }
        bpmnOverrideMap.put(id, infoNode);
    }

    static class ResourceBundleControl
    extends ResourceBundle.Control {
        ResourceBundleControl() {
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            return super.getCandidateLocales(baseName, locale);
        }
    }
}

