/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BaseVariableCollectionResource
extends BaseExecutionVariableResource {
    @Autowired
    protected ObjectMapper objectMapper;

    protected List<RestVariable> processVariables(Execution execution, String scope, int variableType) {
        ArrayList<RestVariable> result = new ArrayList<RestVariable>();
        HashMap<String, RestVariable> variableMap = new HashMap<String, RestVariable>();
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(scope);
        if (variableScope == null) {
            this.addLocalVariables(execution, variableType, variableMap);
            this.addGlobalVariables(execution, variableType, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            this.addGlobalVariables(execution, variableType, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.addLocalVariables(execution, variableType, variableMap);
        }
        result.addAll(variableMap.values());
        return result;
    }

    public void deleteAllLocalVariables(Execution execution, HttpServletResponse response) {
        Set currentVariables = this.runtimeService.getVariablesLocal(execution.getId()).keySet();
        this.runtimeService.removeVariablesLocal(execution.getId(), currentVariables);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected Object createExecutionVariable(Execution execution, boolean override, int variableType, HttpServletRequest request, HttpServletResponse response) {
        Object result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, execution, variableType, true);
        } else {
            ArrayList<RestVariable> inputVariables = new ArrayList<RestVariable>();
            ArrayList<RestVariable> resultVariables = new ArrayList<RestVariable>();
            result = resultVariables;
            try {
                List variableObjects = (List)this.objectMapper.readValue((InputStream)request.getInputStream(), List.class);
                for (Object restObject : variableObjects) {
                    RestVariable restVariable = (RestVariable)this.objectMapper.convertValue(restObject, RestVariable.class);
                    inputVariables.add(restVariable);
                }
            }
            catch (Exception e) {
                throw new ActivitiIllegalArgumentException("Failed to serialize to a RestVariable instance", (Throwable)e);
            }
            if (inputVariables == null || inputVariables.size() == 0) {
                throw new ActivitiIllegalArgumentException("Request didn't contain a list of variables to create.");
            }
            RestVariable.RestVariableScope sharedScope = null;
            RestVariable.RestVariableScope varScope = null;
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : inputVariables) {
                varScope = var.getVariableScope();
                if (var.getName() == null) {
                    throw new ActivitiIllegalArgumentException("Variable name is required");
                }
                if (varScope == null) {
                    varScope = RestVariable.RestVariableScope.LOCAL;
                }
                if (sharedScope == null) {
                    sharedScope = varScope;
                }
                if (varScope != sharedScope) {
                    throw new ActivitiIllegalArgumentException("Only allowed to update multiple variables in the same scope.");
                }
                if (!override && this.hasVariableOnScope(execution, var.getName(), varScope)) {
                    throw new ActivitiConflictException("Variable '" + var.getName() + "' is already present on execution '" + execution.getId() + "'.");
                }
                Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
                resultVariables.add(this.restResponseFactory.createRestVariable(var.getName(), actualVariableValue, varScope, execution.getId(), variableType, false));
            }
            if (!variablesToSet.isEmpty()) {
                if (sharedScope == RestVariable.RestVariableScope.LOCAL) {
                    this.runtimeService.setVariablesLocal(execution.getId(), variablesToSet);
                } else if (execution.getParentId() != null) {
                    this.runtimeService.setVariables(execution.getParentId(), variablesToSet);
                } else {
                    throw new ActivitiIllegalArgumentException("Cannot set global variables on execution '" + execution.getId() + "', task is not part of process.");
                }
            }
        }
        response.setStatus(HttpStatus.CREATED.value());
        return result;
    }

    protected void addGlobalVariables(Execution execution, int variableType, Map<String, RestVariable> variableMap) {
        Map rawVariables = this.runtimeService.getVariables(execution.getId());
        List<RestVariable> globalVariables = this.restResponseFactory.createRestVariables(rawVariables, execution.getId(), variableType, RestVariable.RestVariableScope.GLOBAL);
        for (RestVariable var : globalVariables) {
            if (variableMap.containsKey(var.getName())) continue;
            variableMap.put(var.getName(), var);
        }
    }

    protected void addLocalVariables(Execution execution, int variableType, Map<String, RestVariable> variableMap) {
        Map rawLocalvariables = this.runtimeService.getVariablesLocal(execution.getId());
        List<RestVariable> localVariables = this.restResponseFactory.createRestVariables(rawLocalvariables, execution.getId(), variableType, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : localVariables) {
            variableMap.put(var.getName(), var);
        }
    }
}

