/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ansj.dic.DicReader;
import org.ansj.domain.AnsjItem;
import org.ansj.domain.NumNatureAttr;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.domain.Term;
import org.ansj.recognition.arrimpl.NumRecognition;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.dat.DoubleArrayTire;
import org.nlpcn.commons.lang.dat.Item;
import org.nlpcn.commons.lang.util.ObjConver;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class DATDictionary {
    private static final Log LOG = LogFactory.getLog(DATDictionary.class);
    private static final Map<String, PersonNatureAttr> PERSONMAP = new HashMap<String, PersonNatureAttr>();
    private static final Set<String> FOREIGNSET = new HashSet<String>();
    private static final DoubleArrayTire DAT = DATDictionary.loadDAT();
    public static int arrayLength = DATDictionary.DAT.arrayLength;

    private static DoubleArrayTire loadDAT() {
        long start = System.currentTimeMillis();
        try {
            NumNatureAttr numAttr;
            char c;
            DoubleArrayTire dat = DoubleArrayTire.loadText((InputStream)DicReader.getInputStream("core.dic"), AnsjItem.class);
            Item[] itemArray = NumRecognition.f_NUM.iterator();
            while (itemArray.hasNext()) {
                c = itemArray.next().charValue();
                numAttr = ((AnsjItem)dat.getDAT()[c]).termNatures.numAttr;
                if (numAttr == null || numAttr == NumNatureAttr.NULL) {
                    ((AnsjItem)dat.getDAT()[c]).termNatures.numAttr = NumNatureAttr.NUM;
                    continue;
                }
                numAttr.setNum(true);
            }
            itemArray = NumRecognition.j_NUM.iterator();
            while (itemArray.hasNext()) {
                c = itemArray.next().charValue();
                numAttr = ((AnsjItem)dat.getDAT()[c]).termNatures.numAttr;
                if (numAttr == null || numAttr == NumNatureAttr.NULL) {
                    ((AnsjItem)dat.getDAT()[c]).termNatures.numAttr = NumNatureAttr.NUM;
                    continue;
                }
                numAttr.setNum(true);
            }
            DATDictionary.personNameFull(dat);
            for (Item item : dat.getDAT()) {
                if (item == null || item.getName() == null || item.getStatus() >= 2) continue;
                item.setName(null);
            }
            LOG.info("init core library ok use time : " + (System.currentTimeMillis() - start));
            return dat;
        }
        catch (InstantiationException e) {
            LOG.warn("\u65e0\u6cd5\u5b9e\u4f8b\u5316", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("\u975e\u6cd5\u8bbf\u95ee", (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOG.warn("\u6570\u5b57\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("IO\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void personNameFull(DoubleArrayTire dat) throws NumberFormatException, IOException {
        BufferedReader reader = null;
        try {
            reader = MyStaticValue.getPersonDicReader();
            AnsjItem item = null;
            String temp = null;
            String word = null;
            while ((temp = reader.readLine()) != null) {
                String[] split = temp.split("\t");
                word = split[1];
                float score = ObjConver.getFloatValue((String)split[2]).floatValue();
                item = (AnsjItem)dat.getItem(word);
                if (item == null || item.getStatus() < 2) {
                    if (word.length() >= 2 && word.charAt(0) != ':' && !"BEGIN".equals(word) && !"END".equals(word)) continue;
                    PersonNatureAttr pna = PERSONMAP.get(split[1]);
                    if (pna == null) {
                        pna = new PersonNatureAttr();
                    }
                    pna.set(temp.charAt(0), score);
                    PERSONMAP.put(word, pna);
                    continue;
                }
                PersonNatureAttr personAttr = item.termNatures.personAttr;
                if (personAttr == PersonNatureAttr.NULL) {
                    item.termNatures.personAttr = personAttr = new PersonNatureAttr();
                }
                personAttr.set(temp.charAt(0), score);
            }
        }
        finally {
            reader.close();
        }
        try {
            reader = MyStaticValue.getForeignDicReader();
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                FOREIGNSET.add(temp);
            }
        }
        finally {
            reader.close();
        }
    }

    public static int status(char c) {
        Item item = DAT.getDAT()[c];
        if (item == null) {
            return 0;
        }
        return item.getStatus();
    }

    public static boolean isInSystemDic(String word) {
        Item item = DAT.getItem(word);
        return item != null && item.getStatus() > 1;
    }

    public static AnsjItem getItem(int index) {
        AnsjItem item = (AnsjItem)DAT.getItem(index);
        if (item == null) {
            return AnsjItem.NULL;
        }
        return item;
    }

    public static AnsjItem getItem(String str) {
        AnsjItem item = (AnsjItem)DAT.getItem(str);
        if (item == null || item.getStatus() < 2) {
            return AnsjItem.NULL;
        }
        return item;
    }

    public static int getId(String str) {
        return DAT.getId(str);
    }

    public static PersonNatureAttr person(String name) {
        return PERSONMAP.get(name);
    }

    public static boolean foreign(String name) {
        return FOREIGNSET.contains(name);
    }

    public static boolean foreign(Term term) {
        String name = term.getName();
        boolean contains = FOREIGNSET.contains(name);
        if (contains) {
            return contains;
        }
        if (!term.getNatureStr().startsWith("nr")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (FOREIGNSET.contains(String.valueOf(name.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static void write2File(String path) throws IOException {
        ObjectOutputStream oop = new ObjectOutputStream(new FileOutputStream(new File(path)));
        oop.writeObject(DAT.getDAT());
        oop.writeObject(PERSONMAP);
        oop.writeObject(FOREIGNSET);
        oop.flush();
        oop.close();
    }

    public static DoubleArrayTire loadFromFile(String path) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(new File(path)));
        Item[] items = (Item[])ois.readObject();
        DoubleArrayTire dat = new DoubleArrayTire(items);
        PERSONMAP.putAll((Map)ois.readObject());
        FOREIGNSET.addAll((Set)ois.readObject());
        return dat;
    }
}

