/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import org.apache.activemq.jms.pool.PooledSession;

public class PooledMessageConsumer
implements MessageConsumer {
    private final PooledSession session;
    private final MessageConsumer delegate;

    public PooledMessageConsumer(PooledSession session, MessageConsumer delegate) {
        this.session = session;
        this.delegate = delegate;
    }

    public void close() throws JMSException {
        this.session.onConsumerClose(this.delegate);
        this.delegate.close();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.delegate.getMessageListener();
    }

    public String getMessageSelector() throws JMSException {
        return this.delegate.getMessageSelector();
    }

    public Message receive() throws JMSException {
        return this.delegate.receive();
    }

    public Message receive(long timeout) throws JMSException {
        return this.delegate.receive(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.delegate.receiveNoWait();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.delegate.setMessageListener(listener);
    }

    public String toString() {
        return "PooledMessageConsumer { " + this.delegate + " }";
    }
}

