/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.xml;

import java.io.Serializable;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.util.xml.BytesSource;
import org.apache.camel.util.xml.StreamSourceConverter;

public class StreamSourceConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, Serializable.class, StreamCache.class, false, (type, exchange, value) -> StreamSourceConverter.convertToSerializable((StreamCache)value, exchange));
        this.addTypeConverter(registry, StreamCache.class, SAXSource.class, false, (type, exchange, value) -> StreamSourceConverter.convertToStreamCache((SAXSource)value, exchange));
        this.addTypeConverter(registry, StreamCache.class, BytesSource.class, false, (type, exchange, value) -> StreamSourceConverter.convertToStreamCache((BytesSource)value));
        this.addTypeConverter(registry, StreamCache.class, StreamSource.class, false, (type, exchange, value) -> StreamSourceConverter.convertToStreamCache((StreamSource)value, exchange));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

