/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtils$;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.cluster.Broker;
import kafka.consumer.Whitelist;
import kafka.log.LogConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopicCommand$
implements ScalaObject {
    public static final TopicCommand$ MODULE$;

    static {
        new TopicCommand$();
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts$1 = new TopicCommand.TopicCommandOptions(args);
        int actions = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts$1.createOpt(), opts$1.listOpt(), opts$1.alterOpt(), opts$1.describeOpt()})).count((Function1)new anonfun.1(opts$1));
        if (actions != 1) {
            System.err.println("Command must include exactly one action: --list, --describe, --create or --alter");
            opts$1.parser().printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        opts$1.checkArgs();
        ZkClient zkClient = new ZkClient((String)opts$1.options().valueOf(opts$1.zkConnectOpt()), 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        try {
            if (opts$1.options().has((OptionSpec)opts$1.createOpt())) {
                this.createTopic(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.alterOpt())) {
                this.alterTopic(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.listOpt())) {
                this.listTopics(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.describeOpt())) {
                this.describeTopic(zkClient, opts$1);
            }
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing topic command ").append((Object)throwable.getMessage()).toString());
            Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
        }
        zkClient.close();
        return;
        {
            finally {
                zkClient.close();
            }
        }
    }

    private Seq<String> getTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        Seq allTopics = (Seq)ZkUtils$.MODULE$.getAllTopics(zkClient).sorted((Ordering)Ordering$String$.MODULE$);
        if (opts.options().has(opts.topicOpt())) {
            String topicsSpec = (String)opts.options().valueOf(opts.topicOpt());
            Whitelist topicsFilter$1 = new Whitelist(topicsSpec);
            seq = (Seq)allTopics.filter((Function1)new anonfun.getTopics.1(topicsFilter$1));
        } else {
            seq = allTopics;
        }
        return seq;
    }

    public void createTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        String topic = (String)opts.options().valueOf(opts.topicOpt());
        Properties configs = this.parseTopicConfigsToBeAdded(opts);
        if (opts.options().has(opts.replicaAssignmentOpt())) {
            Map<Integer, List<Integer>> assignment = this.parseReplicaAssignment((String)opts.options().valueOf(opts.replicaAssignmentOpt()));
            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, assignment, configs, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        } else {
            CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.partitionsOpt(), opts.replicationFactorOpt()}));
            int partitions = (Integer)opts.options().valueOf(opts.partitionsOpt());
            int replicas = (Integer)opts.options().valueOf(opts.replicationFactorOpt());
            AdminUtils$.MODULE$.createTopic(zkClient, topic, partitions, replicas, configs);
        }
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Created topic \"%s\".").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
    }

    public void alterTopic(ZkClient zkClient$1, TopicCommand.TopicCommandOptions opts$2) {
        Seq<String> topics = this.getTopics(zkClient$1, opts$2);
        topics.foreach((Function1)new anonfun.alterTopic.1(zkClient$1, opts$2));
    }

    public void listTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach((Function1)new anonfun.listTopics.1());
    }

    public void describeTopic(ZkClient zkClient$2, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient$2, opts);
        boolean reportUnderReplicatedPartitions$1 = opts.options().has((OptionSpec)opts.reportUnderReplicatedPartitionsOpt());
        boolean reportUnavailablePartitions$1 = opts.options().has((OptionSpec)opts.reportUnavailablePartitionsOpt());
        boolean reportOverriddenConfigs$1 = opts.options().has((OptionSpec)opts.topicsWithOverridesOpt());
        Set liveBrokers$1 = ((TraversableOnce)ZkUtils$.MODULE$.getAllBrokersInCluster(zkClient$2).map((Function1)new anonfun.2(), Seq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach((Function1)new anonfun.describeTopic.1(zkClient$2, reportUnderReplicatedPartitions$1, reportUnavailablePartitions$1, reportOverriddenConfigs$1, liveBrokers$1));
    }

    public String formatBroker(Broker broker) {
        return new StringBuilder().append(broker.id()).append((Object)" (").append((Object)broker.host()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)broker.port())).append((Object)")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = (Buffer)JavaConversions$.MODULE$.asBuffer(opts.options().valuesOf(opts.configOpt())).map((Function1)new anonfun.4(), Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1)new anonfun.parseTopicConfigsToBeAdded.2()), (Function0)new anonfun.parseTopicConfigsToBeAdded.1());
        Properties props$1 = new Properties();
        configsToBeAdded.foreach((Function1)new anonfun.parseTopicConfigsToBeAdded.3(props$1));
        LogConfig$.MODULE$.validate(props$1);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfigOpt())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)JavaConversions$.MODULE$.asBuffer(opts.options().valuesOf(opts.deleteConfigOpt())).map((Function1)new anonfun.5(), Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted$1 = new Properties();
            configsToBeDeleted.foreach((Function1)new anonfun.parseTopicConfigsToBeDeleted.1(propsToBeDeleted$1));
            LogConfig$.MODULE$.validateNames(propsToBeDeleted$1);
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Map<Integer, List<Integer>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList$1 = replicaAssignmentList.split(",");
        HashMap ret$1 = new HashMap();
        Predef$.MODULE$.intWrapper(0).until(Predef$.MODULE$.refArrayOps((Object[])partitionList$1).size()).foreach$mVc$sp((Function1)new anonfun.parseReplicaAssignment.1(partitionList$1, ret$1));
        return ret$1.toMap(Predef$.MODULE$.conforms());
    }

    private TopicCommand$() {
        MODULE$ = this;
    }
}

