/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Broker;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.ErrorMapping$;
import kafka.common.NotAssignedReplicaException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\teg\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0013A\u000b'\u000f^5uS>t'BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\f\u001d!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011aB7fiJL7m]\u0005\u00037a\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nQ\u0001^8qS\u000e,\u0012!\n\t\u0003M%r!!H\u0014\n\u0005!r\u0012A\u0002)sK\u0012,g-\u0003\u0002+W\t11\u000b\u001e:j]\u001eT!\u0001\u000b\u0010\t\u00115\u0002!\u0011!Q\u0001\n\u0015\na\u0001^8qS\u000e\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u0002cA\u0011QDM\u0005\u0003gy\u00111!\u00138u\u0011!)\u0004A!A!\u0002\u0013\t\u0014\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003\u0002C\u001c\u0001\u0005\u0003\u0007I\u0011\u0001\u0019\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u0005:\u0001\t\u0005\r\u0011\"\u0001;\u0003U\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]0%KF$\"a\u000f \u0011\u0005ua\u0014BA\u001f\u001f\u0005\u0011)f.\u001b;\t\u000f}B\u0014\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005\u0003!\u0011!Q!\nE\n!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA!A1\t\u0001B\u0001B\u0003%A)\u0001\u0003uS6,\u0007CA\tF\u0013\t1%C\u0001\u0003US6,\u0007\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N\t\u000511/\u001a:wKJL!a\u0014'\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"A\u0011\u000b\u0001B\u0001B\u0003%!*A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019a\u0014N\\5u}Q1Qk\u0016-Z5n\u0003\"A\u0016\u0001\u000e\u0003\tAQa\t*A\u0002\u0015BQa\f*A\u0002EBQa\u000e*A\u0002EBQa\u0011*A\u0002\u0011CQ\u0001\u0013*A\u0002)Cq!\u0018\u0001C\u0002\u0013%\u0001'A\u0007m_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\u0007?\u0002\u0001\u000b\u0011B\u0019\u0002\u001d1|7-\u00197Ce>\\WM]%eA!9\u0011\r\u0001b\u0001\n\u0013\u0011\u0017A\u00037pO6\u000bg.Y4feV\t1\r\u0005\u0002eO6\tQM\u0003\u0002g\t\u0005\u0019An\\4\n\u0005!,'A\u0003'pO6\u000bg.Y4fe\"1!\u000e\u0001Q\u0001\n\r\f1\u0002\\8h\u001b\u0006t\u0017mZ3sA!9A\u000e\u0001b\u0001\n\u0013i\u0017\u0001\u0003>l\u00072LWM\u001c;\u0016\u00039\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\u0011i\\7\r\\5f]RT!a\u001d;\u0002\r%\u0003\u0014\n^3d\u0015\u0005)\u0018aA8sO&\u0011q\u000f\u001d\u0002\t5.\u001cE.[3oi\"1\u0011\u0010\u0001Q\u0001\n9\f\u0011B_6DY&,g\u000e\u001e\u0011\t\u000fm\u0004\u0001\u0019!C\u0001y\u0006\u0011B.Z1eKJ\u0014V\r\u001d7jG\u0006LEm\u00149u+\u0005i\bcA\u000f\u007fc%\u0011qP\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\r\u0001\u00011A\u0005\u0002\u0005\u0015\u0011A\u00067fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR|F%Z9\u0015\u0007m\n9\u0001\u0003\u0005@\u0003\u0003\t\t\u00111\u0001~\u0011\u001d\tY\u0001\u0001Q!\nu\f1\u0003\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017\nZ(qi\u0002B\u0011\"a\u0004\u0001\u0001\u0004%\t!!\u0005\u0002\u001d%t7+\u001f8d%\u0016\u0004H.[2bgV\u0011\u00111\u0003\t\u0007\u0003+\tY\"a\b\u000e\u0005\u0005]!bAA\r=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0011q\u0003\u0002\u0004'\u0016$\bc\u0001,\u0002\"%\u0019\u00111\u0005\u0002\u0003\u000fI+\u0007\u000f\\5dC\"I\u0011q\u0005\u0001A\u0002\u0013\u0005\u0011\u0011F\u0001\u0013S:\u001c\u0016P\\2SKBd\u0017nY1t?\u0012*\u0017\u000fF\u0002<\u0003WA\u0011bPA\u0013\u0003\u0003\u0005\r!a\u0005\t\u0011\u0005=\u0002\u0001)Q\u0005\u0003'\tq\"\u001b8Ts:\u001c'+\u001a9mS\u000e\f7\u000f\t\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003k\t!#Y:tS\u001etW\r\u001a*fa2L7-Y'baV\u0011\u0011q\u0007\t\u0007#\u0005e\u0012'a\b\n\u0007\u0005m\"C\u0001\u0003Q_>d\u0007\u0002CA \u0001\u0001\u0006I!a\u000e\u0002'\u0005\u001c8/[4oK\u0012\u0014V\r\u001d7jG\u0006l\u0015\r\u001d\u0011\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0013a\u00057fC\u0012,'/S:s+B$\u0017\r^3M_\u000e\\W#\u0001\u0005\t\u000f\u0005%\u0003\u0001)A\u0005\u0011\u0005!B.Z1eKJL5O]+qI\u0006$X\rT8dW\u0002B\u0001\"!\u0014\u0001\u0001\u0004%I\u0001M\u0001\nu.4VM]:j_:D\u0011\"!\u0015\u0001\u0001\u0004%I!a\u0015\u0002\u001bi\\g+\u001a:tS>tw\fJ3r)\rY\u0014Q\u000b\u0005\t\u007f\u0005=\u0013\u0011!a\u0001c!9\u0011\u0011\f\u0001!B\u0013\t\u0014A\u0003>l-\u0016\u00148/[8oA!A\u0011Q\f\u0001A\u0002\u0013%\u0001'A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CA1\u0001\u0001\u0007I\u0011BA2\u0003=aW-\u00193fe\u0016\u0003xn\u00195`I\u0015\fHcA\u001e\u0002f!Aq(a\u0018\u0002\u0002\u0003\u0007\u0011\u0007C\u0004\u0002j\u0001\u0001\u000b\u0015B\u0019\u0002\u00191,\u0017\rZ3s\u000bB|7\r\u001b\u0011\t\u0011\u00055\u0004\u00011A\u0005\nA\nqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003g\n1cY8oiJ|G\u000e\\3s\u000bB|7\r[0%KF$2aOA;\u0011!y\u0014qNA\u0001\u0002\u0004\t\u0004bBA=\u0001\u0001\u0006K!M\u0001\u0011G>tGO]8mY\u0016\u0014X\t]8dQ\u0002B\u0011\"! \u0001\u0005\u0004%I!a \u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002\u0002B!\u00111QAH\u001d\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE\t\u0005Q1m\u001c8ue>dG.\u001a:\n\t\u00055\u0015qQ\u0001\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe&!\u0011\u0011SAJ\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0006\u0005\u0003\u001b\u000b9\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAA\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006q\u0011n\u001d*fa2L7-\u0019'pG\u0006dG\u0003BAP\u0003K\u00032!HAQ\u0013\r\t\u0019K\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t9+!'A\u0002E\n\u0011B]3qY&\u001c\u0017-\u00133\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\u0006\t\u0012n]+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3\u0015\u0005\u0005}\u0005bBAY\u0001\u0011\u0005\u00111W\u0001\u0013O\u0016$xJ]\"sK\u0006$XMU3qY&\u001c\u0017\r\u0006\u0003\u0002 \u0005U\u0006\"CAT\u0003_\u0003\n\u00111\u00012\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000b!bZ3u%\u0016\u0004H.[2b)\u0011\ti,a0\u0011\tuq\u0018q\u0004\u0005\n\u0003O\u000b9\f%AA\u0002EBq!a1\u0001\t\u0003\t)-\u0001\u000bmK\u0006$WM\u001d*fa2L7-Y%g\u0019>\u001c\u0017\r\u001c\u000b\u0003\u0003{Cq!!3\u0001\t\u0003\tY-A\u000bbI\u0012\u0014V\r\u001d7jG\u0006LeMT8u\u000bbL7\u000f^:\u0015\t\u0005}\u0011Q\u001a\u0005\t\u0003\u001f\f9\r1\u0001\u0002 \u00059!/\u001a9mS\u000e\f\u0007bBAj\u0001\u0011\u0005\u0011Q[\u0001\u0011CN\u001c\u0018n\u001a8fIJ+\u0007\u000f\\5dCN$\"!a\u0005\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\u0006i!/Z7pm\u0016\u0014V\r\u001d7jG\u0006$2aOAo\u0011\u001d\t9+a6A\u0002EBq!!9\u0001\t\u0003\t\u0019/\u0001\u0004eK2,G/\u001a\u000b\u0002w!9\u0011q\u001d\u0001\u0005\u0002\u0005%\u0018AD4fi2+\u0017\rZ3s\u000bB|7\r\u001b\u000b\u0002c!9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018AC7bW\u0016dU-\u00193feRA\u0011qTAy\u0003k\u0014)\u0001C\u0004\u0002t\u0006-\b\u0019A\u0019\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\t\u0011\u0005]\u00181\u001ea\u0001\u0003s\f!\u0003]1si&$\u0018n\u001c8Ti\u0006$X-\u00138g_B!\u00111 B\u0001\u001b\t\tiPC\u0002\u0002\u0000\u0012\t1!\u00199j\u0013\u0011\u0011\u0019!!@\u0003%A\u000b'\u000f^5uS>t7\u000b^1uK&sgm\u001c\u0005\b\u0005\u000f\tY\u000f1\u00012\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\"9!1\u0002\u0001\u0005\u0002\t5\u0011\u0001D7bW\u00164u\u000e\u001c7po\u0016\u0014HCCAP\u0005\u001f\u0011\tBa\u0005\u0003 !9\u00111\u001fB\u0005\u0001\u0004\t\u0004\u0002CA|\u0005\u0013\u0001\r!!?\t\u0011\tU!\u0011\u0002a\u0001\u0005/\tq\u0001\\3bI\u0016\u00148\u000f\u0005\u0004\u0002\u0016\u0005m!\u0011\u0004\t\u0004-\nm\u0011b\u0001B\u000f\u0005\t1!I]8lKJDqAa\u0002\u0003\n\u0001\u0007\u0011\u0007C\u0004\u0003$\u0001!\tA!\n\u0002?U\u0004H-\u0019;f\u0019\u0016\fG-\u001a:I/\u0006sG-T1zE\u0016,\u0005\u0010]1oI&\u001b(\u000fF\u0003<\u0005O\u0011I\u0003C\u0004\u0002(\n\u0005\u0002\u0019A\u0019\t\u0011\t-\"\u0011\u0005a\u0001\u0005[\taa\u001c4gg\u0016$\bcA\u000f\u00030%\u0019!\u0011\u0007\u0010\u0003\t1{gn\u001a\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0003y\u0019\u0007.Z2l\u000b:|Wo\u001a5SKBd\u0017nY1t%\u0016\f7\r[(gMN,G\u000f\u0006\u0004\u0003:\t\u0015#\u0011\n\t\b;\tm\u0012q\u0014B \u0013\r\u0011iD\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007u\u0011\t%C\u0002\u0003Dy\u0011Qa\u00155peRD\u0001Ba\u0012\u00034\u0001\u0007!QF\u0001\u000fe\u0016\fX/\u001b:fI>3gm]3u\u0011\u001d\u0011YEa\rA\u0002E\nAB]3rk&\u0014X\rZ!dWNDqAa\u0014\u0001\t\u0013\u0011\t&\u0001\fnCf\u0014W-\u00138de\u0016lWM\u001c;MK\u0006$WM\u001d%X)\rY$1\u000b\u0005\t\u0005+\u0012i\u00051\u0001\u0002 \u0005iA.Z1eKJ\u0014V\r\u001d7jG\u0006DqA!\u0017\u0001\t\u0003\u0011Y&\u0001\bnCf\u0014Wm\u00155sS:\\\u0017j\u001d:\u0015\u000bm\u0012iF!\u0019\t\u0011\t}#q\u000ba\u0001\u0005[\t1C]3qY&\u001c\u0017-T1y\u0019\u0006<G+[7f\u001bND\u0001Ba\u0019\u0003X\u0001\u0007!QF\u0001\u0016e\u0016\u0004H.[2b\u001b\u0006DH*Y4NKN\u001c\u0018mZ3t\u0011\u001d\u00119\u0007\u0001C\u0001\u0005S\nAcZ3u\u001fV$xJZ*z]\u000e\u0014V\r\u001d7jG\u0006\u001cH\u0003CA\n\u0005W\u0012iG!\u001d\t\u0011\tU#Q\ra\u0001\u0003?A\u0001Ba\u001c\u0003f\u0001\u0007!QF\u0001\u0011W\u0016,\u0007/\u00138Ts:\u001cG+[7f\u001bND\u0001Ba\u001d\u0003f\u0001\u0007!QF\u0001\u0013W\u0016,\u0007/\u00138Ts:\u001cW*Z:tC\u001e,7\u000fC\u0004\u0003x\u0001!\tA!\u001f\u0002-\u0005\u0004\b/\u001a8e\u001b\u0016\u001c8/Y4fgR{G*Z1eKJ$BAa\u001f\u0003\bB!!Q\u0010BB!\r!'qP\u0005\u0004\u0005\u0003+'a\u0001'pO&!!Q\u0011B@\u00055aunZ!qa\u0016tG-\u00138g_\"A!\u0011\u0012B;\u0001\u0004\u0011Y)\u0001\u0005nKN\u001c\u0018mZ3t!\u0011\u0011iIa%\u000e\u0005\t=%b\u0001BI\t\u00059Q.Z:tC\u001e,\u0017\u0002\u0002BK\u0005\u001f\u0013ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bb\u0002BM\u0001\u0011%!1T\u0001\nkB$\u0017\r^3JgJ$2a\u000fBO\u0011!\u0011yJa&A\u0002\u0005M\u0011A\u00028fo&\u001b(\u000fC\u0004\u0003$\u0002!\tE!*\u0002\r\u0015\fX/\u00197t)\u0011\tyJa*\t\u0011\t%&\u0011\u0015a\u0001\u0005W\u000bA\u0001\u001e5biB\u0019QD!,\n\u0007\t=fDA\u0002B]fDqAa-\u0001\t\u0003\nI/\u0001\u0005iCND7i\u001c3f\u0011\u001d\u00119\f\u0001C!\u0005s\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002K!I!Q\u0018\u0001\u0012\u0002\u0013\u0005!qX\u0001\u001dO\u0016$xJ]\"sK\u0006$XMU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tMK\u00022\u0005\u0007\\#A!2\u0011\t\t\u001d'\u0011[\u0007\u0003\u0005\u0013TAAa3\u0003N\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001ft\u0012AC1o]>$\u0018\r^5p]&!!1\u001bBe\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005/\u0004\u0011\u0013!C\u0001\u0005\u007f\u000bAcZ3u%\u0016\u0004H.[2bI\u0011,g-Y;mi\u0012\n\u0004")
public class Partition
implements Logging,
KafkaMetricsGroup,
ScalaObject {
    private final String topic;
    private final int partitionId;
    private int replicationFactor;
    public final Time kafka$cluster$Partition$$time;
    private final ReplicaManager replicaManager;
    private final int kafka$cluster$Partition$$localBrokerId;
    private final LogManager logManager;
    private final ZkClient zkClient;
    private Option<Integer> leaderReplicaIdOpt;
    private Set<Replica> inSyncReplicas;
    private final Pool<Integer, Replica> assignedReplicaMap;
    private final Object leaderIsrUpdateLock;
    private int kafka$cluster$Partition$$zkVersion;
    private int leaderEpoch;
    private int controllerEpoch;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public Gauge newGauge(String name, Gauge metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public /* synthetic */ boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Partition partition = this;
        synchronized (partition) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ int getReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public /* synthetic */ int getOrCreateReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void replicationFactor_$eq(int n) {
        this.replicationFactor = n;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public final int kafka$cluster$Partition$$localBrokerId() {
        return this.kafka$cluster$Partition$$localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    public Option<Integer> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Integer> option) {
        this.leaderReplicaIdOpt = option;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> set) {
        this.inSyncReplicas = set;
    }

    private Pool<Integer, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private Object leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    public final int kafka$cluster$Partition$$zkVersion() {
        return this.kafka$cluster$Partition$$zkVersion;
    }

    private void kafka$cluster$Partition$$zkVersion_$eq(int n) {
        this.kafka$cluster$Partition$$zkVersion = n;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int n) {
        this.leaderEpoch = n;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.kafka$cluster$Partition$$localBrokerId();
    }

    public boolean isUnderReplicated() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Boolean bl;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    bl = BoxesRunTime.boxToBoolean((this.inSyncReplicas().size() < this.assignedReplicas().size() ? 1 : 0) != 0);
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    bl = BoxesRunTime.boxToBoolean((boolean)false);
                }
                Boolean bl2 = bl;
                return BoxesRunTime.unboxToBoolean((Object)bl2);
            }
            throw new MatchError(option);
        }
    }

    public Replica getOrCreateReplica(int replicaId) {
        Option<Replica> option;
        block8: {
            Replica replica;
            block7: {
                Replica replica2;
                block6: {
                    Option<Replica> replicaOpt = this.getReplica(replicaId);
                    option = replicaOpt;
                    if (!(option instanceof Some)) break block6;
                    replica = (Replica)((Some)option).x();
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                if (this.isReplicaLocal(replicaId)) {
                    LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().defaultConfig().toProps(), AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient(), this.topic()));
                    Log log = this.logManager().createLog(new TopicAndPartition(this.topic(), this.partitionId()), config);
                    OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.replicaManager().highWatermarkCheckpoints().apply((Object)log.dir().getParentFile().getAbsolutePath());
                    Map<TopicAndPartition, Long> offsetMap = checkpoint.read();
                    if (!offsetMap.contains((Object)new TopicAndPartition(this.topic(), this.partitionId()))) {
                        this.warn((Function0<String>)new $anonfun$getOrCreateReplica$1(this));
                    }
                    long offset = Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)new TopicAndPartition(this.topic(), this.partitionId()), (Function0)new $anonfun$1(this)))).min(log.logEndOffset());
                    Replica localReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, offset, (Option<Log>)new Some((Object)log));
                    replica2 = this.addReplicaIfNotExists(localReplica);
                } else {
                    Replica remoteReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, Replica$.MODULE$.init$default$4(), (Option<Log>)Replica$.MODULE$.init$default$5());
                    replica2 = this.addReplicaIfNotExists(remoteReplica);
                }
                replica = (Replica)this.getReplica(replicaId).get();
            }
            return replica;
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(int replicaId) {
        Replica replica = this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)replicaId));
        return replica == null ? None$.MODULE$ : new Some((Object)replica);
    }

    public Option<Replica> leaderReplicaIfLocal() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Integer> option;
            block6: {
                Option<Replica> option2;
                option = this.leaderReplicaIdOpt();
                if (option instanceof Some) {
                    option2 = BoxesRunTime.unboxToInt((Object)((Some)option).x()) == this.kafka$cluster$Partition$$localBrokerId() ? this.getReplica(this.kafka$cluster$Partition$$localBrokerId()) : None$.MODULE$;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Integer> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block6;
                    option2 = None$.MODULE$;
                }
                Option<Replica> option4 = option2;
                return option4;
            }
            throw new MatchError(option);
        }
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    public void removeReplica(int replicaId) {
        this.assignedReplicaMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void delete() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            this.assignedReplicaMap().clear();
            this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
            this.leaderReplicaIdOpt_$eq((Option<Integer>)None$.MODULE$);
            this.liftedTree1$1();
            return;
        }
    }

    public int getLeaderEpoch() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            return this.leaderEpoch();
        }
    }

    public boolean makeLeader(int controllerId, PartitionStateInfo partitionStateInfo, int correlationId) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Set<Integer> allReplicas = partitionStateInfo.allReplicas();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
            allReplicas.foreach((Function1)new $anonfun$makeLeader$2(this));
            scala.collection.immutable.Set newInSyncReplicas = ((TraversableOnce)leaderAndIsr.isr().map((Function1)new $anonfun$2(this), List$.MODULE$.canBuildFrom())).toSet();
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1)new $anonfun$makeLeader$3(this), Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach((Function1)new $anonfun$makeLeader$1(this));
            this.assignedReplicas().foreach((Function1)new $anonfun$makeLeader$4(this));
            this.inSyncReplicas_$eq((Set<Replica>)newInSyncReplicas);
            this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
            this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
            this.leaderReplicaIdOpt_$eq((Option<Integer>)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())));
            this.maybeIncrementLeaderHW((Replica)this.getReplica(this.getReplica$default$1()).get());
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean makeFollower(int controllerId$1, PartitionStateInfo partitionStateInfo, Set<Broker> leaders, int correlationId$1) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option option;
            block6: {
                Set<Integer> allReplicas = partitionStateInfo.allReplicas();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1 = partitionStateInfo.leaderIsrAndControllerEpoch();
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
                int newLeaderBrokerId$1 = leaderAndIsr.leader();
                this.controllerEpoch_$eq(leaderIsrAndControllerEpoch$1.controllerEpoch());
                option = leaders.find((Function1)new $anonfun$makeFollower$2(this, newLeaderBrokerId$1));
                if (option instanceof Some) {
                    allReplicas.foreach((Function1)new $anonfun$makeFollower$3(this));
                    ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1)new $anonfun$makeFollower$4(this), Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach((Function1)new $anonfun$makeFollower$1(this));
                    this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
                    this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                    this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                    this.leaderReplicaIdOpt_$eq((Option<Integer>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId$1)));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    this.stateChangeLogger().error((Function0<String>)new $anonfun$makeFollower$5(this, controllerId$1, correlationId$1, leaderIsrAndControllerEpoch$1, newLeaderBrokerId$1));
                }
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
                return BoxesRunTime.unboxToBoolean((Object)bl);
            }
            throw new MatchError((Object)option);
        }
    }

    public void updateLeaderHWAndMaybeExpandIsr(int replicaId$1, long offset$1) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            block7: {
                Option<Replica> option;
                block10: {
                    block9: {
                        BoxedUnit boxedUnit;
                        block8: {
                            Replica replica;
                            this.debug((Function0<String>)new $anonfun$updateLeaderHWAndMaybeExpandIsr$1(this, replicaId$1, offset$1));
                            Option<Replica> replicaOpt = this.getReplica(replicaId$1);
                            if (!replicaOpt.isDefined()) break block7;
                            Replica replica2 = (Replica)replicaOpt.get();
                            replica2.logEndOffset_$eq(offset$1);
                            option = this.leaderReplicaIfLocal();
                            if (!(option instanceof Some)) break block8;
                            Some some = (Some)option;
                            Replica leaderReplica = replica = (Replica)some.x();
                            Replica replica3 = (Replica)this.getReplica(replicaId$1).get();
                            long leaderHW = leaderReplica.highWatermark();
                            if (!this.inSyncReplicas().contains((Object)replica3) && ((SetLike)this.assignedReplicas().map((Function1)new $anonfun$updateLeaderHWAndMaybeExpandIsr$3(this), Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1)) && replica3.logEndOffset() >= leaderHW) {
                                Set newInSyncReplicas$1 = this.inSyncReplicas().$plus((Object)replica3);
                                this.info((Function0<String>)new $anonfun$updateLeaderHWAndMaybeExpandIsr$4(this, newInSyncReplicas$1));
                                this.updateIsr((Set<Replica>)newInSyncReplicas$1);
                                this.replicaManager().isrExpandRate().mark();
                            }
                            this.maybeIncrementLeaderHW(leaderReplica);
                            boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Replica> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            throw new NotAssignedReplicaException(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d for partition [%s,%d] since the replica %d is not recognized to be one of the assigned replicas %s for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)replicaId$1), BoxesRunTime.boxToLong((long)offset$1), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)replicaId$1), ((TraversableOnce)this.assignedReplicas().map((Function1)new $anonfun$updateLeaderHWAndMaybeExpandIsr$2(this), Set$.MODULE$.canBuildFrom())).mkString(","), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
        }
    }

    public Tuple2<Boolean, Short> checkEnoughReplicasReachOffset(long requiredOffset$1, int requiredAcks$1) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Tuple2 tuple2;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    int numAcks$1 = this.inSyncReplicas().count((Function1)new $anonfun$3(this, requiredOffset$1));
                    this.trace((Function0<String>)new $anonfun$checkEnoughReplicasReachOffset$1(this, requiredAcks$1, numAcks$1));
                    tuple2 = requiredAcks$1 < 0 && numAcks$1 >= this.inSyncReplicas().size() || requiredAcks$1 > 0 && numAcks$1 >= requiredAcks$1 ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError())) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NotLeaderForPartitionCode()));
                }
                Tuple2 tuple22 = tuple2;
                return tuple22;
            }
            throw new MatchError(option);
        }
    }

    private void maybeIncrementLeaderHW(Replica leaderReplica) {
        long oldHighWatermark$1;
        Set allLogEndOffsets$1 = (Set)this.inSyncReplicas().map((Function1)new $anonfun$4(this), Set$.MODULE$.canBuildFrom());
        long newHighWatermark$1 = BoxesRunTime.unboxToLong((Object)allLogEndOffsets$1.min((Ordering)Ordering$Long$.MODULE$));
        if (newHighWatermark$1 > (oldHighWatermark$1 = leaderReplica.highWatermark())) {
            leaderReplica.highWatermark_$eq(newHighWatermark$1);
            this.debug((Function0<String>)new $anonfun$maybeIncrementLeaderHW$1(this, newHighWatermark$1));
        } else {
            this.debug((Function0<String>)new $anonfun$maybeIncrementLeaderHW$2(this, allLogEndOffsets$1, newHighWatermark$1, oldHighWatermark$1));
        }
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs, long replicaMaxLagMessages) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block10: {
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        option = this.leaderReplicaIfLocal();
                        if (!(option instanceof Some)) break block8;
                        Some some = (Some)option;
                        Replica replica = (Replica)some.x();
                        Replica leaderReplica = replica;
                        Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs, replicaMaxLagMessages);
                        if (outOfSyncReplicas.size() > 0) {
                            Set newInSyncReplicas$2 = (Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                            Predef$.MODULE$.assert(newInSyncReplicas$2.size() > 0);
                            this.info((Function0<String>)new $anonfun$maybeShrinkIsr$1(this, newInSyncReplicas$2));
                            this.updateIsr((Set<Replica>)newInSyncReplicas$2);
                            this.maybeIncrementLeaderHW(leaderReplica);
                            this.replicaManager().isrShrinkRate().mark();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long keepInSyncTimeMs$1, long keepInSyncMessages$1) {
        Set slowReplicas$1;
        long leaderLogEndOffset$1 = leaderReplica.logEndOffset();
        Set candidateReplicas = this.inSyncReplicas().$minus((Object)leaderReplica);
        Set stuckReplicas$1 = (Set)candidateReplicas.filter((Function1)new $anonfun$5(this, keepInSyncTimeMs$1));
        if (stuckReplicas$1.size() > 0) {
            this.debug((Function0<String>)new $anonfun$getOutOfSyncReplicas$1(this, stuckReplicas$1));
        }
        if ((slowReplicas$1 = (Set)candidateReplicas.filter((Function1)new $anonfun$6(this, keepInSyncMessages$1, leaderLogEndOffset$1))).size() > 0) {
            this.debug((Function0<String>)new $anonfun$getOutOfSyncReplicas$2(this, slowReplicas$1));
        }
        return (Set)stuckReplicas$1.$plus$plus((TraversableOnce)slowReplicas$1);
    }

    public Log.LogAppendInfo appendMessagesToLeader(ByteBufferMessageSet messages) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block5: {
                Replica replica;
                Option<Replica> leaderReplicaOpt;
                option = leaderReplicaOpt = this.leaderReplicaIfLocal();
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                Replica leaderReplica = replica = (Replica)some.x();
                Log log = (Log)leaderReplica.log().get();
                Log.LogAppendInfo info = log.append(messages, true);
                this.maybeIncrementLeaderHW(leaderReplica);
                Log.LogAppendInfo logAppendInfo = info;
                return logAppendInfo;
            }
            None$ none$ = None$.MODULE$;
            Option<Replica> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
            }
            throw new MatchError(option);
        }
    }

    private void updateIsr(Set<Replica> newIsr$1) {
        this.debug((Function0<String>)new $anonfun$updateIsr$1(this, newIsr$1));
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.kafka$cluster$Partition$$localBrokerId(), this.leaderEpoch(), (List<Integer>)((TraversableOnce)newIsr$1.map((Function1)new $anonfun$7(this), Set$.MODULE$.canBuildFrom())).toList(), this.kafka$cluster$Partition$$zkVersion());
        Tuple2<Boolean, Integer> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic(), this.partitionId()), ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr, this.controllerEpoch()), this.kafka$cluster$Partition$$zkVersion());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            int newVersion = tuple22._2$mcI$sp();
            if (updateSucceeded) {
                this.inSyncReplicas_$eq(newIsr$1);
                this.kafka$cluster$Partition$$zkVersion_$eq(newVersion);
                this.trace((Function0<String>)new $anonfun$updateIsr$2(this, newIsr$1));
            } else {
                this.info((Function0<String>)new $anonfun$updateIsr$3(this));
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public boolean equals(Object that) {
        if (that instanceof Partition) {
            Partition other = (Partition)that;
            return this.topic().equals(other.topic()) && this.partitionId() == other.partitionId();
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            StringBuilder partitionString = new StringBuilder();
            partitionString.append(new StringBuilder().append((Object)"Topic: ").append((Object)this.topic()).toString());
            partitionString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
            partitionString.append(new StringBuilder().append((Object)"; Leader: ").append(this.leaderReplicaIdOpt()).toString());
            partitionString.append(new StringBuilder().append((Object)"; AssignedReplicas: ").append((Object)this.assignedReplicaMap().keys().mkString(",")).toString());
            partitionString.append(new StringBuilder().append((Object)"; InSyncReplicas: ").append((Object)((TraversableOnce)this.inSyncReplicas().map((Function1)new $anonfun$toString$1(this), Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
            String string = partitionString.toString();
            return string;
        }
    }

    private final void liftedTree1$1() {
        try {
            this.logManager().deleteLog(new TopicAndPartition(this.topic(), this.partitionId()));
        }
        catch (IOException iOException) {
            this.fatal((Function0<String>)new $anonfun$liftedTree1$1$1(this), (Function0<Throwable>)new $anonfun$liftedTree1$1$2(this, iOException));
            Runtime.getRuntime().halt(1);
        }
    }

    public Partition(String topic, int partitionId, int replicationFactor, Time time, ReplicaManager replicaManager) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.replicationFactor = replicationFactor;
        this.kafka$cluster$Partition$$time = time;
        this.replicaManager = replicaManager;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$cluster$Partition$$localBrokerId = replicaManager.config().brokerId();
        this.logManager = replicaManager.logManager();
        this.zkClient = replicaManager.zkClient();
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Set$.MODULE$.empty();
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.init$default$1());
        this.leaderIsrUpdateLock = new Object();
        this.kafka$cluster$Partition$$zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.newGauge(new StringBuilder().append((Object)topic).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).append((Object)"-UnderReplicated").toString(), new $anon$1(this));
    }
}

