/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.KafkaException;
import kafka.common.MessageSizeTooLargeException;
import kafka.consumer.ConsumerIterator$;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t/\u0011\u001aB\u0001A\u0005'SA\u0019!\"D\b\u000e\u0003-Q!\u0001\u0004\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00059Y!\u0001E%uKJ\fGo\u001c:UK6\u0004H.\u0019;f!\u0011\u00012#F\u0012\u000e\u0003EQ!A\u0005\u0003\u0002\u000f5,7o]1hK&\u0011A#\u0005\u0002\u0013\u001b\u0016\u001c8/Y4f\u0003:$W*\u001a;bI\u0006$\u0018\r\u0005\u0002\u0017/1\u0001A\u0001\u0003\r\u0001\t\u0003\u0005)\u0019A\r\u0003\u0003-\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t1B\u0005\u0002\u0005&\u0001\u0011\u0005\tQ1\u0001\u001a\u0005\u00051\u0006C\u0001\u0006(\u0013\tA3BA\u0004M_\u001e<\u0017N\\4\u0011\u0005mQ\u0013BA\u0016\u001d\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u00115\u0002!Q1A\u0005\n9\nqa\u00195b]:,G.F\u00010!\r\u0001t'O\u0007\u0002c)\u0011!gM\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0003Y\nAA[1wC&\u0011\u0001(\r\u0002\u000e\u00052|7m[5oOF+X-^3\u0011\u0005iZT\"\u0001\u0002\n\u0005q\u0012!\u0001\u0005$fi\u000eDW\r\u001a#bi\u0006\u001c\u0005.\u001e8l\u0011!q\u0004A!A!\u0002\u0013y\u0013\u0001C2iC:tW\r\u001c\u0011\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005\u000b\u0011cY8ogVlWM\u001d+j[\u0016|W\u000f^'t!\tY\")\u0003\u0002D9\t\u0019\u0011J\u001c;\t\u0011\u0015\u0003!Q1A\u0005\n\u0019\u000b!b[3z\t\u0016\u001cw\u000eZ3s+\u00059\u0005c\u0001%L+5\t\u0011J\u0003\u0002K\t\u0005Q1/\u001a:jC2L'0\u001a:\n\u00051K%a\u0002#fG>$WM\u001d\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u000f\u0006Y1.Z=EK\u000e|G-\u001a:!\u0011!\u0001\u0006A!b\u0001\n\u0013\t\u0016\u0001\u0004<bYV,G)Z2pI\u0016\u0014X#\u0001*\u0011\u0007![5\u0005\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003S\u000351\u0018\r\\;f\t\u0016\u001cw\u000eZ3sA!Aa\u000b\u0001BC\u0002\u0013\u0005q+\u0001\u0005dY&,g\u000e^%e+\u0005A\u0006CA-]\u001d\tY\",\u0003\u0002\\9\u00051\u0001K]3eK\u001aL!!\u00180\u0003\rM#(/\u001b8h\u0015\tYF\u0004\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003Y\u0003%\u0019G.[3oi&#\u0007\u0005C\u0003c\u0001\u0011\u00051-\u0001\u0004=S:LGO\u0010\u000b\u0007I\u00164w\r[5\u0011\ti\u0002Qc\t\u0005\u0006[\u0005\u0004\ra\f\u0005\u0006\u0001\u0006\u0004\r!\u0011\u0005\u0006\u000b\u0006\u0004\ra\u0012\u0005\u0006!\u0006\u0004\rA\u0015\u0005\u0006-\u0006\u0004\r\u0001\u0017\u0005\bW\u0002\u0001\r\u0011\"\u0003m\u0003\u001d\u0019WO\u001d:f]R,\u0012!\u001c\t\u0004]F\u001cX\"A8\u000b\u0005A\f\u0014AB1u_6L7-\u0003\u0002s_\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0002uy~t!!\u001e>\u000f\u0005YLX\"A<\u000b\u0005a4\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tYH$A\u0004qC\u000e\\\u0017mZ3\n\u0005ut(\u0001C%uKJ\fGo\u001c:\u000b\u0005md\u0002c\u0001\t\u0002\u0002%\u0019\u00111A\t\u0003!5+7o]1hK\u0006sGm\u00144gg\u0016$\b\"CA\u0004\u0001\u0001\u0007I\u0011BA\u0005\u0003-\u0019WO\u001d:f]R|F%Z9\u0015\t\u0005-\u0011\u0011\u0003\t\u00047\u00055\u0011bAA\b9\t!QK\\5u\u0011%\t\u0019\"!\u0002\u0002\u0002\u0003\u0007Q.A\u0002yIEBq!a\u0006\u0001A\u0003&Q.\u0001\u0005dkJ\u0014XM\u001c;!\u0011%\tY\u0002\u0001a\u0001\n\u0013\ti\"\u0001\tdkJ\u0014XM\u001c;U_BL7-\u00138g_V\u0011\u0011q\u0004\t\u0004u\u0005\u0005\u0012bAA\u0012\u0005\t\u0011\u0002+\u0019:uSRLwN\u001c+pa&\u001c\u0017J\u001c4p\u0011%\t9\u0003\u0001a\u0001\n\u0013\tI#\u0001\u000bdkJ\u0014XM\u001c;U_BL7-\u00138g_~#S-\u001d\u000b\u0005\u0003\u0017\tY\u0003\u0003\u0006\u0002\u0014\u0005\u0015\u0012\u0011!a\u0001\u0003?A\u0001\"a\f\u0001A\u0003&\u0011qD\u0001\u0012GV\u0014(/\u001a8u)>\u0004\u0018nY%oM>\u0004\u0003\"CA\u001a\u0001\u0001\u0007I\u0011BA\u001b\u00039\u0019wN\\:v[\u0016$wJ\u001a4tKR,\"!a\u000e\u0011\u0007m\tI$C\u0002\u0002<q\u0011A\u0001T8oO\"I\u0011q\b\u0001A\u0002\u0013%\u0011\u0011I\u0001\u0013G>t7/^7fI>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005\r\u0003BCA\n\u0003{\t\t\u00111\u0001\u00028!A\u0011q\t\u0001!B\u0013\t9$A\bd_:\u001cX/\\3e\u001f\u001a47/\u001a;!\u0011%\tY\u0005\u0001b\u0001\n\u0013\ti%\u0001\nd_:\u001cX/\\3s)>\u0004\u0018nY*uCR\u001cXCAA(!\rQ\u0014\u0011K\u0005\u0004\u0003'\u0012!AE\"p]N,X.\u001a:U_BL7m\u0015;biND\u0001\"a\u0016\u0001A\u0003%\u0011qJ\u0001\u0014G>t7/^7feR{\u0007/[2Ti\u0006$8\u000f\t\u0005\b\u00037\u0002A\u0011IA/\u0003\u0011qW\r\u001f;\u0015\u0003=Aq!!\u0019\u0001\t#\ti&\u0001\u0005nC.,g*\u001a=u\u0011\u001d\t)\u0007\u0001C\u0001\u0003O\n\u0011c\u00197fCJ\u001cUO\u001d:f]R\u001c\u0005.\u001e8l)\t\tY\u0001")
public class ConsumerIterator<K, V>
extends IteratorTemplate<MessageAndMetadata<K, V>>
implements Logging,
ScalaObject {
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<K> keyDecoder;
    private final Decoder<V> valueDecoder;
    private final String clientId;
    private AtomicReference<Iterator<MessageAndOffset>> current;
    private PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo;
    private long kafka$consumer$ConsumerIterator$$consumedOffset;
    private final ConsumerTopicStats consumerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerIterator consumerIterator = this;
        synchronized (consumerIterator) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<K> keyDecoder() {
        return this.keyDecoder;
    }

    private Decoder<V> valueDecoder() {
        return this.valueDecoder;
    }

    public String clientId() {
        return this.clientId;
    }

    private AtomicReference<Iterator<MessageAndOffset>> current() {
        return this.current;
    }

    private void current_$eq(AtomicReference<Iterator<MessageAndOffset>> atomicReference) {
        this.current = atomicReference;
    }

    public final PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo() {
        return this.kafka$consumer$ConsumerIterator$$currentTopicInfo;
    }

    private void kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(PartitionTopicInfo partitionTopicInfo) {
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = partitionTopicInfo;
    }

    public final long kafka$consumer$ConsumerIterator$$consumedOffset() {
        return this.kafka$consumer$ConsumerIterator$$consumedOffset;
    }

    private void kafka$consumer$ConsumerIterator$$consumedOffset_$eq(long l) {
        this.kafka$consumer$ConsumerIterator$$consumedOffset = l;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MessageAndMetadata<K, V> next() {
        void var1_1;
        MessageAndMetadata item = (MessageAndMetadata)super.next();
        if (this.kafka$consumer$ConsumerIterator$$consumedOffset() < 0L) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.kafka$consumer$ConsumerIterator$$consumedOffset())})));
        }
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(this.kafka$consumer$ConsumerIterator$$consumedOffset());
        String topic$1 = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic();
        this.trace((Function0<String>)new $anonfun$next$1(this, topic$1));
        this.consumerTopicStats().getConsumerTopicStats(topic$1).messageRate().mark();
        this.consumerTopicStats().getConsumerAllTopicStats().messageRate().mark();
        return var1_1;
    }

    @Override
    public MessageAndMetadata<K, V> makeNext() {
        FetchedDataChunk currentDataChunk = null;
        Iterator<MessageAndOffset> localCurrent = this.current().get();
        if (localCurrent == null || !localCurrent.hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                currentDataChunk = this.channel().take();
            } else {
                currentDataChunk = this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS);
                if (currentDataChunk == null) {
                    this.resetState();
                    throw new ConsumerTimeoutException();
                }
            }
            if (currentDataChunk == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                this.debug((Function0<String>)new $anonfun$makeNext$1(this));
                this.channel().offer(currentDataChunk);
                return (MessageAndMetadata)this.allDone();
            }
            this.kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(currentDataChunk.topicInfo());
            long cdcFetchOffset$1 = currentDataChunk.fetchOffset();
            long ctiConsumeOffset$1 = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset();
            if (ctiConsumeOffset$1 < cdcFetchOffset$1) {
                this.error((Function0<String>)new $anonfun$makeNext$2(this, cdcFetchOffset$1, ctiConsumeOffset$1));
                this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(cdcFetchOffset$1);
            }
            localCurrent = currentDataChunk.messages().iterator();
            this.current().set(localCurrent);
            if (currentDataChunk.messages().validBytes() == 0) {
                throw new MessageSizeTooLargeException(new StringBuilder().append((Object)"Found a message larger than the maximum fetch size of this consumer on topic ").append((Object)Predef$.MODULE$.augmentString("%s partition %d at fetch offset %d. Increase the fetch size, or decrease the maximum message size the broker will allow.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentDataChunk.topicInfo().topic(), BoxesRunTime.boxToInteger((int)currentDataChunk.topicInfo().partitionId()), BoxesRunTime.boxToLong((long)currentDataChunk.fetchOffset())}))).toString());
            }
        }
        MessageAndOffset item = (MessageAndOffset)localCurrent.next();
        while (item.offset() < this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset() && localCurrent.hasNext()) {
            item = (MessageAndOffset)localCurrent.next();
        }
        this.kafka$consumer$ConsumerIterator$$consumedOffset_$eq(item.nextOffset());
        item.message().ensureValid();
        return new MessageAndMetadata<K, V>(this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic(), this.kafka$consumer$ConsumerIterator$$currentTopicInfo().partitionId(), item.message(), item.offset(), this.keyDecoder(), this.valueDecoder());
    }

    public void clearCurrentChunk() {
        this.debug((Function0<String>)new $anonfun$clearCurrentChunk$1(this));
        this.current().set(null);
    }

    public ConsumerIterator(BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<K> keyDecoder, Decoder<V> valueDecoder, String clientId) {
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        this.clientId = clientId;
        Logging$class.$init$(this);
        this.current = new AtomicReference<Object>(null);
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = null;
        this.kafka$consumer$ConsumerIterator$$consumedOffset = -1L;
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

