/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.RequestOrResponse;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0011\u0005yyR\"\u0001\u0002\n\u0005\u0001\u0012!aD&bM.\f7i\u001c8ue>dG.\u001a:\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u001f\u0001!)1!\ta\u0001;!9q\u0005\u0001b\u0001\n\u0013A\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\t\u0011\u0006\u0005\u0002\u001fU%\u00111F\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bBB\u0017\u0001A\u0003%\u0011&\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002cA\u0011qCM\u0005\u0003ga\u00111!\u00138u\u0011\u0019)\u0004\u0001)A\u0005c\u0005i1m\u001c8ue>dG.\u001a:JI\u0002Bqa\u000e\u0001C\u0002\u0013%\u0001(\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005I\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003!Q8n\u00197jK:$(B\u0001 @\u0003\u0019I\u0005'\u0013;fG*\t\u0001)A\u0002pe\u001eL!AQ\u001e\u0003\u0011i[7\t\\5f]RDa\u0001\u0012\u0001!\u0002\u0013I\u0014!\u0003>l\u00072LWM\u001c;!\u0011\u001d1\u0005\u00011A\u0005\u0002\u001d\u000bAB]3qY&\u001c\u0017m\u0015;bi\u0016,\u0012\u0001\u0013\t\u0005\u0013:\u00036+D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055C\u0012AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0010R\u0013\t\u0011&AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\r\u0005\u0002\u001f)&\u0011QK\u0001\u0002\r%\u0016\u0004H.[2b'R\fG/\u001a\u0005\b/\u0002\u0001\r\u0011\"\u0001Y\u0003A\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011qCW\u0005\u00037b\u0011A!\u00168ji\"9QLVA\u0001\u0002\u0004A\u0015a\u0001=%c!1q\f\u0001Q!\n!\u000bQB]3qY&\u001c\u0017m\u0015;bi\u0016\u0004\u0003bB1\u0001\u0005\u0004%\tAY\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001d!\tqB-\u0003\u0002f\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007BB4\u0001A\u0003%1-A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004j\u0001\t\u0007I\u0011\u00026\u0002\u0015!\f7o\u0015;beR,G-F\u0001l!\ta7/D\u0001n\u0015\tqw.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003aF\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0011H\"\u0001\u0003vi&d\u0017B\u0001;n\u00055\tEo\\7jG\n{w\u000e\\3b]\"1a\u000f\u0001Q\u0001\n-\f1\u0002[1t'R\f'\u000f^3eA!9\u0001\u0010\u0001b\u0001\n\u0013I\u0018!E:uCR,7\t[1oO\u0016dunZ4feV\t!\u0010\u0005\u0002|}:\u0011a\u0004`\u0005\u0003{\n\tqbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0005\u0004\u007f\u0006\u0005!!E*uCR,7\t[1oO\u0016dunZ4fe*\u0011QP\u0001\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003{\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\u000591\u000f^1siV\u0004H#A-\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\f\u0005\t\"/Z4jgR,'\u000fT5ti\u0016tWM]:\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\f\u0005A1\u000f[;uI><h\u000eC\u0004\u0002\u0018\u0001!\t!!\u0007\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\b3\u0006m\u0011qEA\u0016\u0011!\ti\"!\u0006A\u0002\u0005}\u0011\u0001\u0003:fa2L7-Y:\u0011\u000b\u0005\u0005\u00121\u0005)\u000e\u00031K1!!\nM\u0005\r\u0019V\r\u001e\u0005\b\u0003S\t)\u00021\u0001T\u0003-!\u0018M]4fiN#\u0018\r^3\t\u0015\u00055\u0012Q\u0003I\u0001\u0002\u0004\ty#A\u0005dC2d'-Y2lgB\u0019a$!\r\n\u0007\u0005M\"AA\u0005DC2d'-Y2lg\"9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012!\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKR9\u0011,a\u000f\u0002@\u0005\u0005\u0003bBA\u001f\u0003k\u0001\r\u0001U\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\b\u0003S\t)\u00041\u0001T\u0011!\ti#!\u000eA\u0002\u0005=\u0002bBA#\u0001\u0011\u0005\u0011qI\u0001\u001eCJ,\u0017\t\u001c7SKBd\u0017nY1t\r>\u0014Hk\u001c9jG\u0012+G.\u001a;fIR!\u0011\u0011JA(!\r9\u00121J\u0005\u0004\u0003\u001bB\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003#\n\u0019\u00051\u0001\u0002T\u0005)Ao\u001c9jGB!\u0011QKA.\u001d\r9\u0012qK\u0005\u0004\u00033B\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002^\u0005}#AB*ue&twMC\u0002\u0002ZaAq!a\u0019\u0001\t\u0003\t)'A\u0015jg\u0006#H*Z1ti>sWMU3qY&\u001c\u0017-\u00138EK2,G/[8o'R\f'\u000f^3e'R\fG/\u001a\u000b\u0005\u0003\u0013\n9\u0007\u0003\u0005\u0002R\u0005\u0005\u0004\u0019AA*\u0011\u001d\tY\u0007\u0001C\u0001\u0003[\nqB]3qY&\u001c\u0017m]%o'R\fG/\u001a\u000b\u0007\u0003?\ty'!\u001d\t\u0011\u0005E\u0013\u0011\u000ea\u0001\u0003'Bq!a\u001d\u0002j\u0001\u00071+A\u0003ti\u0006$X\rC\u0004\u0002x\u0001!\t!!\u001f\u00021I,\u0007\u000f\\5dCNLe\u000eR3mKRLwN\\*uCR,7\u000f\u0006\u0003\u0002 \u0005m\u0004\u0002CA)\u0003k\u0002\r!a\u0015\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\u0006I\u0012m]:feR4\u0016\r\\5e!J,g/[8vgN#\u0018\r^3t)\u001dI\u00161QAC\u0003\u001fCq!!\u0010\u0002~\u0001\u0007\u0001\u000b\u0003\u0005\u0002\b\u0006u\u0004\u0019AAE\u0003)1'o\\7Ti\u0006$Xm\u001d\t\u0006\u0003C\tYiU\u0005\u0004\u0003\u001bc%aA*fc\"9\u0011\u0011FA?\u0001\u0004\u0019\u0006bBAJ\u0001\u0011%\u0011QS\u0001\u001de\u0016<\u0017n\u001d;fe\n\u0013xn[3s\u0007\"\fgnZ3MSN$XM\\3s)\t\t9\n\u0005\u0004\u0002\u001a\u0006m\u0015qT\u0007\u0002c&\u0019\u0011QT9\u0003\t1K7\u000f\u001e\t\u0004\u0013\u0005\u0005\u0016bAA/\u0015!9\u0011Q\u0015\u0001\u0005\n\u0005-\u0011AF5oSRL\u0017\r\\5{KJ+\u0007\u000f\\5dCN#\u0018\r^3\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u0006Q\u0002/\u0019:uSRLwN\\:BgNLwM\\3e)>\u0014%o\\6feR1\u0011QVA^\u0003\u0003\u0004b!!\t\u0002\f\u0006=\u0006\u0003BAY\u0003ok!!a-\u000b\u0007\u0005UF!\u0001\u0004d_6lwN\\\u0005\u0005\u0003s\u000b\u0019LA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"!0\u0002(\u0002\u0007\u0011qX\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005\u0005\u00121RA*\u0011\u001d\t\u0019-a*A\u0002E\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0004\u000b\u0003\u000f\u0004A\u0011!A\u0001\u0002\u0005%'\u0001\u0006\"s_.,'o\u00115b]\u001e,G*[:uK:,'oE\u0004\u0002F\"\tY\r\u0005\f\u0011\u0007i\ni-C\u0002\u0002Pn\u0012\u0001#\u0013.l\u0007\"LG\u000e\u001a'jgR,g.\u001a:\t\u000f\t\n)\r\"\u0001\u0002TR\u0011\u0011Q\u001b\t\u0005\u0003/\f)-D\u0001\u0001\u0011!\tY.!2\u0005\u0002\u0005u\u0017!\u00055b]\u0012dWm\u00115jY\u0012\u001c\u0005.\u00198hKR)\u0011,a8\u0002d\"A\u0011\u0011]Am\u0001\u0004\t\u0019&\u0001\u0006qCJ,g\u000e\u001e)bi\"D\u0001\"!:\u0002Z\u0002\u0007\u0011q]\u0001\u0012GV\u0014(/\u001a8u\u0005J|7.\u001a:MSN$\bCBAM\u00037\u000b\u0019\u0006C\u0005\u0002l\u0002\t\n\u0011\"\u0001\u0002n\u0006a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTCAAxU\u0011\ty#!=,\u0005\u0005M\b\u0003BA{\u0003\u007fl!!a>\u000b\t\u0005e\u00181`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!@\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\t9PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReplicaStateMachine
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int kafka$controller$ReplicaStateMachine$$controllerId;
    private final ZkClient kafka$controller$ReplicaStateMachine$$zkClient;
    private Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    public final int kafka$controller$ReplicaStateMachine$$controllerId() {
        return this.kafka$controller$ReplicaStateMachine$$controllerId;
    }

    public final ZkClient kafka$controller$ReplicaStateMachine$$zkClient() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient;
    }

    public Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    public void replicaState_$eq(Map<PartitionAndReplica, ReplicaState> map) {
        this.replicaState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.kafka$controller$ReplicaStateMachine$$controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)new $anonfun$startup$1(this));
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas$1, ReplicaState targetState$1, Callbacks callbacks$1) {
        if (replicas$1.size() > 0) {
            this.info((Function0<String>)new $anonfun$handleStateChanges$1(this, replicas$1, targetState$1));
            try {
                this.brokerRequestBatch().newBatch();
                replicas$1.foreach((Function1)new $anonfun$handleStateChanges$2(this, targetState$1, callbacks$1));
                this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch(), this.kafka$controller$ReplicaStateMachine$$controllerContext().correlationId().getAndIncrement());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new $anonfun$handleStateChanges$3(this, targetState$1), (Function0<Throwable>)new $anonfun$handleStateChanges$4(this, throwable));
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState$2, Callbacks callbacks) {
        block14: {
            TopicAndPartition topicAndPartition$1;
            int replicaId$1;
            block15: {
                String topic$1 = partitionAndReplica.topic();
                int partition$1 = partitionAndReplica.partition();
                replicaId$1 = partitionAndReplica.replica();
                topicAndPartition$1 = new TopicAndPartition(topic$1, partition$1);
                if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) break block15;
                ReplicaState currState$1 = (ReplicaState)this.replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0)new $anonfun$1(this));
                try {
                    ReplicaState replicaState;
                    block25: {
                        Option option;
                        block30: {
                            boolean leaderAndIsrIsEmpty;
                            block28: {
                                boolean bl;
                                block26: {
                                    Option<LeaderIsrAndControllerEpoch> option2;
                                    block29: {
                                        block27: {
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                                            Seq replicaAssignment;
                                            block20: {
                                                Option option3;
                                                block24: {
                                                    block22: {
                                                        block23: {
                                                            block21: {
                                                                block16: {
                                                                    Option<LeaderIsrAndControllerEpoch> option4;
                                                                    block19: {
                                                                        block18: {
                                                                            block17: {
                                                                                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt;
                                                                                replicaAssignment = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$1);
                                                                                replicaState = targetState$2;
                                                                                NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                                ReplicaState replicaState2 = replicaState;
                                                                                if (newReplica$ != null ? !newReplica$.equals(replicaState2) : replicaState2 != null) break block16;
                                                                                this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), targetState$2);
                                                                                option4 = leaderIsrAndControllerEpochOpt = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkClient(), topic$1, partition$1);
                                                                                if (!(option4 instanceof Some)) break block17;
                                                                                Some some = (Some)option4;
                                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = (LeaderIsrAndControllerEpoch)some.x();
                                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch3 = leaderIsrAndControllerEpoch2;
                                                                                if (leaderIsrAndControllerEpoch3.leaderAndIsr().leader() == replicaId$1) {
                                                                                    throw new StateChangeFailedException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition$1}))).append((Object)"state as it is being requested to become leader").toString());
                                                                                }
                                                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic$1, partition$1, leaderIsrAndControllerEpoch3, (Seq<Integer>)replicaAssignment, (Function1<RequestOrResponse, Object>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                                break block18;
                                                                            }
                                                                            None$ none$ = None$.MODULE$;
                                                                            Option<LeaderIsrAndControllerEpoch> option5 = option4;
                                                                            if (none$ != null ? !none$.equals(option5) : option5 != null) break block19;
                                                                        }
                                                                        this.replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                                                                        this.stateChangeLogger().trace((Function0<String>)new $anonfun$handleStateChange$2(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                                                        break block14;
                                                                    }
                                                                    throw new MatchError(option4);
                                                                }
                                                                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                                                                ReplicaState replicaState3 = replicaState;
                                                                if (!(replicaDeletionStarted$ != null ? !replicaDeletionStarted$.equals(replicaState3) : replicaState3 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), targetState$2);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                                                                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic$1, partition$1, true, callbacks.stopReplicaResponseCallback());
                                                                    this.stateChangeLogger().trace((Function0<String>)new $anonfun$handleStateChange$3(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                                                    break block14;
                                                                }
                                                                ReplicaDeletionIneligible$ replicaDeletionIneligible$ = ReplicaDeletionIneligible$.MODULE$;
                                                                ReplicaState replicaState4 = replicaState;
                                                                if (!(replicaDeletionIneligible$ != null ? !replicaDeletionIneligible$.equals(replicaState4) : replicaState4 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState$2);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                                                    this.stateChangeLogger().trace((Function0<String>)new $anonfun$handleStateChange$4(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                                                    break block14;
                                                                }
                                                                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                                                                ReplicaState replicaState5 = replicaState;
                                                                if (!(replicaDeletionSuccessful$ != null ? !replicaDeletionSuccessful$.equals(replicaState5) : replicaState5 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState$2);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                                                                    this.stateChangeLogger().trace((Function0<String>)new $anonfun$handleStateChange$5(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                                                    break block14;
                                                                }
                                                                NonExistentReplica$ nonExistentReplica$ = NonExistentReplica$.MODULE$;
                                                                ReplicaState replicaState6 = replicaState;
                                                                if (!(nonExistentReplica$ != null ? !nonExistentReplica$.equals(replicaState6) : replicaState6 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionSuccessful$[]{ReplicaDeletionSuccessful$.MODULE$})), targetState$2);
                                                                    Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$1);
                                                                    this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition$1, currentAssignedReplicas.filterNot((Function1)new $anonfun$handleStateChange$1(this, replicaId$1)));
                                                                    this.replicaState().remove((Object)partitionAndReplica);
                                                                    this.stateChangeLogger().trace((Function0<String>)new $anonfun$handleStateChange$6(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                                                    break block14;
                                                                }
                                                                OnlineReplica$ onlineReplica$ = OnlineReplica$.MODULE$;
                                                                ReplicaState replicaState7 = replicaState;
                                                                if (onlineReplica$ != null ? !onlineReplica$.equals(replicaState7) : replicaState7 != null) break block20;
                                                                this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState$2);
                                                                ReplicaState replicaState8 = (ReplicaState)this.replicaState().apply((Object)partitionAndReplica);
                                                                NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                ReplicaState replicaState9 = replicaState8;
                                                                if (newReplica$ != null ? !newReplica$.equals(replicaState9) : replicaState9 != null) break block21;
                                                                Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$1);
                                                                Object object = currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition$1, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId$1), Seq$.MODULE$.canBuildFrom()));
                                                                this.stateChangeLogger().trace((Function0<String>)new $anonfun$handleStateChange$7(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                                                break block22;
                                                            }
                                                            option3 = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition$1);
                                                            if (!(option3 instanceof Some)) break block23;
                                                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic$1, partition$1, (LeaderIsrAndControllerEpoch)((Some)option3).x(), (Seq<Integer>)replicaAssignment, (Function1<RequestOrResponse, Object>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                            this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                            this.stateChangeLogger().trace((Function0<String>)new $anonfun$handleStateChange$8(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                                            break block22;
                                                        }
                                                        None$ none$ = None$.MODULE$;
                                                        Option option6 = option3;
                                                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block24;
                                                    }
                                                    this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                    break block14;
                                                }
                                                throw new MatchError((Object)option3);
                                            }
                                            OfflineReplica$ offlineReplica$ = OfflineReplica$.MODULE$;
                                            ReplicaState replicaState10 = replicaState;
                                            if (offlineReplica$ != null ? !offlineReplica$.equals(replicaState10) : replicaState10 != null) break block25;
                                            this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState$2);
                                            this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic$1, partition$1, false, (Function2<RequestOrResponse, Integer, Object>)this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                                            option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition$1);
                                            if (!(option instanceof Some)) break block26;
                                            option2 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(topic$1, partition$1, replicaId$1);
                                            if (!(option2 instanceof Some)) break block27;
                                            Some some = (Some)option2;
                                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{updatedLeaderIsrAndControllerEpoch.leaderAndIsr().leader()})), topic$1, partition$1, updatedLeaderIsrAndControllerEpoch, (Seq<Integer>)replicaAssignment, (Function1<RequestOrResponse, Object>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                            this.replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                                            this.stateChangeLogger().trace((Function0<String>)new $anonfun$2(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1));
                                            bl = false;
                                            break block28;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<LeaderIsrAndControllerEpoch> option7 = option2;
                                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block29;
                                        bl = true;
                                        break block28;
                                    }
                                    throw new MatchError(option2);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option8 = option;
                                if (none$ != null ? !none$.equals(option8) : option8 != null) break block30;
                                bl = leaderAndIsrIsEmpty = true;
                            }
                            if (leaderAndIsrIsEmpty) {
                                throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition$1})));
                            }
                            break block14;
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError((Object)replicaState);
                }
                catch (Throwable throwable) {
                    this.stateChangeLogger().error((Function0<String>)new $anonfun$handleStateChange$9(this, targetState$2, topic$1, partition$1, replicaId$1, currState$1), (Function0<Throwable>)new $anonfun$handleStateChange$10(this, throwable));
                }
            }
            throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition$1, targetState$2})));
        }
    }

    public boolean areAllReplicasForTopicDeleted(String topic$2) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic$2);
        scala.collection.immutable.Map replicaStatesForTopic$1 = ((TraversableOnce)replicasForTopic2.map((Function1)new $anonfun$3(this), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.debug((Function0<String>)new $anonfun$areAllReplicasForTopicDeleted$1(this, topic$2, replicaStatesForTopic$1));
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new $anonfun$areAllReplicasForTopicDeleted$2(this)));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new $anonfun$4(this), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new $anonfun$isAtLeastOneReplicaInDeletionStartedState$1(this)));
    }

    public Set<PartitionAndReplica> replicasInState(String topic$3, ReplicaState state$1) {
        return ((MapLike)this.replicaState().filter((Function1)new $anonfun$replicasInState$1(this, topic$3, state$1))).keySet();
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic$4) {
        Set deletionStates$1 = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.replicaState().filter((Function1)new $anonfun$replicasInDeletionStates$1(this, topic$4, deletionStates$1))).keySet();
    }

    private void assertValidPreviousStates(PartitionAndReplica partitionAndReplica$1, Seq<ReplicaState> fromStates$1, ReplicaState targetState$3) {
        Predef$.MODULE$.assert(fromStates$1.contains(this.replicaState().apply((Object)partitionAndReplica$1)), (Function0)new $anonfun$assertValidPreviousStates$1(this, partitionAndReplica$1, fromStates$1, targetState$3));
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)new BrokerChangeListener());
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().foreach((Function1)new $anonfun$initializeReplicaState$1(this));
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId$1) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new $anonfun$partitionsAssignedToBroker$1(this, brokerId$1))).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController controller) {
        this.kafka$controller$ReplicaStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controller.controllerContext();
        this.kafka$controller$ReplicaStateMachine$$controllerId = controller.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkClient = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkClient();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            BrokerChangeListener brokerChangeListener = this;
            synchronized (brokerChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        public void trace(Function0 msg) {
            Logging$class.trace(this, msg);
        }

        public Object trace(Function0 e) {
            return Logging$class.trace(this, e);
        }

        public void trace(Function0 msg, Function0 e) {
            Logging$class.trace(this, msg, e);
        }

        public void swallowTrace(Function0 action) {
            Logging$class.swallowTrace(this, action);
        }

        public void debug(Function0 msg) {
            Logging$class.debug(this, msg);
        }

        public Object debug(Function0 e) {
            return Logging$class.debug(this, e);
        }

        public void debug(Function0 msg, Function0 e) {
            Logging$class.debug(this, msg, e);
        }

        public void swallowDebug(Function0 action) {
            Logging$class.swallowDebug(this, action);
        }

        public void info(Function0 msg) {
            Logging$class.info(this, msg);
        }

        public Object info(Function0 e) {
            return Logging$class.info(this, e);
        }

        public void info(Function0 msg, Function0 e) {
            Logging$class.info(this, msg, e);
        }

        public void swallowInfo(Function0 action) {
            Logging$class.swallowInfo(this, action);
        }

        public void warn(Function0 msg) {
            Logging$class.warn(this, msg);
        }

        public Object warn(Function0 e) {
            return Logging$class.warn(this, e);
        }

        public void warn(Function0 msg, Function0 e) {
            Logging$class.warn(this, msg, e);
        }

        public void swallowWarn(Function0 action) {
            Logging$class.swallowWarn(this, action);
        }

        public void swallow(Function0 action) {
            Logging$class.swallow(this, action);
        }

        public void error(Function0 msg) {
            Logging$class.error(this, msg);
        }

        public Object error(Function0 e) {
            return Logging$class.error(this, e);
        }

        public void error(Function0 msg, Function0 e) {
            Logging$class.error(this, msg, e);
        }

        public void swallowError(Function0 action) {
            Logging$class.swallowError(this, action);
        }

        public void fatal(Function0 msg) {
            Logging$class.fatal(this, msg);
        }

        public Object fatal(Function0 e) {
            return Logging$class.fatal(this, e);
        }

        public void fatal(Function0 msg, Function0 e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleChildChange(String parentPath$1, List<String> currentBrokerList$1) {
            this.info((Function0<String>)new BrokerChangeListener$$anonfun$handleChildChange$2(this, parentPath$1, currentBrokerList$1));
            Utils$.MODULE$.inLock(this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerLock(), new BrokerChangeListener$$anonfun$handleChildChange$1(this, currentBrokerList$1));
        }

        public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return ReplicaStateMachine.this;
        }

        public BrokerChangeListener() {
            if (ReplicaStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[BrokerChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)ReplicaStateMachine.this.kafka$controller$ReplicaStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

