/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.InvalidMessageException;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Utils$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mv!B\u0001\u0003\u0011\u000b9\u0011aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tq!\\3tg\u0006<WMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1\u0001B\u0003\u0002\u0005\u0002\u0003E)a\u0003\u0002\b\u001b\u0016\u001c8/Y4f'\rIA\u0002\u0006\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u\u0011\u0015Y\u0012\u0002\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u001f\u0013\t\u0007I\u0011A\u0010\u0002\u0013\r\u00138m\u00144gg\u0016$X#\u0001\u0011\u0011\u0005U\t\u0013B\u0001\u0012\u0017\u0005\rIe\u000e\u001e\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004'\u0013\t\u0007I\u0011A\u0010\u0002\u0013\r\u00138\rT3oORD\u0007B\u0002\u0015\nA\u0003%\u0001%\u0001\u0006De\u000edUM\\4uQ\u0002BqAK\u0005C\u0002\u0013\u0005q$A\u0006NC\u001eL7m\u00144gg\u0016$\bB\u0002\u0017\nA\u0003%\u0001%\u0001\u0007NC\u001eL7m\u00144gg\u0016$\b\u0005C\u0004/\u0013\t\u0007I\u0011A\u0010\u0002\u00175\u000bw-[2MK:<G\u000f\u001b\u0005\u0007a%\u0001\u000b\u0011\u0002\u0011\u0002\u00195\u000bw-[2MK:<G\u000f\u001b\u0011\t\u000fIJ!\u0019!C\u0001?\u0005\u0001\u0012\t\u001e;sS\n,H/Z:PM\u001a\u001cX\r\u001e\u0005\u0007i%\u0001\u000b\u0011\u0002\u0011\u0002#\u0005#HO]5ckR,7o\u00144gg\u0016$\b\u0005C\u00047\u0013\t\u0007I\u0011A\u0010\u0002!\u0005#HO]5ckR,7\u000fT3oORD\u0007B\u0002\u001d\nA\u0003%\u0001%A\tBiR\u0014\u0018NY;uKNdUM\\4uQ\u0002BqAO\u0005C\u0002\u0013\u0005q$A\u0007LKf\u001c\u0016N_3PM\u001a\u001cX\r\u001e\u0005\u0007y%\u0001\u000b\u0011\u0002\u0011\u0002\u001d-+\u0017pU5{K>3gm]3uA!9a(\u0003b\u0001\n\u0003y\u0012!D&fsNK'0\u001a'f]\u001e$\b\u000e\u0003\u0004A\u0013\u0001\u0006I\u0001I\u0001\u000f\u0017\u0016L8+\u001b>f\u0019\u0016tw\r\u001e5!\u0011\u001d\u0011\u0015B1A\u0005\u0002}\t\u0011bS3z\u001f\u001a47/\u001a;\t\r\u0011K\u0001\u0015!\u0003!\u0003)YU-_(gMN,G\u000f\t\u0005\b\r&\u0011\r\u0011\"\u0001 \u0003=1\u0016\r\\;f'&TX\rT3oORD\u0007B\u0002%\nA\u0003%\u0001%\u0001\tWC2,XmU5{K2+gn\u001a;iA!9!*\u0003b\u0001\n\u0003y\u0012aD'fgN\fw-Z(wKJDW-\u00193\t\r1K\u0001\u0015!\u0003!\u0003AiUm]:bO\u0016|e/\u001a:iK\u0006$\u0007\u0005C\u0004O\u0013\t\u0007I\u0011A\u0010\u0002\u001b5Kg\u000eS3bI\u0016\u00148+\u001b>f\u0011\u0019\u0001\u0016\u0002)A\u0005A\u0005qQ*\u001b8IK\u0006$WM]*ju\u0016\u0004\u0003b\u0002*\n\u0005\u0004%\taU\u0001\u0012\u0007V\u0014(/\u001a8u\u001b\u0006<\u0017n\u0019,bYV,W#\u0001+\u0011\u0005U)\u0016B\u0001,\u0017\u0005\u0011\u0011\u0015\u0010^3\t\raK\u0001\u0015!\u0003U\u0003I\u0019UO\u001d:f]Rl\u0015mZ5d-\u0006dW/\u001a\u0011\t\u000fiK!\u0019!C\u0001?\u0005\u00192i\\7qe\u0016\u001c8/[8o\u0007>$W-T1tW\"1A,\u0003Q\u0001\n\u0001\nAcQ8naJ,7o]5p]\u000e{G-Z'bg.\u0004\u0003b\u00020\n\u0005\u0004%\taH\u0001\u000e\u001d>\u001cu.\u001c9sKN\u001c\u0018n\u001c8\t\r\u0001L\u0001\u0015!\u0003!\u00039qunQ8naJ,7o]5p]\u00022\u0001B\u0003\u0002\u0005\u0002\u0003\u0005\tAY\n\u0004C2!\u0002\u0002\u00033b\u0005\u000b\u0007I\u0011A3\u0002\r\t,hMZ3s+\u00051\u0007CA4k\u001b\u0005A'BA5\u0011\u0003\rq\u0017n\\\u0005\u0003W\"\u0014!BQ=uK\n+hMZ3s\u0011!i\u0017M!A!\u0002\u00131\u0017a\u00022vM\u001a,'\u000f\t\u0005\u00067\u0005$\ta\u001c\u000b\u0003aF\u0004\"\u0001C1\t\u000b\u0011t\u0007\u0019\u00014\t\u000bm\tG\u0011A:\u0015\u0011A$\u0018p_A\u0001\u0003\u000bAQ!\u001e:A\u0002Y\fQAY=uKN\u00042!F<U\u0013\tAhCA\u0003BeJ\f\u0017\u0010C\u0003{e\u0002\u0007a/A\u0002lKfDQ\u0001 :A\u0002u\fQaY8eK\u000e\u0004\"\u0001\u0003@\n\u0005}\u0014!\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011\u0019\t\u0019A\u001da\u0001A\u0005i\u0001/Y=m_\u0006$wJ\u001a4tKRDa!a\u0002s\u0001\u0004\u0001\u0013a\u00039bs2|\u0017\rZ*ju\u0016DaaG1\u0005\u0002\u0005-Ac\u00029\u0002\u000e\u0005=\u0011\u0011\u0003\u0005\u0007k\u0006%\u0001\u0019\u0001<\t\ri\fI\u00011\u0001w\u0011\u0019a\u0018\u0011\u0002a\u0001{\"11$\u0019C\u0001\u0003+!R\u0001]A\f\u00033Aa!^A\n\u0001\u00041\bB\u0002?\u0002\u0014\u0001\u0007Q\u0010\u0003\u0004\u001cC\u0012\u0005\u0011Q\u0004\u000b\u0006a\u0006}\u0011\u0011\u0005\u0005\u0007k\u0006m\u0001\u0019\u0001<\t\ri\fY\u00021\u0001w\u0011\u0019Y\u0012\r\"\u0001\u0002&Q\u0019\u0001/a\n\t\rU\f\u0019\u00031\u0001w\u0011\u001d\tY#\u0019C\u0001\u0003[\tqbY8naV$Xm\u00115fG.\u001cX/\u001c\u000b\u0003\u0003_\u00012!FA\u0019\u0013\r\t\u0019D\u0006\u0002\u0005\u0019>tw\rC\u0004\u00028\u0005$\t!!\u000f\u0002\u0011\rDWmY6tk6,\"!a\f\t\u000f\u0005u\u0012\r\"\u0001\u0002@\u00059\u0011n\u001d,bY&$WCAA!!\r)\u00121I\u0005\u0004\u0003\u000b2\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0013\nG\u0011AA&\u0003-)gn];sKZ\u000bG.\u001b3\u0015\u0005\u00055\u0003cA\u000b\u0002P%\u0019\u0011\u0011\u000b\f\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003+\nG\u0011A\u0010\u0002\tML'0\u001a\u0005\u0007\u00033\nG\u0011A\u0010\u0002\u000f-,\u0017pU5{K\"9\u0011QL1\u0005\u0002\u0005}\u0012A\u00025bg.+\u0017\u0010\u0003\u0004\u0002b\u0005$IaH\u0001\u0012a\u0006LHn\\1e'&TXm\u00144gg\u0016$\bBBA\u0004C\u0012\u0005q\u0004C\u0004\u0002h\u0005$\t!!\u001b\u0002\r%\u001ch*\u001e7m)\t\t\t\u0005\u0003\u0004\u0002n\u0005$\taU\u0001\u0006[\u0006<\u0017n\u0019\u0005\u0007\u0003c\nG\u0011A*\u0002\u0015\u0005$HO]5ckR,7\u000fC\u0004\u0002v\u0005$\t!a\u001e\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cW#A?\t\r\u0005m\u0014\r\"\u0001f\u0003\u001d\u0001\u0018-\u001f7pC\u0012DQA_1\u0005\u0002\u0015Dq!!!b\t\u0013\t\u0019)\u0001\btY&\u001cW\rR3mS6LG/\u001a3\u0015\u0007\u0019\f)\tC\u0004\u0002\b\u0006}\u0004\u0019\u0001\u0011\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005-\u0015\r\"\u0011\u0002\u000e\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001d\r)\u00121S\u0005\u0004\u0003+3\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0006m%AB*ue&twMC\u0002\u0002\u0016ZAq!a(b\t\u0003\n\t+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0003\n\u0019\u000b\u0003\u0005\u0002&\u0006u\u0005\u0019AAT\u0003\r\tg.\u001f\t\u0004+\u0005%\u0016bAAV-\t\u0019\u0011I\\=\t\u000f\u0005=\u0016\r\"\u0011\u00022\u0006A\u0001.Y:i\u0007>$W\rF\u0001!\u0001")
public class Message
implements ScalaObject {
    private final ByteBuffer buffer;

    public static final int NoCompression() {
        return Message$.MODULE$.NoCompression();
    }

    public static final int CompressionCodeMask() {
        return Message$.MODULE$.CompressionCodeMask();
    }

    public static final byte CurrentMagicValue() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    public static final int MinHeaderSize() {
        return Message$.MODULE$.MinHeaderSize();
    }

    public static final int MessageOverhead() {
        return Message$.MODULE$.MessageOverhead();
    }

    public static final int ValueSizeLength() {
        return Message$.MODULE$.ValueSizeLength();
    }

    public static final int KeyOffset() {
        return Message$.MODULE$.KeyOffset();
    }

    public static final int KeySizeLength() {
        return Message$.MODULE$.KeySizeLength();
    }

    public static final int KeySizeOffset() {
        return Message$.MODULE$.KeySizeOffset();
    }

    public static final int AttributesLength() {
        return Message$.MODULE$.AttributesLength();
    }

    public static final int AttributesOffset() {
        return Message$.MODULE$.AttributesOffset();
    }

    public static final int MagicLength() {
        return Message$.MODULE$.MagicLength();
    }

    public static final int MagicOffset() {
        return Message$.MODULE$.MagicOffset();
    }

    public static final int CrcLength() {
        return Message$.MODULE$.CrcLength();
    }

    public static final int CrcOffset() {
        return Message$.MODULE$.CrcOffset();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public Message(byte[] bytes, byte[] key, CompressionCodec codec, int payloadOffset, int payloadSize) {
        this(ByteBuffer.allocate(Message$.MODULE$.CrcLength() + Message$.MODULE$.MagicLength() + Message$.MODULE$.AttributesLength() + Message$.MODULE$.KeySizeLength() + (key == null ? 0 : key.length) + Message$.MODULE$.ValueSizeLength() + (bytes == null ? 0 : (payloadSize >= 0 ? payloadSize : bytes.length - payloadOffset))));
        ByteBuffer byteBuffer;
        this.buffer().position(Message$.MODULE$.MagicOffset());
        this.buffer().put(Message$.MODULE$.CurrentMagicValue());
        byte attributes = 0;
        if (codec.codec() > 0) {
            attributes = (byte)(attributes | Message$.MODULE$.CompressionCodeMask() & codec.codec());
        }
        this.buffer().put(attributes);
        if (key == null) {
            byteBuffer = this.buffer().putInt(-1);
        } else {
            this.buffer().putInt(key.length);
            byteBuffer = this.buffer().put(key, 0, key.length);
        }
        int size2 = bytes == null ? -1 : (payloadSize >= 0 ? payloadSize : bytes.length - payloadOffset);
        this.buffer().putInt(size2);
        Object object = bytes != null ? this.buffer().put(bytes, payloadOffset, size2) : BoxedUnit.UNIT;
        this.buffer().rewind();
        Utils$.MODULE$.writeUnsignedInt(this.buffer(), Message$.MODULE$.CrcOffset(), this.computeChecksum());
    }

    public Message(byte[] bytes, byte[] key, CompressionCodec codec) {
        this(bytes, key, codec, 0, -1);
    }

    public Message(byte[] bytes, CompressionCodec codec) {
        this(bytes, null, codec);
    }

    public Message(byte[] bytes, byte[] key) {
        this(bytes, key, NoCompressionCodec$.MODULE$);
    }

    public Message(byte[] bytes) {
        this(bytes, null, NoCompressionCodec$.MODULE$);
    }

    public long computeChecksum() {
        return Utils$.MODULE$.crc32(this.buffer().array(), this.buffer().arrayOffset() + Message$.MODULE$.MagicOffset(), this.buffer().limit() - Message$.MODULE$.MagicOffset());
    }

    public long checksum() {
        return Utils$.MODULE$.readUnsignedInt(this.buffer(), Message$.MODULE$.CrcOffset());
    }

    public boolean isValid() {
        return this.checksum() == this.computeChecksum();
    }

    public void ensureValid() {
        if (this.isValid()) {
            return;
        }
        throw new InvalidMessageException(new StringBuilder().append((Object)"Message is corrupt (stored crc = ").append((Object)BoxesRunTime.boxToLong((long)this.checksum())).append((Object)", computed crc = ").append((Object)BoxesRunTime.boxToLong((long)this.computeChecksum())).append((Object)")").toString());
    }

    public int size() {
        return this.buffer().limit();
    }

    public int keySize() {
        return this.buffer().getInt(Message$.MODULE$.KeySizeOffset());
    }

    public boolean hasKey() {
        return this.keySize() >= 0;
    }

    private int payloadSizeOffset() {
        return Message$.MODULE$.KeyOffset() + package$.MODULE$.max(0, this.keySize());
    }

    public int payloadSize() {
        return this.buffer().getInt(this.payloadSizeOffset());
    }

    public boolean isNull() {
        return this.payloadSize() < 0;
    }

    public byte magic() {
        return this.buffer().get(Message$.MODULE$.MagicOffset());
    }

    public byte attributes() {
        return this.buffer().get(Message$.MODULE$.AttributesOffset());
    }

    public CompressionCodec compressionCodec() {
        return CompressionCodec$.MODULE$.getCompressionCodec(this.buffer().get(Message$.MODULE$.AttributesOffset()) & Message$.MODULE$.CompressionCodeMask());
    }

    public ByteBuffer payload() {
        return this.sliceDelimited(this.payloadSizeOffset());
    }

    public ByteBuffer key() {
        return this.sliceDelimited(Message$.MODULE$.KeySizeOffset());
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer sliceDelimited(int start) {
        ByteBuffer byteBuffer;
        int size2 = this.buffer().getInt(start);
        if (size2 < 0) {
            byteBuffer = null;
        } else {
            void var3_3;
            ByteBuffer b = this.buffer().duplicate();
            b.position(start + 4);
            b = b.slice();
            b.limit(size2);
            b.rewind();
            byteBuffer = var3_3;
        }
        return byteBuffer;
    }

    public String toString() {
        return Predef$.MODULE$.augmentString("Message(magic = %d, attributes = %d, crc = %d, key = %s, payload = %s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.magic()), BoxesRunTime.boxToByte((byte)this.attributes()), BoxesRunTime.boxToLong((long)this.checksum()), this.key(), this.payload()}));
    }

    public boolean equals(Object any) {
        Object object = any;
        return object instanceof Message ? this.buffer().equals(((Message)object).buffer()) : false;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public Message(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

