/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spring.boot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.log4j2.Log4J2LoggingSystem;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;

public class Log4j2CloudConfigLoggingSystem
extends Log4J2LoggingSystem {
    private static final String HTTPS = "https";
    public static final String ENVIRONMENT_KEY = "SpringEnvironment";
    private static final String OVERRIDE_PARAM = "override";
    private static Logger LOGGER = StatusLogger.getLogger();

    public Log4j2CloudConfigLoggingSystem(ClassLoader loader) {
        super(loader);
    }

    public void initialize(LoggingInitializationContext initializationContext, String configLocation, LogFile logFile) {
        this.getLoggerContext().putObjectIfAbsent(ENVIRONMENT_KEY, (Object)initializationContext.getEnvironment());
        super.initialize(initializationContext, configLocation, logFile);
    }

    protected String[] getStandardConfigLocations() {
        String[] locations = super.getStandardConfigLocations();
        PropertiesUtil props = new PropertiesUtil(new Properties());
        String location = props.getStringProperty("log4j.configurationFile");
        if (location != null) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getStandardConfigLocations()));
            list.add(location);
            locations = list.toArray(Strings.EMPTY_ARRAY);
        }
        return locations;
    }

    protected void loadDefaults(LoggingInitializationContext initializationContext, LogFile logFile) {
        if (logFile != null) {
            this.loadConfiguration(this.getBootPackagedConfigFile("log4j2-file.xml"), logFile);
        } else {
            this.loadConfiguration(this.getBootPackagedConfigFile("log4j2.xml"), logFile);
        }
    }

    private String getBootPackagedConfigFile(String fileName) {
        String defaultPath = ClassUtils.getPackageName(Log4J2LoggingSystem.class);
        defaultPath = defaultPath.replace('.', '/');
        defaultPath = defaultPath + "/" + fileName;
        defaultPath = "classpath:" + defaultPath;
        return defaultPath;
    }

    protected void loadConfiguration(String location, LogFile logFile) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        try {
            LoggerContext ctx = this.getLoggerContext();
            String[] locations = this.parseConfigLocations(location);
            if (locations.length == 1) {
                URL url = ResourceUtils.getURL((String)location);
                ConfigurationSource source = this.getConfigurationSource(url);
                if (source != null) {
                    ctx.start(ConfigurationFactory.getInstance().getConfiguration(ctx, source));
                }
            } else {
                ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
                for (String sourceLocation : locations) {
                    ConfigurationSource source = this.getConfigurationSource(ResourceUtils.getURL((String)sourceLocation));
                    if (source == null) continue;
                    Configuration config = ConfigurationFactory.getInstance().getConfiguration(ctx, source);
                    if (config instanceof AbstractConfiguration) {
                        configs.add((AbstractConfiguration)config);
                        continue;
                    }
                    LOGGER.warn("Configuration at {} cannot be combined in a CompositeConfiguration", (Object)sourceLocation);
                    return;
                }
                if (configs.size() > 1) {
                    ctx.start((Configuration)new CompositeConfiguration(configs));
                } else {
                    ctx.start((Configuration)configs.get(0));
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize Log4J2 logging from " + location, ex);
        }
    }

    public void cleanUp() {
        this.getLoggerContext().removeObject(ENVIRONMENT_KEY);
        super.cleanUp();
    }

    private String[] parseConfigLocations(String configLocations) {
        String[] uris = configLocations.split("\\?");
        ArrayList<String> locations = new ArrayList<String>();
        if (uris.length > 1) {
            locations.add(uris[0]);
            try {
                String[] pairs;
                URL url = new URL(configLocations);
                for (String pair : pairs = url.getQuery().split("&")) {
                    int idx = pair.indexOf("=");
                    try {
                        String key;
                        String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                        if (!key.equalsIgnoreCase(OVERRIDE_PARAM)) continue;
                        locations.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ex) {
                        LOGGER.warn("Bad data in configuration string: {}", (Object)pair);
                    }
                }
                return locations.toArray(Strings.EMPTY_ARRAY);
            }
            catch (MalformedURLException ex) {
                LOGGER.warn("Unable to parse configuration URL {}", (Object)configLocations);
            }
        }
        return new String[]{uris[0]};
    }

    private ConfigurationSource getConfigurationSource(URL url) throws IOException, URISyntaxException {
        SslConfiguration sslConfiguration;
        URLConnection urlConnection = url.openConnection();
        AuthorizationProvider provider = ConfigurationFactory.authorizationProvider((PropertiesUtil)PropertiesUtil.getProperties());
        provider.addAuthorization(urlConnection);
        if (url.getProtocol().equals(HTTPS) && (sslConfiguration = SslConfigurationFactory.getSslConfiguration()) != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslConfiguration.getSslSocketFactory());
            if (!sslConfiguration.isVerifyHostName()) {
                ((HttpsURLConnection)urlConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
            }
        }
        File file = FileUtils.fileFromUri((URI)url.toURI());
        try {
            if (file != null) {
                return new ConfigurationSource(urlConnection.getInputStream(), FileUtils.fileFromUri((URI)url.toURI()));
            }
            return new ConfigurationSource(urlConnection.getInputStream(), url, urlConnection.getLastModified());
        }
        catch (FileNotFoundException ex) {
            LOGGER.info("Unable to locate file {}, ignoring.", (Object)url.toString());
            return null;
        }
    }

    private LoggerContext getLoggerContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }
}

