/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.statelang.validator.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.StateMachine;
import org.apache.seata.saga.statelang.parser.utils.StateMachineUtils;
import org.apache.seata.saga.statelang.validator.impl.AbstractRule;

public class FiniteTerminationRule
extends AbstractRule {
    @Override
    public boolean validate(StateMachine stateMachine) {
        String stateName = stateMachine.getStartState();
        State startState = stateMachine.getState(stateMachine.getStartState());
        String notFoundHintTemplate = "State [%s] is not defined in state machine";
        if (startState == null) {
            this.hint = String.format(notFoundHintTemplate, stateMachine.getStartState());
            return false;
        }
        DisjointSet disjointSet = new DisjointSet(stateMachine.getStates().keySet());
        HashSet<String> visited = new HashSet<String>();
        HashMap<String, Set<String>> nextStateNameMap = new HashMap<String, Set<String>>();
        FiniteTerminationRule.iterate(stateMachine, stateName, disjointSet, visited, nextStateNameMap, new Stack<String>());
        HashMap rootToStateNames = new HashMap();
        for (String disjointStateName : stateMachine.getStates().keySet()) {
            String root = disjointSet.find(disjointStateName);
            if (!rootToStateNames.containsKey(root)) {
                rootToStateNames.put(root, new HashSet());
            }
            ((Set)rootToStateNames.get(root)).add(disjointStateName);
        }
        for (Set cycleStateNames : rootToStateNames.values()) {
            if (cycleStateNames.size() <= 1) continue;
            boolean noOutgoingFlow = true;
            for (String cycleStateName : cycleStateNames) {
                if (cycleStateNames.containsAll((Collection)nextStateNameMap.get(cycleStateName))) continue;
                noOutgoingFlow = false;
                break;
            }
            if (!noOutgoingFlow) continue;
            this.hint = String.format("There is a infinite loop [%s] without outgoing flow to end", String.join((CharSequence)", ", cycleStateNames));
            return false;
        }
        return true;
    }

    private static void iterate(StateMachine stateMachine, String stateName, DisjointSet disjointSet, Set<String> visited, Map<String, Set<String>> nextStateNameMap, Stack<String> currentPathWithoutCycles) {
        State state = stateMachine.getState(stateName);
        if (visited.contains(stateName)) {
            if (currentPathWithoutCycles.size() > 1) {
                int curr = currentPathWithoutCycles.size() - 1;
                do {
                    disjointSet.union((String)currentPathWithoutCycles.get(curr), (String)currentPathWithoutCycles.get(--curr));
                } while (!((String)currentPathWithoutCycles.get(curr)).equals(stateName));
            }
        } else {
            Set<String> nextStateNames = StateMachineUtils.getAllPossibleSubsequentStates(state);
            nextStateNameMap.put(stateName, nextStateNames);
            visited.add(stateName);
            currentPathWithoutCycles.push(stateName);
            for (String nextStateName : nextStateNames) {
                FiniteTerminationRule.iterate(stateMachine, nextStateName, disjointSet, visited, nextStateNameMap, currentPathWithoutCycles);
            }
            currentPathWithoutCycles.pop();
            visited.remove(stateName);
        }
    }

    private static class DisjointSet {
        Map<String, String> parent = new HashMap<String, String>();
        Map<String, Integer> rank = new HashMap<String, Integer>();

        DisjointSet(Collection<String> stateNames) {
            for (String stateName : stateNames) {
                this.parent.put(stateName, stateName);
                this.rank.put(stateName, 0);
            }
        }

        String find(String state) {
            if (this.parent.get(state).equals(state)) {
                return state;
            }
            String root = this.find(this.parent.get(state));
            this.parent.put(state, root);
            return root;
        }

        void union(String i, String j) {
            String parentI = this.find(i);
            String parentJ = this.find(j);
            int rankI = this.rank.get(parentI);
            int rankJ = this.rank.get(parentJ);
            if (!parentI.equals(parentJ)) {
                if (rankI > rankJ) {
                    this.parent.put(parentJ, parentI);
                } else {
                    this.parent.put(parentI, parentJ);
                    if (rankI == rankJ) {
                        this.rank.put(parentI, rankI + 1);
                    }
                }
            }
        }
    }
}

