/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transaction;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javax.transaction.InvalidTransactionException;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.transaction.AlphaResponse;
import org.apache.servicecomb.saga.omega.transaction.CompensableInterceptor;
import org.apache.servicecomb.saga.omega.transaction.RecoveryPolicy;
import org.apache.servicecomb.saga.omega.transaction.annotations.Compensable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecovery
implements RecoveryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public Object apply(ProceedingJoinPoint joinPoint, Compensable compensable, CompensableInterceptor interceptor, OmegaContext context, String parentTxId, int retries) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        LOG.debug("Intercepting compensable method {} with context {}", (Object)method.toString(), (Object)context);
        String compensationSignature = compensable.compensationMethod().isEmpty() ? "" : this.compensationMethodSignature(joinPoint, compensable, method);
        String retrySignature = retries != 0 || compensationSignature.isEmpty() ? method.toString() : "";
        AlphaResponse response = interceptor.preIntercept(parentTxId, compensationSignature, compensable.timeout(), retrySignature, retries, joinPoint.getArgs());
        if (response.aborted()) {
            String abortedLocalTxId = context.localTxId();
            context.setLocalTxId(parentTxId);
            throw new InvalidTransactionException("Abort sub transaction " + abortedLocalTxId + " because global transaction " + context.globalTxId() + " has already aborted.");
        }
        try {
            Object result = joinPoint.proceed();
            interceptor.postIntercept(parentTxId, compensationSignature);
            return result;
        }
        catch (Throwable throwable) {
            interceptor.onError(parentTxId, compensationSignature, throwable);
            throw throwable;
        }
    }

    String compensationMethodSignature(ProceedingJoinPoint joinPoint, Compensable compensable, Method method) throws NoSuchMethodException {
        return joinPoint.getTarget().getClass().getDeclaredMethod(compensable.compensationMethod(), method.getParameterTypes()).toString();
    }
}

