/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transaction;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javax.transaction.InvalidTransactionException;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.transaction.CompensableInterceptor;
import org.apache.servicecomb.saga.omega.transaction.DefaultRecovery;
import org.apache.servicecomb.saga.omega.transaction.OmegaException;
import org.apache.servicecomb.saga.omega.transaction.annotations.Compensable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardRecovery
extends DefaultRecovery {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public Object apply(ProceedingJoinPoint joinPoint, Compensable compensable, CompensableInterceptor interceptor, OmegaContext context, String parentTxId, int retries) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        int remains = retries;
        try {
            while (true) {
                try {
                    return super.apply(joinPoint, compensable, interceptor, context, parentTxId, remains);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvalidTransactionException) {
                        throw throwable;
                    }
                    int n = remains = remains == -1 ? -1 : remains - 1;
                    if (remains == 0) {
                        LOG.error("Retried sub tx failed maximum times, global tx id: {}, local tx id: {}, method: {}, retried times: {}", new Object[]{context.globalTxId(), context.localTxId(), method.toString(), retries});
                        throw throwable;
                    }
                    LOG.warn("Retrying sub tx failed, global tx id: {}, local tx id: {}, method: {}, remains: {}", new Object[]{context.globalTxId(), context.localTxId(), method.toString(), remains});
                    Thread.sleep(compensable.retryDelayInMilliseconds());
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            String errorMessage = "Failed to handle tx because it is interrupted, global tx id: " + context.globalTxId() + ", local tx id: " + context.localTxId() + ", method: " + method.toString();
            LOG.error(errorMessage);
            interceptor.onError(parentTxId, this.compensationMethodSignature(joinPoint, compensable, method), e);
            throw new OmegaException(errorMessage);
        }
    }
}

