/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transaction;

import javax.transaction.TransactionalException;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.transaction.AlphaResponse;
import org.apache.servicecomb.saga.omega.transaction.EventAwareInterceptor;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.apache.servicecomb.saga.omega.transaction.OmegaException;
import org.apache.servicecomb.saga.omega.transaction.SagaEndedEvent;
import org.apache.servicecomb.saga.omega.transaction.SagaStartedEvent;
import org.apache.servicecomb.saga.omega.transaction.TxAbortedEvent;

class SagaStartAnnotationProcessor
implements EventAwareInterceptor {
    private final OmegaContext omegaContext;
    private final MessageSender sender;

    SagaStartAnnotationProcessor(OmegaContext omegaContext, MessageSender sender) {
        this.omegaContext = omegaContext;
        this.sender = sender;
    }

    @Override
    public AlphaResponse preIntercept(String parentTxId, String compensationMethod, int timeout, String retriesMethod, int retries, Object ... message) {
        try {
            return this.sender.send(new SagaStartedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId(), timeout));
        }
        catch (OmegaException e) {
            throw new TransactionalException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void postIntercept(String parentTxId, String compensationMethod) {
        AlphaResponse response = this.sender.send(new SagaEndedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId()));
        if (response.aborted()) {
            throw new OmegaException("transaction " + parentTxId + " is aborted");
        }
    }

    @Override
    public void onError(String parentTxId, String compensationMethod, Throwable throwable) {
        String globalTxId = this.omegaContext.globalTxId();
        this.sender.send(new TxAbortedEvent(globalTxId, globalTxId, null, compensationMethod, throwable));
    }
}

