/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.customized;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.interpreter.InterpretableConvention;
import org.apache.calcite.interpreter.InterpretableConverter;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.federate.FederationExecutor;
import org.apache.shardingsphere.infra.executor.sql.federate.customized.CustomizedFilterableExecuteDataContext;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.optimize.ShardingSphereOptimizer;
import org.apache.shardingsphere.infra.optimize.context.OptimizerContext;
import org.apache.shardingsphere.infra.optimize.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class CustomizedFilterableExecutor
implements FederationExecutor {
    private final String schemaName;
    private final ShardingSphereOptimizer optimizer;

    public CustomizedFilterableExecutor(String schemaName, OptimizerContext context) {
        this.schemaName = schemaName;
        this.optimizer = new ShardingSphereOptimizer(context);
    }

    @Override
    public List<QueryResult> executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, ExecutionContext executionContext) throws SQLException {
        return Collections.emptyList();
    }

    @Override
    public ResultSet getResultSet() {
        return null;
    }

    private Enumerable<Object[]> execute(SQLStatement sqlStatement) {
        return this.execute(this.optimizer.optimize(this.schemaName, sqlStatement));
    }

    private Enumerable<Object[]> execute(RelNode bestPlan) {
        RelOptCluster cluster = ((OptimizerPlannerContext)this.optimizer.getContext().getPlannerContexts().get(this.schemaName)).getConverter().getCluster();
        return new FederateInterpretableConverter(cluster, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), bestPlan).bind(new CustomizedFilterableExecuteDataContext(this.schemaName, this.optimizer.getContext()));
    }

    @Override
    public void close() {
    }

    public static final class FederateInterpretableConverter
    extends InterpretableConverter {
        public FederateInterpretableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
            super(cluster, traits, input);
        }
    }
}

