/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.original.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.federate.original.table.FilterableTableScanContext;
import org.apache.shardingsphere.infra.optimize.metadata.FederationTableMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;

public final class FilterableSQLGenerator {
    private final FederationTableMetaData tableMetaData;
    private final FilterableTableScanContext scanContext;
    private final QuoteCharacter quoteCharacter;

    public String generate(String actualTableName) {
        String projections = this.getQuotedProjections(this.tableMetaData, this.scanContext, this.quoteCharacter);
        String table = this.getQuotedTable(actualTableName, this.quoteCharacter);
        return String.format("SELECT %s FROM %s", projections, table);
    }

    private String getQuotedProjections(FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext, QuoteCharacter quoteCharacter) {
        List actualColumnNames = null == scanContext.getProjects() ? tableMetaData.getColumnNames() : (Collection)Arrays.stream(scanContext.getProjects()).mapToObj(tableMetaData.getColumnNames()::get).collect(Collectors.toList());
        return actualColumnNames.stream().map(arg_0 -> ((QuoteCharacter)quoteCharacter).wrap(arg_0)).collect(Collectors.joining(", "));
    }

    private String getQuotedTable(String actualTableName, QuoteCharacter quoteCharacter) {
        return quoteCharacter.wrap(actualTableName);
    }

    @Generated
    public FilterableSQLGenerator(FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext, QuoteCharacter quoteCharacter) {
        this.tableMetaData = tableMetaData;
        this.scanContext = scanContext;
        this.quoteCharacter = quoteCharacter;
    }
}

