/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.aop;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.shiro.aop.AnnotationMethodInterceptor;
import org.apache.shiro.aop.AnnotationResolver;
import org.apache.shiro.aop.DefaultAnnotationResolver;
import org.apache.shiro.authz.aop.AuthenticatedAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.GuestAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.PermissionAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.RoleAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.UserAnnotationMethodInterceptor;
import org.apache.shiro.guice.aop.AopAllianceMethodInterceptorAdapter;

public class ShiroAopModule
extends AbstractModule {
    protected final void configure() {
        AnnotationResolver resolver = this.createAnnotationResolver();
        this.configureDefaultInterceptors(resolver);
        this.configureInterceptors(resolver);
    }

    protected final void bindShiroInterceptor(final AnnotationMethodInterceptor methodInterceptor) {
        this.bindInterceptor(Matchers.any(), (Matcher)new AbstractMatcher<Method>(){

            public boolean matches(Method method) {
                Class<? extends Annotation> annotation = methodInterceptor.getHandler().getAnnotationClass();
                return method.getAnnotation(annotation) != null || method.getDeclaringClass().getAnnotation(annotation) != null;
            }
        }, new MethodInterceptor[]{new AopAllianceMethodInterceptorAdapter(methodInterceptor)});
    }

    protected AnnotationResolver createAnnotationResolver() {
        return new DefaultAnnotationResolver();
    }

    protected void configureDefaultInterceptors(AnnotationResolver resolver) {
        this.bindShiroInterceptor(new RoleAnnotationMethodInterceptor(resolver));
        this.bindShiroInterceptor(new PermissionAnnotationMethodInterceptor(resolver));
        this.bindShiroInterceptor(new AuthenticatedAnnotationMethodInterceptor(resolver));
        this.bindShiroInterceptor(new UserAnnotationMethodInterceptor(resolver));
        this.bindShiroInterceptor(new GuestAnnotationMethodInterceptor(resolver));
    }

    protected void configureInterceptors(AnnotationResolver resolver) {
    }
}

