/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.remoting;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.NativeSessionManager;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.support.DefaultRemoteInvocationFactory;
import org.springframework.remoting.support.RemoteInvocation;

public class SecureRemoteInvocationFactory
extends DefaultRemoteInvocationFactory {
    private static final Logger log = LoggerFactory.getLogger(SecureRemoteInvocationFactory.class);
    public static final String SESSION_ID_KEY = SecureRemoteInvocationFactory.class.getName() + ".SESSION_ID_KEY";
    public static final String HOST_KEY = SecureRemoteInvocationFactory.class.getName() + ".HOST_KEY";
    private static final String SESSION_ID_SYSTEM_PROPERTY_NAME = "shiro.session.id";
    private String sessionId;

    public SecureRemoteInvocationFactory() {
    }

    public SecureRemoteInvocationFactory(String sessionId) {
        this();
        this.sessionId = sessionId;
    }

    public RemoteInvocation createRemoteInvocation(MethodInvocation mi) {
        Object sessionId = null;
        String host = null;
        boolean sessionManagerMethodInvocation = false;
        Class<?> miDeclaringClass = mi.getMethod().getDeclaringClass();
        if (SessionManager.class.equals(miDeclaringClass) || NativeSessionManager.class.equals(miDeclaringClass)) {
            sessionManagerMethodInvocation = true;
            if (!mi.getMethod().getName().equals("start")) {
                SessionKey key = (SessionKey)mi.getArguments()[0];
                sessionId = key.getSessionId();
            }
        }
        if (sessionId == null) {
            sessionId = this.sessionId;
        }
        if (sessionId == null) {
            try {
                Subject subject;
                Session session;
                SecurityUtils.getSecurityManager();
                if (!sessionManagerMethodInvocation && (session = (subject = SecurityUtils.getSubject()).getSession(false)) != null) {
                    sessionId = session.getId();
                    host = session.getHost();
                }
            }
            catch (Exception e) {
                log.trace("No security manager set. Trying next to get session id from system property");
            }
        }
        if (sessionId == null) {
            if (log.isTraceEnabled()) {
                log.trace("No Session found for the currently executing subject via subject.getSession(false).  Attempting to revert back to the 'shiro.session.id' system property...");
            }
            if ((sessionId = System.getProperty(SESSION_ID_SYSTEM_PROPERTY_NAME)) == null && log.isTraceEnabled()) {
                log.trace("No 'shiro.session.id' system property found.  Heuristics have been exhausted; RemoteInvocation will not contain a sessionId.");
            }
        }
        RemoteInvocation ri = new RemoteInvocation(mi);
        if (sessionId != null) {
            ri.addAttribute(SESSION_ID_KEY, (Serializable)sessionId);
        }
        if (host != null) {
            ri.addAttribute(HOST_KEY, host);
        }
        return ri;
    }
}

