/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

public class ChunkedInputFilter
implements InputFilter {
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected int pos = 0;
    protected int lastValid = 0;
    protected byte[] buf = null;
    protected ByteChunk readChunk = new ByteChunk();
    protected boolean endChunk = false;
    protected ByteChunk trailingHeaders = new ByteChunk();
    protected boolean needCRLFParse = false;
    private Request request;
    private final long maxExtensionSize;
    private long extensionSize;

    public ChunkedInputFilter(int maxTrailerSize, int maxExtensionSize) {
        this.trailingHeaders.setLimit(maxTrailerSize);
        this.maxExtensionSize = maxExtensionSize;
    }

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.endChunk) {
            return -1;
        }
        if (this.needCRLFParse) {
            this.needCRLFParse = false;
            this.parseCRLF(false);
        }
        if (this.remaining <= 0) {
            if (!this.parseChunkHeader()) {
                throw new IOException("Invalid chunk header");
            }
            if (this.endChunk) {
                this.parseEndChunk();
                return -1;
            }
        }
        int result = 0;
        if (this.pos >= this.lastValid && this.readBytes() < 0) {
            throw new IOException("Unexpected end of stream whilst reading request body");
        }
        if (this.remaining > this.lastValid - this.pos) {
            result = this.lastValid - this.pos;
            this.remaining -= result;
            chunk.setBytes(this.buf, this.pos, result);
            this.pos = this.lastValid;
        } else {
            result = this.remaining;
            chunk.setBytes(this.buf, this.pos, this.remaining);
            this.pos += this.remaining;
            this.remaining = 0;
            if (this.pos + 1 >= this.lastValid) {
                this.needCRLFParse = true;
            } else {
                this.parseCRLF(false);
            }
        }
        return result;
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public long end() throws IOException {
        while (this.doRead(this.readChunk, null) >= 0) {
        }
        return this.lastValid - this.pos;
    }

    @Override
    public int available() {
        return this.lastValid - this.pos;
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void recycle() {
        this.remaining = 0;
        this.pos = 0;
        this.lastValid = 0;
        this.endChunk = false;
        this.needCRLFParse = false;
        this.trailingHeaders.recycle();
        this.extensionSize = 0L;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    protected int readBytes() throws IOException {
        int nRead = this.buffer.doRead(this.readChunk, null);
        this.pos = this.readChunk.getStart();
        this.lastValid = this.pos + nRead;
        this.buf = this.readChunk.getBytes();
        return nRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseChunkHeader() throws IOException {
        int result = 0;
        boolean eol = false;
        boolean readDigit = false;
        boolean extension = false;
        while (!eol) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                return false;
            }
            if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                this.parseCRLF(false);
                eol = true;
            } else if (this.buf[this.pos] == 59) {
                extension = true;
                ++this.extensionSize;
            } else if (!extension) {
                int charValue = HexUtils.getDec(this.buf[this.pos]);
                if (charValue == -1) return false;
                readDigit = true;
                result *= 16;
                result += charValue;
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    throw new IOException("maxExtensionSize exceeded");
                }
            }
            if (eol) continue;
            ++this.pos;
        }
        if (!readDigit) {
            return false;
        }
        if (result == 0) {
            this.endChunk = true;
        }
        this.remaining = result;
        return this.remaining >= 0;
    }

    @Deprecated
    protected boolean parseCRLF() throws IOException {
        this.parseCRLF(false);
        return true;
    }

    protected void parseCRLF(boolean tolerant) throws IOException {
        boolean eol = false;
        boolean crfound = false;
        while (!eol) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                throw new IOException("Invalid CRLF");
            }
            if (this.buf[this.pos] == 13) {
                if (crfound) {
                    throw new IOException("Invalid CRLF, two CR characters encountered.");
                }
                crfound = true;
            } else if (this.buf[this.pos] == 10) {
                if (!tolerant && !crfound) {
                    throw new IOException("Invalid CRLF, no CR character encountered.");
                }
                eol = true;
            } else {
                throw new IOException("Invalid CRLF");
            }
            ++this.pos;
        }
    }

    protected void parseEndChunk() throws IOException {
        while (this.parseHeader()) {
        }
    }

    private boolean parseHeader() throws IOException {
        MimeHeaders headers = this.request.getMimeHeaders();
        byte chr = 0;
        if (this.pos >= this.lastValid && this.readBytes() < 0) {
            throw new EOFException("Unexpected end of stream whilst reading trailer headers for chunked request");
        }
        chr = this.buf[this.pos];
        if (chr == 13 || chr == 10) {
            this.parseCRLF(false);
            return false;
        }
        int start = this.trailingHeaders.getEnd();
        boolean colon = false;
        while (!colon) {
            if (this.pos >= this.lastValid && this.readBytes() < 0) {
                throw new EOFException("Unexpected end of stream whilst reading trailer headers for chunked request");
            }
            chr = this.buf[this.pos];
            if (chr >= 65 && chr <= 90) {
                chr = (byte)(chr - -32);
            }
            if (chr == 58) {
                colon = true;
            } else {
                this.trailingHeaders.append(chr);
            }
            ++this.pos;
        }
        MessageBytes headerValue = headers.addValue(this.trailingHeaders.getBytes(), start, this.trailingHeaders.getEnd() - start);
        start = this.trailingHeaders.getEnd();
        boolean eol = false;
        boolean validLine = true;
        int lastSignificantChar = 0;
        while (validLine) {
            boolean space = true;
            while (space) {
                if (this.pos >= this.lastValid && this.readBytes() < 0) {
                    throw new EOFException("Unexpected end of stream whilst reading trailer headers for chunked request");
                }
                chr = this.buf[this.pos];
                if (chr == 32 || chr == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            while (!eol) {
                if (this.pos >= this.lastValid && this.readBytes() < 0) {
                    throw new EOFException("Unexpected end of stream whilst reading trailer headers for chunked request");
                }
                chr = this.buf[this.pos];
                if (chr == 13 || chr == 10) {
                    this.parseCRLF(true);
                    eol = true;
                } else if (chr == 32) {
                    this.trailingHeaders.append(chr);
                } else {
                    this.trailingHeaders.append(chr);
                    lastSignificantChar = this.trailingHeaders.getEnd();
                }
                if (eol) continue;
                ++this.pos;
            }
            if (this.pos >= this.lastValid && this.readBytes() < 0) {
                throw new EOFException("Unexpected end of stream whilst reading trailer headers for chunked request");
            }
            chr = this.buf[this.pos];
            if (chr != 32 && chr != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            this.trailingHeaders.append(chr);
        }
        headerValue.setBytes(this.trailingHeaders.getBytes(), start, lastSignificantChar - start);
        return true;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(Charset.defaultCharset()), 0, ENCODING_NAME.length());
    }
}

