/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFMtxEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyfTable {
    private final TTFMtxEntry[] mtxTab;
    private final long tableOffset;
    private final Set<Long> remappedComposites;
    private final Map<Integer, Integer> subset;
    private final FontFileReader in;
    private Set<Integer> compositeGlyphs = new TreeSet<Integer>();
    private Set<Integer> composedGlyphs = new TreeSet<Integer>();

    GlyfTable(FontFileReader in, TTFMtxEntry[] metrics, TTFDirTabEntry dirTableEntry, Map<Integer, Integer> glyphs) throws IOException {
        this.mtxTab = metrics;
        this.tableOffset = dirTableEntry.getOffset();
        this.remappedComposites = new HashSet<Long>();
        this.subset = glyphs;
        this.in = in;
    }

    void populateGlyphsWithComposites() throws IOException {
        for (int indexInOriginal : this.subset.keySet()) {
            this.scanGlyphsRecursively(indexInOriginal);
        }
        this.addAllComposedGlyphsToSubset();
        for (int compositeGlyph : this.compositeGlyphs) {
            long offset = this.tableOffset + this.mtxTab[compositeGlyph].getOffset() + 10L;
            if (this.remappedComposites.contains(offset)) continue;
            this.remapComposite(offset);
        }
    }

    private void scanGlyphsRecursively(int indexInOriginal) throws IOException {
        if (!this.subset.containsKey(indexInOriginal)) {
            this.composedGlyphs.add(indexInOriginal);
        }
        if (this.isComposite(indexInOriginal)) {
            this.compositeGlyphs.add(indexInOriginal);
            Set<Integer> composedGlyphs = this.retrieveComposedGlyphs(indexInOriginal);
            for (Integer composedGlyph : composedGlyphs) {
                this.scanGlyphsRecursively(composedGlyph);
            }
        }
    }

    private void addAllComposedGlyphsToSubset() {
        int newIndex = this.subset.size();
        for (int composedGlyph : this.composedGlyphs) {
            this.subset.put(composedGlyph, newIndex++);
        }
    }

    private void remapComposite(long glyphOffset) throws IOException {
        long currentGlyphOffset = glyphOffset;
        this.remappedComposites.add(currentGlyphOffset);
        int flags = 0;
        do {
            flags = this.in.readTTFUShort(currentGlyphOffset);
            int glyphIndex = this.in.readTTFUShort(currentGlyphOffset + 2L);
            Integer indexInSubset = this.subset.get(glyphIndex);
            assert (indexInSubset != null);
            this.in.writeTTFUShort(currentGlyphOffset + 2L, indexInSubset);
            currentGlyphOffset += (long)(4 + GlyfFlags.getOffsetToNextComposedGlyf(flags));
        } while (GlyfFlags.hasMoreComposites(flags));
    }

    private boolean isComposite(int indexInOriginal) throws IOException {
        short numberOfContours = this.in.readTTFShort(this.tableOffset + this.mtxTab[indexInOriginal].getOffset());
        return numberOfContours < 0;
    }

    private Set<Integer> retrieveComposedGlyphs(int indexInOriginal) throws IOException {
        HashSet<Integer> composedGlyphs = new HashSet<Integer>();
        long offset = this.tableOffset + this.mtxTab[indexInOriginal].getOffset() + 10L;
        int flags = 0;
        do {
            flags = this.in.readTTFUShort(offset);
            composedGlyphs.add(this.in.readTTFUShort(offset + 2L));
            offset += (long)(4 + GlyfFlags.getOffsetToNextComposedGlyf(flags));
        } while (GlyfFlags.hasMoreComposites(flags));
        return composedGlyphs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GlyfFlags {
        ARG_1_AND_2_ARE_WORDS(4, 2),
        ARGS_ARE_XY_VALUES,
        ROUND_XY_TO_GRID,
        WE_HAVE_A_SCALE(2),
        RESERVED,
        MORE_COMPONENTS,
        WE_HAVE_AN_X_AND_Y_SCALE(4),
        WE_HAVE_A_TWO_BY_TWO(8),
        WE_HAVE_INSTRUCTIONS,
        USE_MY_METRICS,
        OVERLAP_COMPOUND,
        SCALED_COMPONENT_OFFSET,
        UNSCALED_COMPONENT_OFFSET;

        private final int bitMask = 1 << this.ordinal();
        private final int argsCountIfSet;
        private final int argsCountIfNotSet;

        private GlyfFlags(int argsCountIfSet, int argsCountIfNotSet) {
            this.argsCountIfSet = argsCountIfSet;
            this.argsCountIfNotSet = argsCountIfNotSet;
        }

        private GlyfFlags(int argsCountIfSet) {
            this(argsCountIfSet, 0);
        }

        private GlyfFlags() {
            this(0, 0);
        }

        static int getOffsetToNextComposedGlyf(int flags) {
            int offset = 0;
            for (GlyfFlags flag : GlyfFlags.values()) {
                offset += (flags & flag.bitMask) > 0 ? flag.argsCountIfSet : flag.argsCountIfNotSet;
            }
            return offset;
        }

        static boolean hasMoreComposites(int flags) {
            return (flags & GlyfFlags.MORE_COMPONENTS.bitMask) > 0;
        }
    }
}

