/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.resource.loader.URLPlexusResource;

public class URLResourceLoader
extends AbstractResourceLoader {
    public static final String ID = "url";
    protected Map templateRoots = new HashMap();

    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        IOException exception;
        block10: {
            if (name == null || name.length() == 0) {
                throw new ResourceNotFoundException("URLResourceLoader : No template name provided");
            }
            exception = null;
            for (String path : this.paths) {
                try {
                    URL u = new URL(path + name);
                    final InputStream inputStream = u.openStream();
                    if (inputStream == null) continue;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("URLResourceLoader: Found '" + name + "' at '" + path + "'");
                    }
                    this.templateRoots.put(name, path);
                    return new URLPlexusResource(u){
                        private boolean useSuper;

                        public synchronized InputStream getInputStream() throws IOException {
                            if (!this.useSuper) {
                                this.useSuper = true;
                                return inputStream;
                            }
                            return super.getInputStream();
                        }
                    };
                }
                catch (IOException ioe) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("URLResourceLoader: Exception when looking for '" + name + "' at '" + path + "'", (Throwable)ioe);
                    }
                    if (exception != null) continue;
                    exception = ioe;
                }
            }
            try {
                URL u = new URL(name);
                final InputStream inputStream = u.openStream();
                if (inputStream != null) {
                    return new URLPlexusResource(u){
                        private boolean useSuper;

                        public synchronized InputStream getInputStream() throws IOException {
                            if (!this.useSuper) {
                                this.useSuper = true;
                                return inputStream;
                            }
                            return super.getInputStream();
                        }
                    };
                }
            }
            catch (IOException ioe) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("URLResourceLoader: Exception when looking for '" + name, (Throwable)ioe);
                }
                if (exception != null) break block10;
                exception = ioe;
            }
        }
        String msg = exception == null ? "URLResourceLoader : Resource '" + name + "' not found." : exception.getMessage();
        throw new ResourceNotFoundException(msg);
    }
}

