/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import cn.hutool.core.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SmsDateUtils
extends DateUtil {
    private static final String GMT = "GMT";
    private static final String GMT_8 = "GMT+8:00";
    private static final String PURE_DATE_UTC_PATTERN = "yyyyMMdd'T'HHmmss'Z'";

    private SmsDateUtils() {
    }

    public static TimeZone gmt() {
        return SmsDateUtils.getTimeZone(GMT);
    }

    public static TimeZone gmt8() {
        return SmsDateUtils.getTimeZone(GMT_8);
    }

    public static TimeZone getTimeZone(String zoneId) {
        return TimeZone.getTimeZone(zoneId);
    }

    public static SimpleDateFormat sdfGmt(String pattern) {
        return SmsDateUtils.sdf(pattern, SmsDateUtils.gmt());
    }

    public static SimpleDateFormat sdfGmt8(String pattern) {
        return SmsDateUtils.sdf(pattern, SmsDateUtils.gmt8());
    }

    public static SimpleDateFormat sdf(String pattern, TimeZone timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(timeZone);
        return sdf;
    }

    public static String formatGmtDateToStr(Date date, String pattern) {
        SimpleDateFormat sdf = SmsDateUtils.sdfGmt(pattern);
        return sdf.format(date);
    }

    public static String formatGmt8DateToStr(Date date, String pattern) {
        SimpleDateFormat sdf = SmsDateUtils.sdfGmt8(pattern);
        return sdf.format(date);
    }

    public static String formatDateToStr(Date date, String pattern, TimeZone timeZone) {
        SimpleDateFormat sdf = SmsDateUtils.sdf(pattern, timeZone);
        return sdf.format(date);
    }

    public static String utcGmt(Date date) {
        return SmsDateUtils.formatGmtDateToStr(date, "yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public static String utcGmt8(Date date) {
        return SmsDateUtils.formatGmt8DateToStr(date, "yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public static String pureDateGmt(Date date) {
        return SmsDateUtils.formatGmtDateToStr(date, "yyyyMMdd");
    }

    public static String pureDateGmt8(Date date) {
        return SmsDateUtils.formatGmt8DateToStr(date, "yyyyMMdd");
    }

    public static String pureDateUtcGmt(Date date) {
        return SmsDateUtils.formatGmtDateToStr(date, PURE_DATE_UTC_PATTERN);
    }

    public static String pureDateUtcGmt8(Date date) {
        return SmsDateUtils.formatGmt8DateToStr(date, PURE_DATE_UTC_PATTERN);
    }

    public static String normDateGmt(Date date) {
        return SmsDateUtils.formatGmtDateToStr(date, "yyyy-MM-dd");
    }

    public static String normDateGmt8(Date date) {
        return SmsDateUtils.formatGmt8DateToStr(date, "yyyy-MM-dd");
    }

    public static String normDatetimeGmt(Date date) {
        return SmsDateUtils.formatGmtDateToStr(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String normDatetimeGmt8(Date date) {
        return SmsDateUtils.formatGmt8DateToStr(date, "yyyy-MM-dd HH:mm:ss");
    }
}

