/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.ExceptionUtil;

public class PlanItemExpressionActivityBehavior
extends CoreCmmnActivityBehavior {
    protected String expression;
    protected String resultVariable;
    protected boolean storeResultVariableAsTransient;

    public PlanItemExpressionActivityBehavior(String expression, String resultVariable, boolean storeResultVariableAsTransient) {
        this.expression = expression;
        this.resultVariable = resultVariable;
        this.storeResultVariableAsTransient = storeResultVariableAsTransient;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Object value = null;
        Expression expressionObject = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.expression);
        value = expressionObject.getValue((VariableContainer)planItemInstanceEntity);
        if (value instanceof CompletableFuture) {
            CommandContextUtil.getAgenda(commandContext).planFutureOperation((CompletableFuture)value, new FutureExpressionCompleteAction(planItemInstanceEntity));
        } else {
            this.complete(value, planItemInstanceEntity);
        }
    }

    protected void complete(Object value, PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.resultVariable != null) {
            if (this.storeResultVariableAsTransient) {
                planItemInstanceEntity.setTransientVariable(this.resultVariable, value);
            } else {
                planItemInstanceEntity.setVariable(this.resultVariable, value);
            }
        }
        CommandContextUtil.getAgenda().planCompletePlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected class FutureExpressionCompleteAction
    implements BiConsumer<Object, Throwable> {
        protected final PlanItemInstanceEntity planItemInstanceEntity;

        public FutureExpressionCompleteAction(PlanItemInstanceEntity planItemInstanceEntity) {
            this.planItemInstanceEntity = planItemInstanceEntity;
        }

        @Override
        public void accept(Object value, Throwable throwable) {
            if (throwable == null) {
                PlanItemExpressionActivityBehavior.this.complete(value, this.planItemInstanceEntity);
            } else {
                ExceptionUtil.sneakyThrow((Throwable)throwable);
            }
        }
    }
}

