/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl.http.handler;

import java.util.List;
import org.flowable.cmmn.engine.impl.cfg.DelegateExpressionFieldInjectionMode;
import org.flowable.cmmn.engine.impl.delegate.CmmnClassDelegate;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.api.delegate.HttpRequestHandler;
import org.flowable.http.common.api.delegate.HttpResponseHandler;

public class DelegateExpressionHttpHandler
implements HttpRequestHandler,
HttpResponseHandler {
    private static final long serialVersionUID = 1L;
    protected Expression expression;
    protected final List<FieldExtension> fieldExtensions;

    public DelegateExpressionHttpHandler(Expression expression, List<FieldExtension> fieldDeclarations) {
        this.expression = expression;
        this.fieldExtensions = fieldDeclarations;
    }

    public void handleHttpRequest(VariableContainer execution, HttpRequest httpRequest, FlowableHttpClient client) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldExtensions);
        if (!(delegate instanceof HttpRequestHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + HttpRequestHandler.class);
        }
        ((HttpRequestHandler)delegate).handleHttpRequest(execution, httpRequest, client);
    }

    public void handleHttpResponse(VariableContainer execution, HttpResponse httpResponse) {
        Object delegate = DelegateExpressionHttpHandler.resolveDelegateExpression(this.expression, execution, this.fieldExtensions);
        if (!(delegate instanceof HttpResponseHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + HttpResponseHandler.class);
        }
        ((HttpResponseHandler)delegate).handleHttpResponse(execution, httpResponse);
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public static Object resolveDelegateExpression(Expression expression, VariableContainer variableScope, List<FieldExtension> fieldExtensions) {
        Object delegate = expression.getValue(variableScope);
        if (fieldExtensions != null && fieldExtensions.size() > 0) {
            DelegateExpressionFieldInjectionMode injectionMode = CommandContextUtil.getCmmnEngineConfiguration().getDelegateExpressionFieldInjectionMode();
            if (injectionMode == DelegateExpressionFieldInjectionMode.COMPATIBILITY) {
                CmmnClassDelegate.applyFieldExtensions(fieldExtensions, delegate, true);
            } else if (injectionMode == DelegateExpressionFieldInjectionMode.MIXED) {
                CmmnClassDelegate.applyFieldExtensions(fieldExtensions, delegate, false);
            }
        }
        return delegate;
    }
}

