/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import java.util.List;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class ExternalWorkerTaskCompleteJobHandler
implements JobHandler {
    public static final String TYPE = "cmmn-external-worker-complete";
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public ExternalWorkerTaskCompleteJobHandler(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)variableScope;
        VariableService variableService = this.cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService();
        List jobVariables = variableService.findVariableInstanceBySubScopeIdAndScopeType(planItemInstanceEntity.getId(), "cmmnExternalWorker");
        if (!jobVariables.isEmpty()) {
            for (VariableInstanceEntity jobVariable : jobVariables) {
                planItemInstanceEntity.setVariable(jobVariable.getName(), jobVariable.getValue());
                variableService.deleteVariableInstance(jobVariable);
            }
            if (planItemInstanceEntity instanceof CountingPlanItemInstanceEntity) {
                ((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).setVariableCount(((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).getVariableCount() - jobVariables.size());
            }
        }
        if (configuration != null && configuration.startsWith("terminate:")) {
            CommandContextUtil.getAgenda(commandContext).planTerminatePlanItemInstanceOperation(planItemInstanceEntity, null, null);
        } else {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }
}

