/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.persistence.entity.AbstractVariableServiceEntity;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricVariableInstanceEntityImpl
extends AbstractVariableServiceEntity
implements HistoricVariableInstanceEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected VariableType variableType;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected Date createTime;
    protected Date lastUpdatedTime;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayRef byteArrayRef;
    protected String metaInfo;
    protected Object cachedValue;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("name", this.name);
        persistentState.put("scopeId", this.scopeId);
        persistentState.put("subScopeId", this.subScopeId);
        persistentState.put("scopeType", this.scopeType);
        persistentState.put("textValue", this.textValue);
        persistentState.put("textValue2", this.textValue2);
        persistentState.put("doubleValue", this.doubleValue);
        persistentState.put("longValue", this.longValue);
        if (this.variableType != null) {
            persistentState.put("typeName", this.variableType.getTypeName());
        }
        if (this.byteArrayRef != null) {
            persistentState.put("byteArrayRef", this.byteArrayRef.getId());
        }
        persistentState.put("metaInfo", this.metaInfo);
        persistentState.put("createTime", this.createTime);
        persistentState.put("lastUpdatedTime", this.lastUpdatedTime);
        return persistentState;
    }

    public Object getValue() {
        if (!this.variableType.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.variableType.getValue((ValueFields)this);
        }
        return this.cachedValue;
    }

    public byte[] getBytes() {
        if (this.byteArrayRef != null) {
            return this.byteArrayRef.getBytes(this.getEngineType());
        }
        return null;
    }

    public void setBytes(byte[] bytes) {
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
        this.byteArrayRef.setValue("hist.var-" + this.name, bytes, this.getEngineType());
    }

    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    public String getVariableName() {
        return this.name;
    }

    @Override
    public VariableType getVariableType() {
        return this.variableType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue2() {
        return this.textValue2;
    }

    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    @Override
    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Override
    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getTime() {
        return this.createTime;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    @Override
    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    @Override
    public void setSubScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public String getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public void setMetaInfo(String metaInfo) {
        this.metaInfo = metaInfo;
    }

    @Override
    public ByteArrayRef getByteArrayRef() {
        return this.byteArrayRef;
    }

    protected String getEngineType() {
        if (StringUtils.isNotEmpty((CharSequence)this.scopeType)) {
            return this.scopeType;
        }
        return "bpmn";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoricVariableInstanceEntity[");
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", revision=").append(this.revision);
        sb.append(", type=").append(this.variableType != null ? this.variableType.getTypeName() : "null");
        if (this.longValue != null) {
            sb.append(", longValue=").append(this.longValue);
        }
        if (this.doubleValue != null) {
            sb.append(", doubleValue=").append(this.doubleValue);
        }
        if (this.textValue != null) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.textValue, (int)40));
        }
        if (this.textValue2 != null) {
            sb.append(", textValue2=").append(StringUtils.abbreviate((String)this.textValue2, (int)40));
        }
        if (this.byteArrayRef != null && this.byteArrayRef.getId() != null) {
            sb.append(", byteArrayValueId=").append(this.byteArrayRef.getId());
        }
        sb.append("]");
        return sb.toString();
    }
}

