/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.mysql.MySQLConnection;
import org.flywaydb.core.internal.database.mysql.MySQLSqlScript;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.scanner.Resource;

public class MySQLDatabase
extends Database {
    public MySQLDatabase(FlywayConfiguration configuration, java.sql.Connection connection) {
        super(configuration, connection, 12);
    }

    protected Connection getConnection(java.sql.Connection connection, int nullType) {
        return new MySQLConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected final void ensureSupported() {
        String productName;
        boolean isMariaDB;
        String version = this.majorVersion + "." + this.minorVersion;
        try {
            isMariaDB = this.jdbcMetaData.getDatabaseProductVersion().contains("MariaDB");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine database product version", e);
        }
        String string = productName = isMariaDB ? "MariaDB" : "MySQL";
        if (this.majorVersion < 5) {
            throw new FlywayDbUpgradeRequiredException(productName, version, "5.0");
        }
        if (this.majorVersion == 5) {
            if (this.minorVersion < 5) {
                throw new FlywayEnterpriseUpgradeRequiredException(isMariaDB ? "MariaDB" : "Oracle", productName, version);
            }
            if (this.minorVersion > 7) {
                this.recommendFlywayUpgrade(productName, version);
            }
        } else if (isMariaDB) {
            if (this.majorVersion > 10 || this.majorVersion == 10 && this.minorVersion > 2) {
                this.recommendFlywayUpgrade(productName, version);
            }
        } else {
            this.recommendFlywayUpgrade(productName, version);
        }
    }

    @Override
    protected SqlScript doCreateSqlScript(Resource sqlScriptResource, String sqlScriptSource, boolean mixed) {
        return new MySQLSqlScript(sqlScriptResource, sqlScriptSource, mixed);
    }

    @Override
    public String getDbName() {
        return "mysql";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.mainConnection.getJdbcTemplate().queryForString("SELECT SUBSTRING_INDEX(USER(),'@',1)", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

