/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLimits;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.ProcessHandler;

final class PolyglotContextConfig {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    final OutputStream out;
    final OutputStream err;
    final InputStream in;
    final boolean hostLookupAllowed;
    final boolean nativeAccessAllowed;
    final boolean createThreadAllowed;
    final boolean hostClassLoadingAllowed;
    final boolean createProcessAllowed;
    final Predicate<String> classFilter;
    private final Map<String, String[]> applicationArguments;
    final Set<String> allowedPublicLanguages;
    private final Map<String, OptionValuesImpl> optionsById;
    @CompilerDirectives.CompilationFinal
    FileSystem fileSystem;
    @CompilerDirectives.CompilationFinal
    FileSystem internalFileSystem;
    final Map<String, Level> logLevels;
    final Handler logHandler;
    final PolyglotAccess polyglotAccess;
    final ProcessHandler processHandler;
    private final EnvironmentAccess environmentAccess;
    private final Map<String, String> environment;
    private volatile Map<String, String> configuredEnvironement;
    private volatile ZoneId timeZone;
    final PolyglotLimits limits;
    final ClassLoader hostClassLoader;
    private final List<PolyglotInstrument> configuredInstruments;
    private final Set<PolyglotLanguage> configuredLanguages;
    final HostAccess hostAccess;
    final boolean allowValueSharing;
    final boolean useSystemExit;

    PolyglotContextConfig(PolyglotEngineImpl engine, OutputStream out, OutputStream err, InputStream in, boolean hostLookupAllowed, PolyglotAccess polyglotAccess, boolean nativeAccessAllowed, boolean createThreadAllowed, boolean hostClassLoadingAllowed, boolean allowExperimentalOptions, Predicate<String> classFilter, Map<String, String[]> applicationArguments, Set<String> onlyLanguages, Map<String, String> options, FileSystem publicFileSystem, FileSystem internalFileSystem, Handler logHandler, boolean createProcessAllowed, ProcessHandler processHandler, EnvironmentAccess environmentAccess, Map<String, String> environment, ZoneId timeZone, PolyglotLimits limits, ClassLoader hostClassLoader, HostAccess hostAccess, boolean allowValueSharing, boolean useSystemExit) {
        assert (out != null);
        assert (err != null);
        assert (in != null);
        assert (environmentAccess != null);
        this.out = out;
        this.err = err;
        this.in = in;
        this.hostLookupAllowed = hostLookupAllowed;
        this.polyglotAccess = polyglotAccess;
        this.nativeAccessAllowed = nativeAccessAllowed;
        this.createThreadAllowed = createThreadAllowed;
        this.hostClassLoadingAllowed = hostClassLoadingAllowed;
        this.createProcessAllowed = createProcessAllowed;
        this.classFilter = classFilter;
        this.applicationArguments = applicationArguments;
        this.allowedPublicLanguages = onlyLanguages.isEmpty() ? engine.getLanguages().keySet() : onlyLanguages;
        this.fileSystem = publicFileSystem;
        this.internalFileSystem = internalFileSystem;
        this.optionsById = new HashMap<String, OptionValuesImpl>();
        this.logHandler = logHandler;
        this.timeZone = timeZone;
        this.limits = limits;
        this.logLevels = new HashMap<String, Level>(engine.logLevels);
        this.allowValueSharing = allowValueSharing;
        ArrayList<PolyglotInstrument> instruments = null;
        LinkedHashSet<PolyglotLanguage> languages = new LinkedHashSet<PolyglotLanguage>();
        for (String id : onlyLanguages) {
            this.addConfiguredLanguage(engine, languages, engine.idToLanguage.get(id));
        }
        for (String optionKey : options.keySet()) {
            OptionValuesImpl engineOptionValues;
            String id;
            String group = PolyglotEngineImpl.parseOptionGroup(optionKey);
            if (group.equals("log")) {
                this.logLevels.put(PolyglotEngineImpl.parseLoggerName(optionKey), Level.parse(options.get(optionKey)));
                continue;
            }
            PolyglotImpl.VMObject object = PolyglotContextConfig.findObjectForContextOption(engine, optionKey, group);
            if (object instanceof PolyglotLanguage) {
                PolyglotLanguage language = (PolyglotLanguage)object;
                id = language.getId();
                engineOptionValues = language.getOptionValues();
                this.addConfiguredLanguage(engine, languages, language);
            } else if (object instanceof PolyglotInstrument) {
                PolyglotInstrument instrument = (PolyglotInstrument)object;
                id = instrument.getId();
                engineOptionValues = instrument.getEngineOptionValues();
                if (instruments == null) {
                    instruments = new ArrayList<PolyglotInstrument>();
                }
                instruments.add(instrument);
            } else {
                throw new AssertionError((Object)"invalid vm object");
            }
            OptionValuesImpl targetOptions = this.optionsById.get(id);
            if (targetOptions == null) {
                targetOptions = engineOptionValues.copy();
                this.optionsById.put(id, targetOptions);
            }
            targetOptions.put(engine, optionKey, options.get(optionKey), allowExperimentalOptions);
        }
        this.configuredInstruments = instruments == null ? Collections.emptyList() : instruments;
        this.configuredLanguages = languages == null ? Collections.emptySet() : languages;
        this.processHandler = processHandler;
        this.environmentAccess = environmentAccess;
        this.environment = environment == null ? Collections.emptyMap() : environment;
        this.hostAccess = hostAccess;
        this.hostClassLoader = hostClassLoader;
        this.useSystemExit = useSystemExit;
    }

    void addConfiguredLanguage(PolyglotEngineImpl engine, Set<PolyglotLanguage> languages, PolyglotLanguage language) {
        if (language != null && languages.add(language)) {
            this.collectDependentLanguages(engine, language.cache.getDependentLanguages(), languages);
        }
    }

    private void collectDependentLanguages(PolyglotEngineImpl engine, Collection<String> languageIds, Collection<PolyglotLanguage> foundLanguages) {
        for (String id : languageIds) {
            PolyglotLanguage language = engine.idToLanguage.get(id);
            if (language == null || !foundLanguages.add(language)) continue;
            this.collectDependentLanguages(engine, language.cache.getDependentLanguages(), foundLanguages);
        }
    }

    public ZoneId getTimeZone() {
        ZoneId zone = this.timeZone;
        if (zone == null) {
            zone = this.timeZone = ZoneId.systemDefault();
        }
        return zone;
    }

    boolean isAccessPermitted(PolyglotLanguage from, PolyglotLanguage to) {
        if (to.isHost() || to.cache.isInternal()) {
            return true;
        }
        if (from == to) {
            return true;
        }
        if (from == null) {
            if (this.allowedPublicLanguages.contains(to.info.getId())) {
                return true;
            }
        } else {
            if (this.polyglotAccess == PolyglotAccess.ALL) {
                if (this.allowedPublicLanguages.contains(to.info.getId())) {
                    return true;
                }
            } else {
                if (from == to) {
                    return true;
                }
                UnmodifiableEconomicSet configuredAccess = from.engine.getAPIAccess().getEvalAccess(this.polyglotAccess, from.getId());
                if (configuredAccess != null && configuredAccess.contains((Object)to.getId())) {
                    return true;
                }
            }
            if (from.dependsOn(to)) {
                return true;
            }
        }
        return false;
    }

    String[] getApplicationArguments(PolyglotLanguage lang) {
        String[] args = this.applicationArguments.get(lang.getId());
        if (args == null) {
            args = EMPTY_STRING_ARRAY;
        }
        return args;
    }

    OptionValuesImpl getLanguageOptionValues(PolyglotLanguage lang) {
        OptionValuesImpl values = this.optionsById.get(lang.getId());
        if (values == null) {
            values = lang.getOptionValues();
        }
        return values;
    }

    OptionValuesImpl getInstrumentOptionValues(PolyglotInstrument instrument) {
        OptionValuesImpl values = this.optionsById.get(instrument.getId());
        if (values == null) {
            values = instrument.getEngineOptionValues();
        }
        return values.copy();
    }

    Set<PolyglotLanguage> getConfiguredLanguages() {
        return this.configuredLanguages;
    }

    Collection<? extends PolyglotInstrument> getConfiguredInstruments() {
        return this.configuredInstruments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getEnvironment() {
        Map<String, String> result = this.configuredEnvironement;
        if (result == null) {
            PolyglotContextConfig polyglotContextConfig = this;
            synchronized (polyglotContextConfig) {
                result = this.configuredEnvironement;
                if (result == null) {
                    if (this.environmentAccess == EnvironmentAccess.NONE) {
                        result = Collections.unmodifiableMap(this.environment);
                    } else if (PolyglotEngineImpl.ALLOW_ENVIRONMENT_ACCESS && this.environmentAccess == EnvironmentAccess.INHERIT) {
                        result = System.getenv();
                        if (!this.environment.isEmpty()) {
                            result = new HashMap<String, String>(result);
                            result.putAll(this.environment);
                            result = Collections.unmodifiableMap(result);
                        }
                    } else {
                        throw PolyglotEngineException.unsupported(String.format("Unsupported EnvironmentAccess: %s", this.environmentAccess));
                    }
                    this.configuredEnvironement = result;
                }
            }
        }
        return result;
    }

    private static PolyglotImpl.VMObject findObjectForContextOption(PolyglotEngineImpl engine, String optionKey, String group) {
        PolyglotLanguage language = engine.idToLanguage.get(group);
        if (language == null) {
            PolyglotInstrument instrument = engine.idToInstrument.get(group);
            if (instrument != null) {
                if (instrument.getEngineOptionsInternal().get(optionKey) != null) {
                    throw PolyglotEngineException.illegalArgument("Option " + optionKey + " is an engine level instrument option. Engine level instrument options can only be configured for contexts without an explicit engine set. To resolve this, configure the option when creating the Engine or create a context without a shared engine.");
                }
                return instrument;
            }
            if (group.equals("engine") && engine.getAllOptions().get(optionKey) != null) {
                throw PolyglotEngineException.illegalArgument("Option " + optionKey + " is an engine option. Engine level options can only be configured for contexts without a shared engine set. To resolve this, configure the option when creating the Engine or create a context without a shared engine.");
            }
            throw OptionValuesImpl.failNotFound(engine.getAllOptions(), optionKey);
        }
        assert (!group.equals("engine"));
        return language;
    }
}

