/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen.qrcode;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.iherus.codegen.qrcode.QreyesFormat;
import org.iherus.codegen.qrcode.QreyesPosition;
import org.iherus.codegen.qrcode.QreyesRenderer;
import org.iherus.codegen.qrcode.renderer.CBCPQreyesRenderer;
import org.iherus.codegen.qrcode.renderer.CBRPQreyesRenderer;
import org.iherus.codegen.qrcode.renderer.DR2BCPQreyesRenderer;
import org.iherus.codegen.qrcode.renderer.DR2BRPQreyesRenderer;
import org.iherus.codegen.qrcode.renderer.R2BCPQreyesRenderer;
import org.iherus.codegen.qrcode.renderer.R2BRPQreyesRenderer;
import org.iherus.codegen.qrcode.renderer.RBCPQreyesRenderer;
import org.iherus.codegen.qrcode.renderer.RBRPQreyesRenderer;

public final class MultiFormatQreyesRenderer
implements QreyesRenderer {
    @Override
    public void render(BufferedImage image, QreyesFormat format, QreyesPosition position, Color slave, Color border, Color point) {
        QreyesRenderer renderer;
        switch (format) {
            case R_BORDER_R_POINT: {
                renderer = new RBRPQreyesRenderer();
                break;
            }
            case R_BORDER_C_POINT: {
                renderer = new RBCPQreyesRenderer();
                break;
            }
            case C_BORDER_R_POINT: {
                renderer = new CBRPQreyesRenderer();
                break;
            }
            case C_BORDER_C_POINT: {
                renderer = new CBCPQreyesRenderer();
                break;
            }
            case R2_BORDER_R_POINT: {
                renderer = new R2BRPQreyesRenderer();
                break;
            }
            case R2_BORDER_C_POINT: {
                renderer = new R2BCPQreyesRenderer();
                break;
            }
            case DR2_BORDER_R_POINT: {
                renderer = new DR2BRPQreyesRenderer();
                break;
            }
            case DR2_BORDER_C_POINT: {
                renderer = new DR2BCPQreyesRenderer();
                break;
            }
            default: {
                throw new IllegalArgumentException("No encoder available for format " + (Object)((Object)format));
            }
        }
        renderer.render(image, format, position, slave, border, point);
    }
}

