/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen.qrcode;

import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.iherus.codegen.Codectx;
import org.iherus.codegen.GenericCodeConfig;
import org.iherus.codegen.qrcode.LogoConfig;
import org.iherus.codegen.qrcode.QreyesFormat;

public class QrcodeConfig
extends GenericCodeConfig {
    private static final long serialVersionUID = 8107373062688869595L;
    private static ConcurrentHashMap<EncodeHintType, Object> hints = null;
    private int margin = 10;
    @Deprecated
    private int padding = 0;
    private int borderSize = 0;
    private int borderRadius = 0;
    private String borderColor = "#808080";
    private Codectx.BorderStyle borderStyle = Codectx.BorderStyle.DASHED;
    private int borderDashGranularity = 5;
    private String codeEyesBorderColor = "#000000";
    private String codeEyesPointColor = "#000000";
    private QreyesFormat codeEyesFormat = QreyesFormat.R_BORDER_R_POINT;
    private final LogoConfig logoConfig = new LogoConfig();

    public QrcodeConfig() {
        this(250, 250);
    }

    public QrcodeConfig(int width, int height) {
        super(width, height);
    }

    public int getPadding() {
        return this.padding;
    }

    public QrcodeConfig setPadding(int padding) {
        this.padding = padding;
        this.addHint(EncodeHintType.MARGIN, padding);
        return this;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public QrcodeConfig setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        return this;
    }

    public int getBorderRadius() {
        return this.borderRadius;
    }

    public QrcodeConfig setBorderRadius(int borderRadius) {
        this.borderRadius = borderRadius;
        return this;
    }

    public Codectx.BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public QrcodeConfig setBorderStyle(Codectx.BorderStyle style) {
        this.borderStyle = style;
        return this;
    }

    public int getBorderDashGranularity() {
        return this.borderDashGranularity;
    }

    public QrcodeConfig setBorderDashGranularity(int granularity) {
        this.borderDashGranularity = granularity;
        return this;
    }

    public String getCodeEyesBorderColor() {
        return this.codeEyesBorderColor;
    }

    public QrcodeConfig setCodeEyesBorderColor(String codeEyesBorderColor) {
        this.codeEyesBorderColor = codeEyesBorderColor;
        return this;
    }

    public String getCodeEyesPointColor() {
        return this.codeEyesPointColor;
    }

    public QrcodeConfig setCodeEyesPointColor(String codeEyesPointColor) {
        this.codeEyesPointColor = codeEyesPointColor;
        return this;
    }

    public QreyesFormat getCodeEyesFormat() {
        return this.codeEyesFormat;
    }

    public QrcodeConfig setCodeEyesFormat(QreyesFormat codeEyesFormat) {
        this.codeEyesFormat = codeEyesFormat;
        return this;
    }

    public LogoConfig getLogoConfig() {
        return this.logoConfig;
    }

    public int getMargin() {
        return this.margin;
    }

    public QrcodeConfig setMargin(int margin) {
        this.margin = margin;
        return this;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public QrcodeConfig setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @Override
    public QrcodeConfig setWidth(int width) {
        return (QrcodeConfig)super.setWidth(width);
    }

    @Override
    public QrcodeConfig setHeight(int height) {
        return (QrcodeConfig)super.setHeight(height);
    }

    @Override
    public QrcodeConfig setMasterColor(String masterColor) {
        super.setMasterColor(masterColor);
        this.setCodeEyesBorderColor(masterColor);
        this.setCodeEyesPointColor(masterColor);
        return this;
    }

    @Override
    public QrcodeConfig setSlaveColor(String slaveColor) {
        super.setSlaveColor(slaveColor);
        return this;
    }

    public QrcodeConfig setLogoRatio(int ratio) {
        this.getLogoConfig().setRatio(ratio);
        return this;
    }

    public QrcodeConfig setLogoBorderSize(int borderSize) {
        this.getLogoConfig().setBorderSize(borderSize);
        return this;
    }

    public QrcodeConfig setLogoPadding(int padding) {
        this.getLogoConfig().setPadding(padding);
        return this;
    }

    public QrcodeConfig setLogoBorderColor(String borderColor) {
        this.getLogoConfig().setBorderColor(borderColor);
        return this;
    }

    public QrcodeConfig setLogoBackgroundColor(String backgroundColor) {
        this.getLogoConfig().setBackgroundColor(backgroundColor);
        return this;
    }

    public QrcodeConfig setLogoMargin(int margin) {
        this.getLogoConfig().setMargin(margin);
        return this;
    }

    public QrcodeConfig setLogoPanelArcWidth(int arcWidth) {
        this.getLogoConfig().setPanelArcWidth(arcWidth);
        return this;
    }

    public QrcodeConfig setLogoPanelArcHeight(int arcHeight) {
        this.getLogoConfig().setPanelArcHeight(arcHeight);
        return this;
    }

    public QrcodeConfig setLogoArcWidth(int arcWidth) {
        this.getLogoConfig().setArcWidth(arcWidth);
        return this;
    }

    public QrcodeConfig setLogoArcHeight(int arcHeight) {
        this.getLogoConfig().setArcHeight(arcHeight);
        return this;
    }

    @Deprecated
    public QrcodeConfig setPanelColor(String color) {
        return this.setLogoPanelBackgroundColor(color);
    }

    public QrcodeConfig setLogoPanelBackgroundColor(String color) {
        this.getLogoConfig().setPanelColor(color);
        return this;
    }

    public QrcodeConfig setLogoShape(Codectx.LogoShape shape) {
        this.getLogoConfig().setShape(shape);
        return this;
    }

    public Map<EncodeHintType, Object> getHints() {
        return hints;
    }

    public Map<EncodeHintType, Object> addHint(EncodeHintType type, Object value) {
        Map<EncodeHintType, Object> hints = this.getHints();
        hints.put(type, value);
        return hints;
    }

    public void setErrorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) {
        this.addHint(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
    }

    static {
        hints = new ConcurrentHashMap();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
    }
}

