/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen.qrcode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.iherus.codegen.qrcode.QreyesRenderStrategy;

public class QreyesPosition
implements Serializable {
    private static final long serialVersionUID = 431898735159262499L;
    private static final PointPosition POS = new PointPosition();
    private int leftStartX;
    private int leftEndX;
    private int topStartY;
    private int topEndY;
    private int rightStartX;
    private int rightEndX;
    private int bottomStartY;
    private int bottomEndY;
    private int modules;
    private int[] topLeftOnBit;
    private static final String clearCommand = "topLeftPointtopRightPointbottomLeftPoint";

    public QreyesPosition() {
    }

    public QreyesPosition(int modules, int[] topLeftOnBit) {
        this.modules = modules;
        this.topLeftOnBit = topLeftOnBit;
    }

    public QreyesPosition(int leftStartX, int leftEndX, int topStartY, int topEndY, int rightStartX, int rightEndX, int bottomStartY, int bottomEndY, int modules, int[] topLeftOnBit) {
        this(modules, topLeftOnBit);
        this.setPosition(leftStartX, leftEndX, topStartY, topEndY, rightStartX, rightEndX, bottomStartY, bottomEndY);
    }

    public int getLeftStartX() {
        return this.leftStartX;
    }

    public void setLeftStartX(int leftStartX) {
        this.leftStartX = leftStartX;
    }

    public int getLeftEndX() {
        return this.leftEndX;
    }

    public void setLeftEndX(int leftEndX) {
        this.leftEndX = leftEndX;
    }

    public int getTopStartY() {
        return this.topStartY;
    }

    public void setTopStartY(int topStartY) {
        this.topStartY = topStartY;
    }

    public int getTopEndY() {
        return this.topEndY;
    }

    public void setTopEndY(int topEndY) {
        this.topEndY = topEndY;
    }

    public int getRightStartX() {
        return this.rightStartX;
    }

    public void setRightStartX(int rightStartX) {
        this.rightStartX = rightStartX;
    }

    public int getRightEndX() {
        return this.rightEndX;
    }

    public void setRightEndX(int rightEndX) {
        this.rightEndX = rightEndX;
    }

    public int getBottomStartY() {
        return this.bottomStartY;
    }

    public void setBottomStartY(int bottomStartY) {
        this.bottomStartY = bottomStartY;
    }

    public int getBottomEndY() {
        return this.bottomEndY;
    }

    public void setBottomEndY(int bottomEndY) {
        this.bottomEndY = bottomEndY;
    }

    public int getModules() {
        return this.modules;
    }

    public void setModules(int modules) {
        this.modules = modules;
    }

    public int[] getTopLeftOnBit() {
        return this.topLeftOnBit;
    }

    public void setTopLeftOnBit(int[] topLeftOnBit) {
        this.topLeftOnBit = topLeftOnBit;
    }

    public QreyesPosition setPosition(int leftStartX, int leftEndX, int topStartY, int topEndY, int rightStartX, int rightEndX, int bottomStartY, int bottomEndY) {
        this.leftStartX = leftStartX;
        this.leftEndX = leftEndX;
        this.topStartY = topStartY;
        this.topEndY = topEndY;
        this.rightStartX = rightStartX;
        this.rightEndX = rightEndX;
        this.bottomStartY = bottomStartY;
        this.bottomEndY = bottomEndY;
        return this;
    }

    public final int getModuleWidth(int imgWidth) {
        return (imgWidth - 2 * this.topLeftOnBit[0]) / this.modules;
    }

    public final int getModuleHeight(int imgHeight) {
        return (imgHeight - 2 * this.topLeftOnBit[1]) / this.modules;
    }

    public final int getBorderSize(int imgWidth) {
        return this.getModuleWidth(imgWidth);
    }

    public final int[] topLeftRect() {
        return new int[]{this.leftStartX, this.topStartY, this.leftEndX - this.leftStartX, this.topEndY - this.topStartY};
    }

    public final int[] topRightRect() {
        return new int[]{this.rightStartX, this.topStartY, this.rightEndX - this.rightStartX, this.topEndY - this.topStartY};
    }

    public final int[] bottomLeftRect() {
        return new int[]{this.leftStartX, this.bottomStartY, this.leftEndX - this.leftStartX, this.bottomEndY - this.bottomStartY};
    }

    public final int[] topLeftPoint() {
        Map<String, Object> m = POS.traceGet("topLeftPoint", clearCommand);
        return new int[]{(Integer)m.get("leftStartX"), (Integer)m.get("topStartY"), (Integer)m.get("leftEndX") - (Integer)m.get("leftStartX"), (Integer)m.get("topEndY") - (Integer)m.get("topStartY")};
    }

    public final int[] topRightPoint() {
        Map<String, Object> m = POS.traceGet("topRightPoint", clearCommand);
        return new int[]{(Integer)m.get("rightStartX"), (Integer)m.get("topStartY"), (Integer)m.get("rightEndX") - (Integer)m.get("rightStartX"), (Integer)m.get("topEndY") - (Integer)m.get("topStartY")};
    }

    public final int[] bottomLeftPoint() {
        Map<String, Object> m = POS.traceGet("bottomLeftPoint", clearCommand);
        return new int[]{(Integer)m.get("leftStartX"), (Integer)m.get("bottomStartY"), (Integer)m.get("leftEndX") - (Integer)m.get("leftStartX"), (Integer)m.get("bottomEndY") - (Integer)m.get("bottomStartY")};
    }

    public QreyesPosition focusPoint(int imgWidth, int imgHeight) {
        if (POS.executed()) {
            return this;
        }
        int w = this.getModuleWidth(imgWidth);
        int h = this.getModuleHeight(imgHeight);
        int _leftStartX = this.topLeftOnBit[0] + w * QreyesRenderStrategy.POINT.getStart();
        int _leftEndX = this.topLeftOnBit[0] + w * QreyesRenderStrategy.POINT.getEnd();
        int _topStartY = this.topLeftOnBit[1] + h * QreyesRenderStrategy.POINT.getStart();
        int _topEndY = this.topLeftOnBit[1] + h * QreyesRenderStrategy.POINT.getEnd();
        int _rightStartX = this.topLeftOnBit[0] + w * (this.modules - QreyesRenderStrategy.POINT.getEnd());
        int _rightEndX = imgWidth - this.topLeftOnBit[0] - w * QreyesRenderStrategy.POINT.getStart();
        int _bottomStartY = imgHeight - this.topLeftOnBit[1] - h * QreyesRenderStrategy.POINT.getEnd();
        int _bottomEndY = imgHeight - this.topLeftOnBit[1] - h * QreyesRenderStrategy.POINT.getStart();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("leftStartX", _leftStartX);
        map.put("leftEndX", _leftEndX);
        map.put("topStartY", _topStartY);
        map.put("topEndY", _topEndY);
        map.put("rightStartX", _rightStartX);
        map.put("rightEndX", _rightEndX);
        map.put("bottomStartY", _bottomStartY);
        map.put("bottomEndY", _bottomEndY);
        POS.putAll(map);
        POS.count();
        return this;
    }

    private static class PointPosition
    extends ThreadLocal<Map<String, Object>> {
        private static final String RCK = PointPosition.class.getName() + "_record_check_methods.";
        private static final String COUNTER_KEY = PointPosition.class.getName() + "_method_execute_count.";

        private PointPosition() {
        }

        @Override
        protected Map<String, Object> initialValue() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(RCK, "");
            return map;
        }

        protected void putAll(Map<String, Integer> map) {
            ((Map)this.get()).putAll(map);
        }

        protected void count() {
            Object o = ((Map)this.get()).get(COUNTER_KEY);
            int c = o == null ? 0 : Integer.parseInt(o.toString());
            ((Map)this.get()).put(COUNTER_KEY, ++c);
        }

        protected boolean executed() {
            return null != ((Map)this.get()).get(COUNTER_KEY);
        }

        protected Map<String, Object> traceGet(String trace, String clearCommand) {
            ((Map)this.get()).put(RCK, ((Map)this.get()).get(RCK) + trace);
            Map result = (Map)this.get();
            if (result.get(RCK).toString().equals(clearCommand)) {
                this.remove();
            }
            return result;
        }
    }
}

