/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.Version;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.iherus.codegen.AbstractGenerator;
import org.iherus.codegen.QrcodeGenerateException;
import org.iherus.codegen.qrcode.LogoConfig;
import org.iherus.codegen.qrcode.MultiFormatQreyesRenderer;
import org.iherus.codegen.qrcode.Qrcode;
import org.iherus.codegen.qrcode.QrcodeConfig;
import org.iherus.codegen.qrcode.QrcodeGenerator;
import org.iherus.codegen.qrcode.QrcodeWriter;
import org.iherus.codegen.qrcode.QreyesFormat;
import org.iherus.codegen.qrcode.QreyesPosition;
import org.iherus.codegen.qrcode.QreyesRenderStrategy;
import org.iherus.codegen.qrcode.ThreadQrcode;
import org.iherus.codegen.utils.FileUtils;
import org.iherus.codegen.utils.HttpUtils;

public class SimpleQrcodeGenerator
extends AbstractGenerator
implements QrcodeGenerator {
    private static final ThreadQrcode QRCODE = new ThreadQrcode();
    private final QrcodeConfig qrcodeConfig;

    public SimpleQrcodeGenerator() {
        this(new QrcodeConfig());
    }

    public SimpleQrcodeGenerator(QrcodeConfig qrcodeConfig) {
        this.qrcodeConfig = qrcodeConfig;
    }

    @Override
    public QrcodeGenerator setLogo(String path, boolean remote) {
        QRCODE.setLogo(path, remote);
        return this;
    }

    @Override
    public QrcodeConfig getQrcodeConfig() {
        return this.qrcodeConfig;
    }

    @Override
    public QrcodeGenerator generate(String content) {
        QRCODE.setImage(SimpleQrcodeGenerator.generateQrcode(this.getQrcodeConfig(), QRCODE.getLogo(), content));
        return this;
    }

    @Override
    public QrcodeGenerator generate(String content, String logoPath) {
        return (QrcodeGenerator)this.setLogo(logoPath).generate(content);
    }

    @Override
    public BufferedImage getImage(boolean clear) {
        try {
            BufferedImage bufferedImage = QRCODE.getImage();
            return bufferedImage;
        }
        finally {
            if (clear) {
                this.clear();
            }
        }
    }

    @Override
    public void clear() {
        QRCODE.remove();
    }

    @Override
    public boolean toFile(String pathname) throws IOException {
        try {
            boolean bl = ImageIO.write((RenderedImage)QRCODE.getImage(), "PNG", new File(pathname));
            return bl;
        }
        finally {
            this.clear();
        }
    }

    @Override
    public boolean toStream(OutputStream output) throws IOException {
        try {
            boolean bl = ImageIO.write((RenderedImage)QRCODE.getImage(), "PNG", output);
            return bl;
        }
        finally {
            this.clear();
        }
    }

    private static BufferedImage generateQrcode(QrcodeConfig config, Qrcode.Logo logo, String content) {
        try {
            byte[] bytes;
            QrcodeWriter.QRCodeBitMatrix m = new QrcodeWriter().encodeX(content, BarcodeFormat.QR_CODE, config.getWidth(), config.getHeight(), config.getHints());
            BufferedImage image = SimpleQrcodeGenerator.toBufferedImage(m, config);
            image = SimpleQrcodeGenerator.setRadius(image, config.getBorderRadius(), config.getBorderSize(), config.getBorderColor(), config.getBorderStyle(), config.getBorderDashGranularity(), config.getMargin());
            if (logo != null && logo.getPath() != null && logo.getPath().length() > 0 && (bytes = logo.isRemote() ? HttpUtils.readStreamToByteArray(logo.getPath()) : FileUtils.readFileToByteArray(new File(logo.getPath()))).length > 0) {
                SimpleQrcodeGenerator.addLogo(image, bytes, config.getLogoConfig());
            }
            return image;
        }
        catch (Exception e) {
            throw new QrcodeGenerateException(e);
        }
    }

    public static void addLogo(BufferedImage image, byte[] logo, LogoConfig config) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(logo);
        BufferedImage srcImage = image;
        BufferedImage logoImage = null;
        logoImage = ImageIO.read(input);
        if (logoImage == null) {
            return;
        }
        int ratio = config.getRatio();
        int logoWidth = logoImage.getWidth();
        int logoHeight = logoImage.getHeight();
        float ratioWidthOfCodeImage = (float)srcImage.getWidth() / (float)ratio;
        float ratioHeightOfCodeImage = (float)srcImage.getHeight() / (float)ratio;
        float width = (float)logoWidth > ratioWidthOfCodeImage ? ratioWidthOfCodeImage : (float)logoWidth;
        float height = (float)logoHeight > ratioHeightOfCodeImage ? ratioHeightOfCodeImage : (float)logoHeight;
        int padding = config.getPadding() * 2;
        int margin = config.getMargin() * 2;
        float w = width + (float)padding + (float)margin;
        float h = height + (float)padding + (float)margin;
        float positionX = ((float)srcImage.getWidth() - w) / 2.0f;
        float positionY = ((float)srcImage.getHeight() - h) / 2.0f;
        RectangularShape shape = null;
        if (config.isRectangle()) {
            shape = new RoundRectangle2D.Float(positionX, positionY, w, h, config.getPanelArcWidth(), config.getPanelArcHeight());
        } else if (config.isCircle()) {
            shape = new Ellipse2D.Float(positionX, positionY, w, h);
        }
        if (shape == null) {
            return;
        }
        Graphics2D graphics = srcImage.createGraphics();
        graphics.setColor(SimpleQrcodeGenerator.getColor(config.getPanelColor()));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.fill(shape);
        positionX += (float)config.getMargin();
        positionY += (float)config.getMargin();
        if (config.isRectangle()) {
            shape = new RoundRectangle2D.Float(positionX, positionY, width + (float)padding, height + (float)padding, config.getArcWidth(), config.getArcHeight());
        } else if (config.isCircle()) {
            shape = new Ellipse2D.Float(positionX, positionY, width + (float)padding, height + (float)padding);
            logoImage = SimpleQrcodeGenerator.clip(logoImage, Math.max(logoWidth, logoHeight));
        }
        graphics.setColor(SimpleQrcodeGenerator.getColor(config.getBackgroundColor()));
        graphics.fill(shape);
        graphics.drawImage(logoImage.getScaledInstance((int)width, (int)height, 4), (int)(positionX += (float)(config.getPadding() + 1)), (int)(positionY += (float)(config.getPadding() + 1)), null);
        graphics.setStroke(new BasicStroke(config.getBorderSize()));
        graphics.setColor(SimpleQrcodeGenerator.getColor(config.getBorderColor()));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.draw(shape);
        graphics.dispose();
        logoImage.flush();
        srcImage.flush();
    }

    private static BufferedImage toBufferedImage(QrcodeWriter.QRCodeBitMatrix matrix, QrcodeConfig config) {
        BitMatrix bitMatrix = matrix.getBitMatrix();
        Version version = matrix.getQrcode().getVersion();
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        int modules = (version.getVersionNumber() - 1) * 4 + 21;
        int[] topLeftOnBit = bitMatrix.getTopLeftOnBit();
        QreyesPosition position = new QreyesPosition(modules, topLeftOnBit);
        int moduleHeight = position.getModuleHeight(height);
        int moduleWidth = position.getModuleWidth(width);
        int leftStartX = topLeftOnBit[0] + moduleWidth * QreyesRenderStrategy.POINT_BORDER.getStart();
        int leftEndX = topLeftOnBit[0] + moduleWidth * QreyesRenderStrategy.POINT_BORDER.getEnd();
        int topStartY = topLeftOnBit[1] + moduleHeight * QreyesRenderStrategy.POINT_BORDER.getStart();
        int topEndY = topLeftOnBit[1] + moduleHeight * QreyesRenderStrategy.POINT_BORDER.getEnd();
        int rightStartX = topLeftOnBit[0] + moduleWidth * (modules - QreyesRenderStrategy.POINT_BORDER.getEnd());
        int rightEndX = width - topLeftOnBit[0] - moduleWidth * QreyesRenderStrategy.POINT_BORDER.getStart();
        int bottomStartY = height - topLeftOnBit[1] - moduleHeight * QreyesRenderStrategy.POINT_BORDER.getEnd();
        int bottomEndY = height - topLeftOnBit[1] - moduleHeight * QreyesRenderStrategy.POINT_BORDER.getStart();
        BufferedImage image = new BufferedImage(width, height, 1);
        int masterColor = SimpleQrcodeGenerator.getColor(config.getMasterColor()).getRGB();
        int slaveColor = SimpleQrcodeGenerator.getColor(config.getSlaveColor()).getRGB();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (x >= leftStartX && x < leftEndX && y >= topStartY && y < topEndY || x >= rightStartX && x < rightEndX && y >= topStartY && y < topEndY || x >= leftStartX && x < leftEndX && y >= bottomStartY && y < bottomEndY) continue;
                image.setRGB(x, y, bitMatrix.get(x, y) ? masterColor : slaveColor);
            }
        }
        position.setPosition(leftStartX, leftEndX, topStartY, topEndY, rightStartX, rightEndX, bottomStartY, bottomEndY);
        Color border = SimpleQrcodeGenerator.getColor(config.getCodeEyesBorderColor());
        Color point = SimpleQrcodeGenerator.getColor(config.getCodeEyesPointColor());
        QreyesFormat format = config.getCodeEyesFormat();
        new MultiFormatQreyesRenderer().render(image, format, position, new Color(slaveColor), border, point);
        return image;
    }
}

