/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.Instant;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class InstantRangeRandomizer
extends AbstractRangeRandomizer<Instant> {
    public InstantRangeRandomizer(Instant min, Instant max) {
        super(min, max);
    }

    public InstantRangeRandomizer(Instant min, Instant max, long seed) {
        super(min, max, seed);
    }

    @Deprecated
    public static InstantRangeRandomizer aNewInstantRangeRandomizer(Instant min, Instant max) {
        return new InstantRangeRandomizer(min, max);
    }

    @Deprecated
    public static InstantRangeRandomizer aNewInstantRangeRandomizer(Instant min, Instant max, long seed) {
        return new InstantRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((Instant)this.min).isAfter((Instant)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected Instant getDefaultMinValue() {
        return Instant.ofEpochMilli(Long.MIN_VALUE);
    }

    @Override
    protected Instant getDefaultMaxValue() {
        return Instant.ofEpochMilli(Long.MAX_VALUE);
    }

    @Override
    public Instant getRandomValue() {
        long minEpochMillis = ((Instant)this.min).toEpochMilli();
        long maxEpochMillis = ((Instant)this.max).toEpochMilli();
        long randomEpochMillis = (long)this.nextDouble(minEpochMillis, maxEpochMillis);
        return Instant.ofEpochMilli(randomEpochMillis);
    }
}

