/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.temporal.ChronoField;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class OffsetTimeRangeRandomizer
extends AbstractRangeRandomizer<OffsetTime> {
    public OffsetTimeRangeRandomizer(OffsetTime min, OffsetTime max) {
        super(min, max);
    }

    public OffsetTimeRangeRandomizer(OffsetTime min, OffsetTime max, long seed) {
        super(min, max, seed);
    }

    @Deprecated
    public static OffsetTimeRangeRandomizer aNewOffsetTimeRangeRandomizer(OffsetTime min, OffsetTime max) {
        return new OffsetTimeRangeRandomizer(min, max);
    }

    @Deprecated
    public static OffsetTimeRangeRandomizer aNewOffsetTimeRangeRandomizer(OffsetTime min, OffsetTime max, long seed) {
        return new OffsetTimeRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((OffsetTime)this.min).isAfter((OffsetTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected OffsetTime getDefaultMinValue() {
        return EasyRandomParameters.DEFAULT_DATES_RANGE.getMin().toOffsetDateTime().toOffsetTime();
    }

    @Override
    protected OffsetTime getDefaultMaxValue() {
        return EasyRandomParameters.DEFAULT_DATES_RANGE.getMax().toOffsetDateTime().toOffsetTime();
    }

    @Override
    public OffsetTime getRandomValue() {
        long minSecondOfDay = ((OffsetTime)this.min).getLong(ChronoField.SECOND_OF_DAY);
        long maxSecondOfDay = ((OffsetTime)this.max).getLong(ChronoField.SECOND_OF_DAY);
        long randomSecondOfDay = (long)this.nextDouble(minSecondOfDay, maxSecondOfDay);
        return OffsetTime.of(LocalTime.ofSecondOfDay(randomSecondOfDay), EasyRandomParameters.DEFAULT_DATES_RANGE.getMin().getOffset());
    }
}

