/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.word.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.jeecgframework.poi.cache.WordCache;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.jeecgframework.poi.word.entity.MyXWPFDocument;
import org.jeecgframework.poi.word.entity.WordImageEntity;
import org.jeecgframework.poi.word.entity.params.ExcelListEntity;
import org.jeecgframework.poi.word.parse.excel.ExcelEntityParse;
import org.jeecgframework.poi.word.parse.excel.ExcelMapParse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseWord07 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseWord07.class);

    private void addAnImage(WordImageEntity obj, XWPFRun currentRun) throws Exception {
        Object[] isAndType = PoiPublicUtil.getIsAndType(obj);
        try {
            String picId = currentRun.getParagraph().getDocument().addPictureData((byte[])isAndType[0], ((Integer)isAndType[1]).intValue());
            ((MyXWPFDocument)currentRun.getParagraph().getDocument()).createPicture(currentRun, picId, currentRun.getParagraph().getDocument().getNextPicNameNumber(((Integer)isAndType[1]).intValue()), obj.getWidth(), obj.getHeight());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void changeValues(XWPFParagraph paragraph, XWPFRun currentRun, String currentText, List<Integer> runIndex, Map<String, Object> map) throws Exception {
        Object obj = PoiPublicUtil.getRealValue(currentText, map);
        if (obj instanceof WordImageEntity) {
            currentRun.setText("", 0);
            this.addAnImage((WordImageEntity)obj, currentRun);
        } else {
            currentText = obj.toString();
            currentRun.setText(currentText, 0);
        }
        for (int k = 0; k < runIndex.size(); ++k) {
            ((XWPFRun)paragraph.getRuns().get(runIndex.get(k))).setText("", 0);
        }
        runIndex.clear();
    }

    private Object checkThisTableIsNeedIterator(XWPFTableCell cell, Map<String, Object> map) throws Exception {
        String text = cell.getText().trim();
        if (text != null && text.startsWith("{{") && text.indexOf("$fe:") != -1) {
            return PoiPublicUtil.getRealValue(text.replace("$fe:", "").trim(), map);
        }
        return null;
    }

    private void parseAllParagraphic(List<XWPFParagraph> paragraphs, Map<String, Object> map) throws Exception {
        for (int i = 0; i < paragraphs.size(); ++i) {
            XWPFParagraph paragraph = paragraphs.get(i);
            if (paragraph.getText().indexOf("{{") == -1) continue;
            this.parseThisParagraph(paragraph, map);
        }
    }

    private void parseThisParagraph(XWPFParagraph paragraph, Map<String, Object> map) throws Exception {
        XWPFRun currentRun = null;
        Object currentText = "";
        Boolean isfinde = false;
        ArrayList<Integer> runIndex = new ArrayList<Integer>();
        for (int i = 0; i < paragraph.getRuns().size(); ++i) {
            XWPFRun run = (XWPFRun)paragraph.getRuns().get(i);
            String text = run.getText(0);
            if (StringUtils.isEmpty((CharSequence)text)) continue;
            if (isfinde.booleanValue()) {
                if (((String)(currentText = (String)currentText + text)).indexOf("{{") == -1) {
                    isfinde = false;
                    runIndex.clear();
                } else {
                    runIndex.add(i);
                }
                if (((String)currentText).indexOf("}}") != -1) {
                    this.changeValues(paragraph, currentRun, (String)currentText, runIndex, map);
                    currentText = "";
                    isfinde = false;
                }
            } else if (text.indexOf("{") >= 0) {
                currentText = text;
                isfinde = true;
                currentRun = run;
            } else {
                currentText = "";
            }
            if (((String)currentText).indexOf("}}") == -1) continue;
            this.changeValues(paragraph, currentRun, (String)currentText, runIndex, map);
            isfinde = false;
        }
    }

    private void parseThisRow(List<XWPFTableCell> cells, Map<String, Object> map) throws Exception {
        for (XWPFTableCell cell : cells) {
            this.parseAllParagraphic(cell.getParagraphs(), map);
        }
    }

    private void parseThisTable(XWPFTable table, Map<String, Object> map) throws Exception {
        for (int i = 0; i < table.getNumberOfRows(); ++i) {
            XWPFTableRow row = table.getRow(i);
            List cells = row.getTableCells();
            Object listobj = this.checkThisTableIsNeedIterator((XWPFTableCell)cells.get(0), map);
            if (listobj == null) {
                this.parseThisRow(cells, map);
                continue;
            }
            if (listobj instanceof ExcelListEntity) {
                new ExcelEntityParse().parseNextRowAndAddRow(table, i, (ExcelListEntity)listobj);
                i = i + ((ExcelListEntity)listobj).getList().size() - 1;
                continue;
            }
            ExcelMapParse.parseNextRowAndAddRow(table, i, (List)listobj);
            i = i + ((List)listobj).size() - 1;
        }
    }

    public XWPFDocument parseWord(String url, Map<String, Object> map) throws Exception {
        MyXWPFDocument doc = WordCache.getXWPFDocumen(url);
        this.parseWordSetValue(doc, map);
        return doc;
    }

    public void parseWord(XWPFDocument document, Map<String, Object> map) throws Exception {
        this.parseWordSetValue((MyXWPFDocument)document, map);
    }

    private void parseWordSetValue(MyXWPFDocument doc, Map<String, Object> map) throws Exception {
        this.parseAllParagraphic(doc.getParagraphs(), map);
        this.parseHeaderAndFoot(doc, map);
        Iterator itTable = doc.getTablesIterator();
        while (itTable.hasNext()) {
            XWPFTable table = (XWPFTable)itTable.next();
            if (table.getText().indexOf("{{") == -1) continue;
            this.parseThisTable(table, map);
        }
    }

    private void parseHeaderAndFoot(MyXWPFDocument doc, Map<String, Object> map) throws Exception {
        List headerList = doc.getHeaderList();
        for (XWPFHeader xwpfHeader : headerList) {
            for (int i = 0; i < xwpfHeader.getListParagraph().size(); ++i) {
                this.parseThisParagraph((XWPFParagraph)xwpfHeader.getListParagraph().get(i), map);
            }
        }
        List footerList = doc.getFooterList();
        for (XWPFFooter xwpfFooter : footerList) {
            for (int i = 0; i < xwpfFooter.getListParagraph().size(); ++i) {
                this.parseThisParagraph((XWPFParagraph)xwpfFooter.getListParagraph().get(i), map);
            }
        }
    }
}

