/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;

final class LicenseClient {
    private static final AtomicBoolean inSending = new AtomicBoolean(false);

    LicenseClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getBasicSetInfo() {
        StringBuilder sb;
        ResultSet rs;
        PreparedStatement pstatement;
        Connection connection;
        block4: {
            String sql = "SELECT bset_name,bset_address,bset_phone,bset_admin,bset_email FROM np_sys_basicset";
            connection = null;
            pstatement = null;
            rs = null;
            sb = new StringBuilder();
            try {
                connection = DB.getConnection();
                pstatement = connection.prepareStatement(sql);
                rs = pstatement.executeQuery();
                if (!rs.next()) break block4;
                sb.append("{\"sn\":\"" + rs.getString("bset_name") + "\",");
                sb.append("\"su\":\"" + rs.getString("bset_address") + "\",");
                sb.append("\"ap\":\"" + rs.getString("bset_phone") + "\",");
                sb.append("\"admin\":\"" + rs.getString("bset_admin") + "\"}");
            }
            catch (SQLException sQLException) {
                DB.release(connection, pstatement, rs);
                catch (Throwable throwable) {
                    DB.release(connection, pstatement, rs);
                    throw throwable;
                }
            }
        }
        DB.release(connection, pstatement, rs);
        return sb.toString();
    }

    public static void sendLocalInfo() throws Exception {
        HttpClient.post("http://license.kstore.qianmi.com/info", "info=" + Hex.encodeHexStr(PublicSecret.encryptData("{\"basic\":" + LicenseClient.getBasicSetInfo() + "}")));
    }

    public static void timingSend() {
        if (inSending.compareAndSet(false, true)) {
            new Timer().schedule(new TimerTask(){

                public void run() {
                    try {
                        LicenseClient.sendLocalInfo();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, 0L, 86400000L);
        }
    }

    private static class PublicSecret {
        private PublicSecret() {
        }

        public static byte[] encryptData(String data) throws Exception {
            Key publicKey = PublicSecret.readKey("key_public.key");
            byte[] dataByte = data.getBytes("UTF-8");
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return cipher.doFinal(dataByte);
        }

        public static Key readKey(String keyName) throws Exception {
            InputStream is = LicenseClient.class.getClassLoader().getResourceAsStream("com/qianmi/license/" + keyName);
            ObjectInputStream ois = new ObjectInputStream(is);
            Key key = (Key)ois.readObject();
            ois.close();
            is.close();
            return key;
        }
    }

    private static class Hex {
        private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        private Hex() {
        }

        public static char[] encodeHex(byte[] data) {
            return Hex.encodeHex(data, true);
        }

        public static char[] encodeHex(byte[] data, boolean toLowerCase) {
            return Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
        }

        protected static char[] encodeHex(byte[] data, char[] toDigits) {
            int l = data.length;
            char[] out = new char[l << 1];
            int j = 0;
            for (int i = 0; i < l; ++i) {
                out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
                out[j++] = toDigits[0xF & data[i]];
            }
            return out;
        }

        public static String encodeHexStr(byte[] data) {
            return Hex.encodeHexStr(data, true);
        }

        public static String encodeHexStr(byte[] data, boolean toLowerCase) {
            return Hex.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
        }

        protected static String encodeHexStr(byte[] data, char[] toDigits) {
            return new String(Hex.encodeHex(data, toDigits));
        }

        public static byte[] decodeHex(char[] data) {
            int len = data.length;
            if ((len & 1) != 0) {
                throw new RuntimeException("Odd number of characters.");
            }
            byte[] out = new byte[len >> 1];
            int i = 0;
            int j = 0;
            while (j < len) {
                int f = Hex.toDigit(data[j], j) << 4;
                f |= Hex.toDigit(data[++j], j);
                ++j;
                out[i] = (byte)(f & 0xFF);
                ++i;
            }
            return out;
        }

        protected static int toDigit(char ch, int index) {
            int digit = Character.digit(ch, 16);
            if (digit == -1) {
                throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
            }
            return digit;
        }
    }

    private static class HttpClient {
        private HttpClient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String post(String url, String data) throws IOException {
            PrintWriter out = null;
            BufferedReader in = null;
            String result = "";
            try {
                String line;
                URL realUrl = new URL(url);
                URLConnection conn = realUrl.openConnection();
                conn.setRequestProperty("accept", "*/*");
                conn.setRequestProperty("connection", "Keep-Alive");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                out = new PrintWriter(conn.getOutputStream());
                out.print(data);
                out.flush();
                in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                while ((line = in.readLine()) != null) {
                    result = result + line;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return result;
        }
    }

    private static class DB {
        static String url = "jdbc:mysql://127.0.0.1:3306/kstore_v2?useUnicode=true&characterEncoding=UTF-8&relaxAutoCommit=true&zeroDateTimeBehavior=convertToNull";
        static String username = "root";
        static String password = "ningpai520";

        private DB() {
        }

        public static Connection getConnection() throws SQLException {
            return DriverManager.getConnection(url, username, password);
        }

        public static void release(Connection connection, Statement statement, ResultSet resultSet) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }

        static {
            try {
                Properties prop = new Properties();
                prop.load(LicenseClient.class.getClassLoader().getResourceAsStream("com/ningpai/web/config/jdbc.properties"));
                if (prop.containsKey("jdbc.url")) {
                    url = prop.getProperty("jdbc.url");
                }
                if (prop.containsKey("jdbc.username")) {
                    username = prop.getProperty("jdbc.username");
                }
                if (prop.containsKey("jdbc.password")) {
                    password = prop.getProperty("jdbc.password");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

