/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.ProxyCodeHelpers;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;
import org.python.util.Generic;

public class ProxyMaker
extends ProxyCodeHelpers
implements ClassConstants,
Opcodes {
    protected final Class<?> superclass;
    protected final Class<?>[] interfaces;
    Set<String> names;
    Set<String> supernames;
    Set<String> namesAndSigs;
    public ClassFile classfile;
    public String myClass;

    @Deprecated
    public ProxyMaker(String superclassName, Class<?> superclass) {
        Class[] classArray;
        String string = "org.python.proxies." + superclassName;
        Class clazz = superclass.isInterface() ? Object.class : superclass;
        if (superclass.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = superclass;
        } else {
            classArray = new Class[]{};
        }
        this(string, clazz, classArray);
    }

    public ProxyMaker(String proxyClassName, Class<?> superclass, Class<?> ... interfaces) {
        this.supernames = Generic.set();
        this.myClass = proxyClassName;
        if (superclass == null) {
            superclass = Object.class;
        }
        if (superclass.isInterface()) {
            throw new IllegalArgumentException("Given an interface,  " + superclass.getName() + ", for a proxy superclass");
        }
        this.superclass = superclass;
        if (interfaces == null) {
            interfaces = new Class[]{};
        }
        for (Class<?> interfac : interfaces) {
            if (interfac.isInterface()) continue;
            throw new IllegalArgumentException("All classes in the interfaces array must be interfaces, unlike " + interfac.getName());
        }
        this.interfaces = interfaces;
    }

    public void doConstants() throws Exception {
        Code code = this.classfile.addMethod("<clinit>", ProxyMaker.makeSig("V", new String[0]), 8);
        code.return_();
    }

    public void callSuper(Code code, String name, String superclass, Class<?>[] parameters, Class<?> ret, boolean doReturn) throws Exception {
        code.aload(0);
        int local_index = 1;
        block6: for (int i = 0; i < parameters.length; ++i) {
            switch (ProxyMaker.getType(parameters[i])) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    code.iload(local_index);
                    ++local_index;
                    continue block6;
                }
                case 4: {
                    code.lload(local_index);
                    local_index += 2;
                    continue block6;
                }
                case 5: {
                    code.fload(local_index);
                    ++local_index;
                    continue block6;
                }
                case 6: {
                    code.dload(local_index);
                    local_index += 2;
                    continue block6;
                }
                default: {
                    code.aload(local_index);
                    ++local_index;
                }
            }
        }
        code.invokespecial(superclass, name, ProxyMaker.makeSig(ret, parameters));
        if (doReturn) {
            ProxyMaker.doReturn(code, ret);
        }
    }

    public void doJavaCall(Code code, String name, String type, String jcallName) throws Exception {
        code.invokevirtual("org/python/core/PyObject", jcallName, ProxyMaker.makeSig("Lorg/python/core/PyObject;", "[Ljava/lang/Object;"));
        code.invokestatic("org/python/core/Py", "py2" + name, ProxyMaker.makeSig(type, "Lorg/python/core/PyObject;"));
    }

    public void getArgs(Code code, Class<?>[] parameters) throws Exception {
        if (parameters.length == 0) {
            code.getstatic("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
        } else {
            code.iconst(parameters.length);
            code.anewarray("java/lang/Object");
            int array = code.getLocal("[org/python/core/PyObject");
            code.astore(array);
            int local_index = 1;
            for (int i = 0; i < parameters.length; ++i) {
                code.aload(array);
                code.iconst(i);
                switch (ProxyMaker.getType(parameters[i])) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        code.iload(local_index);
                        ++local_index;
                        code.invokestatic("org/python/core/Py", "newInteger", "(I)Lorg/python/core/PyInteger;");
                        break;
                    }
                    case 4: {
                        code.lload(local_index);
                        local_index += 2;
                        code.invokestatic("org/python/core/Py", "newInteger", "(J)Lorg/python/core/PyObject;");
                        break;
                    }
                    case 5: {
                        code.fload(local_index);
                        ++local_index;
                        code.invokestatic("org/python/core/Py", "newFloat", "(F)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 6: {
                        code.dload(local_index);
                        local_index += 2;
                        code.invokestatic("org/python/core/Py", "newFloat", "(D)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 7: {
                        code.iload(local_index);
                        ++local_index;
                        code.invokestatic("org/python/core/Py", "newString", "(C)Lorg/python/core/PyString;");
                        break;
                    }
                    default: {
                        code.aload(local_index);
                        ++local_index;
                    }
                }
                code.aastore();
            }
            code.aload(array);
        }
    }

    public void callMethod(Code code, String name, Class<?>[] parameters, Class<?> ret, Class<?>[] exceptions2) throws Exception {
        Label start = null;
        Label end = null;
        String jcallName = "_jcall";
        int instLocal = 0;
        if (exceptions2.length > 0) {
            start = new Label();
            end = new Label();
            jcallName = "_jcallexc";
            instLocal = code.getLocal("org/python/core/PyObject");
            code.astore(instLocal);
            code.label(start);
            code.aload(instLocal);
        }
        this.getArgs(code, parameters);
        switch (ProxyMaker.getType(ret)) {
            case 7: {
                this.doJavaCall(code, "char", "C", jcallName);
                break;
            }
            case 0: {
                this.doJavaCall(code, "boolean", "Z", jcallName);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.doJavaCall(code, "int", "I", jcallName);
                break;
            }
            case 4: {
                this.doJavaCall(code, "long", "J", jcallName);
                break;
            }
            case 5: {
                this.doJavaCall(code, "float", "F", jcallName);
                break;
            }
            case 6: {
                this.doJavaCall(code, "double", "D", jcallName);
                break;
            }
            case 8: {
                this.doJavaCall(code, "void", "V", jcallName);
                break;
            }
            default: {
                code.invokevirtual("org/python/core/PyObject", jcallName, ProxyMaker.makeSig("Lorg/python/core/PyObject;", "[Ljava/lang/Object;"));
                code.ldc(ret.getName());
                code.invokestatic("java/lang/Class", "forName", ProxyMaker.makeSig("Ljava/lang/Class;", "Ljava/lang/String;"));
                code.invokestatic("org/python/core/Py", "tojava", ProxyMaker.makeSig("Ljava/lang/Object;", "Lorg/python/core/PyObject;", "Ljava/lang/Class;"));
                code.checkcast(ProxyMaker.mapClass(ret));
            }
        }
        if (end != null) {
            code.label(end);
        }
        ProxyMaker.doReturn(code, ret);
        if (exceptions2.length > 0) {
            boolean throwableFound = false;
            Label handlerStart = null;
            for (Class<?> exception : exceptions2) {
                handlerStart = new Label();
                code.label(handlerStart);
                int excLocal = code.getLocal("java/lang/Throwable");
                code.astore(excLocal);
                code.aload(excLocal);
                code.athrow();
                code.visitTryCatchBlock(start, end, handlerStart, ProxyMaker.mapClass(exception));
                ProxyMaker.doNullReturn(code, ret);
                code.freeLocal(excLocal);
                if (exception != Throwable.class) continue;
                throwableFound = true;
            }
            if (!throwableFound) {
                handlerStart = new Label();
                code.label(handlerStart);
                int excLocal = code.getLocal("java/lang/Throwable");
                code.astore(excLocal);
                code.aload(instLocal);
                code.aload(excLocal);
                code.invokevirtual("org/python/core/PyObject", "_jthrow", ProxyMaker.makeSig("V", "Ljava/lang/Throwable;"));
                code.visitTryCatchBlock(start, end, handlerStart, "java/lang/Throwable");
                code.freeLocal(excLocal);
                ProxyMaker.doNullReturn(code, ret);
            }
            code.freeLocal(instLocal);
        }
    }

    public void addMethod(Method method, int access) throws Exception {
        this.addMethod(method.getName(), method.getReturnType(), method.getParameterTypes(), method.getExceptionTypes(), access, method.getDeclaringClass());
    }

    public void addMethod(String name, Class<?> ret, Class<?>[] parameters, Class<?>[] exceptions2, int access, Class<?> declaringClass) throws Exception {
        this.addMethod(name, name, ret, parameters, exceptions2, access, declaringClass, null, null);
    }

    public void addMethod(String name, String pyName, Class<?> ret, Class<?>[] parameters, Class<?>[] exceptions2, int access, Class<?> declaringClass, ProxyCodeHelpers.AnnotationDescr[] methodAnnotations, ProxyCodeHelpers.AnnotationDescr[][] parameterAnnotations) throws Exception {
        boolean isAbstract = false;
        if (Modifier.isAbstract(access)) {
            access &= 0xFFFFFBFF;
            isAbstract = true;
        }
        String sig = ProxyMaker.makeSig(ret, parameters);
        String[] exceptionTypes = ProxyMaker.mapExceptions(exceptions2);
        this.names.add(name);
        Code code = null;
        code = methodAnnotations != null && parameterAnnotations != null ? this.classfile.addMethod(name, sig, access, exceptionTypes, methodAnnotations, parameterAnnotations) : this.classfile.addMethod(name, sig, access, exceptionTypes);
        code.aload(0);
        code.ldc(pyName);
        if (!isAbstract) {
            int tmp = code.getLocal("org/python/core/PyObject");
            code.invokestatic("org/python/compiler/ProxyMaker", "findPython", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;"));
            code.astore(tmp);
            code.aload(tmp);
            Label callPython = new Label();
            code.ifnonnull(callPython);
            String superClass = ProxyMaker.mapClass(declaringClass);
            this.callSuper(code, name, superClass, parameters, ret, true);
            code.label(callPython);
            code.aload(tmp);
            this.callMethod(code, name, parameters, ret, exceptions2);
            this.addSuperMethod("super__" + name, name, superClass, parameters, ret, sig, access);
        } else {
            code.invokestatic("org/python/compiler/ProxyMaker", "findPython", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;"));
            code.dup();
            Label returnNull = new Label();
            code.ifnull(returnNull);
            this.callMethod(code, name, parameters, ret, exceptions2);
            code.label(returnNull);
            code.pop();
            code.aload(0);
            code.ldc(pyName);
            code.ldc(declaringClass.getName());
            code.invokestatic("org/python/compiler/ProxyCodeHelpers", "notImplementedAbstractMethod", ProxyMaker.makeSig("Lorg/python/core/PyException;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;", "Ljava/lang/String;"));
            code.checkcast(CodegenUtils.p(Throwable.class));
            code.athrow();
            ProxyMaker.doNullReturn(code, ret);
        }
    }

    public void addConstructorMethodCode(String pyName, Class<?>[] parameters, Class<?>[] exceptions2, int access, Class<?> declaringClass, Code code) throws Exception {
        code.aload(0);
        code.ldc(pyName);
        int tmp = code.getLocal("org/python/core/PyObject");
        code.invokestatic("org/python/compiler/ProxyMaker", "findPython", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;"));
        code.astore(tmp);
        code.aload(tmp);
        this.callMethod(code, "<init>", parameters, Void.TYPE, exceptions2);
    }

    private String methodString(Method m) {
        Class<?>[] params;
        StringBuffer buf = new StringBuffer(m.getName());
        buf.append(":");
        for (Class<?> param : params = m.getParameterTypes()) {
            buf.append(param.getName());
            buf.append(",");
        }
        return buf.toString();
    }

    protected void addMethods(Class<?> c, Set<String> t) throws Exception {
        Method[] methods;
        for (Method method : methods = c.getDeclaredMethods()) {
            int access;
            if (!t.add(this.methodString(method)) || Modifier.isStatic(access = method.getModifiers()) || Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                if (Modifier.isFinal(access = access & 0xFFFFFFFB | 1)) {
                    this.addSuperMethod(method, access);
                    continue;
                }
            } else if (Modifier.isFinal(access) || !Modifier.isPublic(access)) continue;
            this.addMethod(method, access);
        }
        Class<?> sc = c.getSuperclass();
        if (sc != null) {
            this.addMethods(sc, t);
        }
        for (Class<?> iface : c.getInterfaces()) {
            this.addMethods(iface, t);
        }
    }

    public void addConstructor(String name, Class<?>[] parameters, Class<?> ret, String sig, int access) throws Exception {
        Code code = this.classfile.addMethod("<init>", sig, access);
        this.callSuper(code, "<init>", name, parameters, Void.TYPE, true);
    }

    public void addConstructors(Class<?> c) throws Exception {
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        String name = ProxyMaker.mapClass(c);
        for (Constructor<?> constructor : constructors) {
            int access = constructor.getModifiers();
            if (Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                access = access & 0xFFFFFFFB | 1;
            }
            Class<?>[] parameters = constructor.getParameterTypes();
            this.addConstructor(name, parameters, Void.TYPE, ProxyMaker.makeSig(Void.TYPE, parameters), access);
        }
    }

    protected void addClassAnnotation(ProxyCodeHelpers.AnnotationDescr annotation) {
        this.classfile.addClassAnnotation(annotation);
    }

    public void addSuperMethod(Method method, int access) throws Exception {
        String superName;
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        String superClass = ProxyMaker.mapClass(method.getDeclaringClass());
        String methodName = superName = method.getName();
        if (Modifier.isFinal(access)) {
            methodName = "super__" + superName;
            access &= 0xFFFFFFEF;
        }
        this.addSuperMethod(methodName, superName, superClass, parameters, ret, ProxyMaker.makeSig(ret, parameters), access);
    }

    public void addSuperMethod(String methodName, String superName, String declClass, Class<?>[] parameters, Class<?> ret, String sig, int access) throws Exception {
        if (methodName.startsWith("super__")) {
            try {
                this.superclass.getMethod(methodName, parameters);
                return;
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                return;
            }
        }
        this.supernames.add(methodName);
        Code code = this.classfile.addMethod(methodName, sig, access);
        this.callSuper(code, superName, declClass, parameters, ret, true);
    }

    public void addProxy() throws Exception {
        this.classfile.addField("__proxy", "Lorg/python/core/PyObject;", 4);
        Code code = this.classfile.addMethod("_setPyInstance", ProxyMaker.makeSig("V", "Lorg/python/core/PyObject;"), 1);
        code.aload(0);
        code.aload(1);
        code.putfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code.return_();
        code = this.classfile.addMethod("_getPyInstance", ProxyMaker.makeSig("Lorg/python/core/PyObject;", new String[0]), 1);
        code.aload(0);
        code.getfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code.areturn();
        String pySys = "Lorg/python/core/PySystemState;";
        this.classfile.addField("__systemState", pySys, 132);
        code = this.classfile.addMethod("_setPySystemState", ProxyMaker.makeSig("V", pySys), 1);
        code.aload(0);
        code.aload(1);
        code.putfield(this.classfile.name, "__systemState", pySys);
        code.return_();
        code = this.classfile.addMethod("_getPySystemState", ProxyMaker.makeSig(pySys, new String[0]), 1);
        code.aload(0);
        code.getfield(this.classfile.name, "__systemState", pySys);
        code.areturn();
    }

    public void addClassDictInit() throws Exception {
        this.classfile.addInterface(ProxyMaker.mapClass(ClassDictInit.class));
        Code code = this.classfile.addMethod("classDictInit", ProxyMaker.makeSig("V", "Lorg/python/core/PyObject;"), 9);
        code.aload(0);
        code.ldc("__supernames__");
        int strArray = CodeCompiler.makeStrings(code, this.supernames);
        code.aload(strArray);
        code.freeLocal(strArray);
        code.invokestatic("org/python/core/Py", "java2py", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Ljava/lang/Object;"));
        code.invokevirtual("org/python/core/PyObject", "__setitem__", ProxyMaker.makeSig("V", "Ljava/lang/String;", "Lorg/python/core/PyObject;"));
        code.return_();
    }

    public void build(OutputStream out) throws Exception {
        this.build();
        this.classfile.write(out);
    }

    public void build() throws Exception {
        this.names = Generic.set();
        this.namesAndSigs = Generic.set();
        int access = this.superclass.getModifiers();
        if ((access & 0x10) != 0) {
            throw new InstantiationException("can't subclass final class");
        }
        access = 33;
        this.classfile = new ClassFile(this.myClass, ProxyMaker.mapClass(this.superclass), access);
        this.addProxy();
        this.visitConstructors();
        this.classfile.addInterface("org/python/core/PyProxy");
        this.visitClassAnnotations();
        this.visitMethods();
        this.doConstants();
        this.addClassDictInit();
    }

    protected void visitMethods(Class<?> klass) throws Exception {
        for (Method method : klass.getDeclaredMethods()) {
            int access;
            if (!this.namesAndSigs.add(this.methodString(method)) || Modifier.isStatic(access = method.getModifiers()) || Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                if (Modifier.isFinal(access = access & 0xFFFFFFFB | 1)) {
                    this.addSuperMethod(method, access);
                    continue;
                }
            } else if (Modifier.isFinal(access) || !Modifier.isPublic(access)) continue;
            this.addMethod(method, access);
        }
        Class<?> superClass = klass.getSuperclass();
        if (superClass != null) {
            this.visitMethods(superClass);
        }
        for (Class<?> iface : klass.getInterfaces()) {
            this.visitMethods(iface);
        }
    }

    protected void visitMethod(Method method) throws Exception {
        this.addMethod(method, method.getModifiers());
    }

    protected void visitMethods() throws Exception {
        this.visitMethods(this.superclass);
        for (Class<?> iface : this.interfaces) {
            if (iface.isAssignableFrom(this.superclass)) {
                Py.writeWarning("compiler", "discarding redundant interface: " + iface.getName());
                continue;
            }
            this.classfile.addInterface(ProxyMaker.mapClass(iface));
            this.visitMethods(iface);
        }
    }

    protected void addConstructor(Class<?>[] parameters, int access) throws Exception {
        String sig = ProxyMaker.makeSig(Void.TYPE, parameters);
        Code code = this.classfile.addMethod("<init>", sig, access);
        this.callSuper(code, "<init>", ProxyMaker.mapClass(this.superclass), parameters, Void.TYPE, true);
    }

    protected void visitConstructor(Constructor<?> constructor) throws Exception {
        this.callInitProxy(constructor.getParameterTypes(), this.addOpenConstructor(constructor));
    }

    protected Code addOpenConstructor(Constructor<?> constructor) throws Exception {
        String sig = ProxyMaker.makeSig(Void.TYPE, constructor.getParameterTypes());
        Code code = this.classfile.addMethod("<init>", sig, constructor.getModifiers());
        this.callSuper(code, "<init>", ProxyMaker.mapClass(this.superclass), constructor.getParameterTypes(), Void.TYPE, true);
        return code;
    }

    protected void callInitProxy(Class<?>[] parameters, Code code) throws Exception {
        code.visitVarInsn(25, 0);
        this.getArgs(code, parameters);
        code.visitMethodInsn(182, this.classfile.name, "__initProxy__", ProxyMaker.makeSig("V", "[Ljava/lang/Object;"), false);
        code.visitInsn(177);
    }

    protected void visitConstructors() throws Exception {
        this.addConstructors(this.superclass);
    }

    protected void visitClassAnnotations() throws Exception {
    }
}

