/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations.util;

import com.uwyn.rife.continuations.ClassByteAware;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClassByteUtil {
    public static byte[] getBytes(String className, ClassLoader classLoader) throws IOException {
        byte[] bytes = null;
        String classFilename = className.replace('.', '/') + ".class";
        URL resource = classLoader.getResource(classFilename);
        if (null == resource) {
            for (ClassLoader parent = classLoader; parent != null; parent = parent.getParent()) {
                if (!(parent instanceof ClassByteAware)) continue;
                ClassByteAware cba = (ClassByteAware)((Object)parent);
                try {
                    bytes = cba.getClassBytes(className);
                    if (bytes != null) {
                        return bytes;
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (null == resource) {
            return null;
        }
        return ClassByteUtil.readStream(resource.openStream()).toByteArray();
    }

    public static ByteArrayOutputStream readStream(InputStream inputStream) throws IOException {
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        byte[] buffer = new byte[1024];
        int return_value = -1;
        ByteArrayOutputStream output_stream = new ByteArrayOutputStream(buffer.length);
        return_value = inputStream.read(buffer);
        while (-1 != return_value) {
            output_stream.write(buffer, 0, return_value);
            return_value = inputStream.read(buffer);
        }
        output_stream.close();
        inputStream.close();
        return output_stream;
    }
}

